# Kalshi Trading API
Complete API for the Kalshi trading platform including all handlers for SDK generation

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.1.0
- Package version: 3.1.0
- Generator version: 7.17.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit []()

## Requirements.

Python 3.9+

## Installation & Usage
```python
pip install kalshi-python
import kalshi_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from kalshi_python import Configuration, KalshiClient

# Configure the client
config = Configuration(
    host="https://api.elections.kalshi.com/trade-api/v2"
)

# For authenticated requests
# Read private key from file
with open("path/to/private_key.pem", "r") as f:
    private_key = f.read()

config.api_key_id = "your-api-key-id"
config.private_key_pem = private_key

# Initialize the client
client = KalshiClient(config)

# Make API calls
balance = client.get_balance()
print(f"Balance: ${balance.balance / 100:.2f}")
```

## Documentation

Full documentation is available at [docs.kalshi.com](https://docs.kalshi.com)
