# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kalshi_python_async.models.structured_target import StructuredTarget
from typing import Optional, Set
from typing_extensions import Self

class GetStructuredTargetsResponse(BaseModel):
    """
    GetStructuredTargetsResponse
    """ # noqa: E501
    structured_targets: Optional[List[StructuredTarget]] = None
    cursor: Optional[StrictStr] = Field(default=None, description="Pagination cursor for the next page. Empty if there are no more results.")
    __properties: ClassVar[List[str]] = ["structured_targets", "cursor"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetStructuredTargetsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in structured_targets (list)
        _items = []
        if self.structured_targets:
            for _item_structured_targets in self.structured_targets:
                if _item_structured_targets:
                    _items.append(_item_structured_targets.to_dict())
            _dict['structured_targets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetStructuredTargetsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "structured_targets": [StructuredTarget.from_dict(_item) for _item in obj["structured_targets"]] if obj.get("structured_targets") is not None else None,
            "cursor": obj.get("cursor")
        })
        return _obj


