# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from kalshi_python_async.models.mve_selected_leg import MveSelectedLeg
from kalshi_python_async.models.price_range import PriceRange
from typing import Optional, Set
from typing_extensions import Self

class Market(BaseModel):
    """
    Market
    """ # noqa: E501
    ticker: StrictStr
    event_ticker: StrictStr
    market_type: StrictStr = Field(description="Identifies the type of market")
    title: StrictStr
    subtitle: StrictStr
    yes_sub_title: StrictStr = Field(description="Shortened title for the yes side of this market")
    no_sub_title: StrictStr = Field(description="Shortened title for the no side of this market")
    created_time: datetime
    open_time: datetime
    close_time: datetime
    expected_expiration_time: Optional[datetime] = Field(default=None, description="Time when this market is expected to expire")
    expiration_time: datetime
    latest_expiration_time: datetime = Field(description="Latest possible time for this market to expire")
    settlement_timer_seconds: StrictInt = Field(description="The amount of time after determination that the market settles")
    status: StrictStr
    response_price_units: StrictStr = Field(description="The units used to express all price related fields")
    yes_bid: Union[StrictFloat, StrictInt]
    yes_bid_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    yes_ask: Union[StrictFloat, StrictInt]
    yes_ask_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    no_bid: Union[StrictFloat, StrictInt]
    no_bid_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    no_ask: Union[StrictFloat, StrictInt]
    no_ask_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    last_price: Union[StrictFloat, StrictInt]
    last_price_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    volume: StrictInt
    volume_24h: StrictInt
    result: StrictStr
    can_close_early: StrictBool
    open_interest: StrictInt = Field(description="Number of contracts bought on this market disconsidering netting")
    notional_value: StrictInt = Field(description="The total value of a single contract at settlement in cents")
    notional_value_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    previous_yes_bid: StrictInt = Field(description="Price for the highest YES buy offer on this market a day ago in cents")
    previous_yes_bid_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    previous_yes_ask: StrictInt = Field(description="Price for the lowest YES sell offer on this market a day ago in cents")
    previous_yes_ask_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    previous_price: StrictInt = Field(description="Price for the last traded YES contract on this market a day ago in cents")
    previous_price_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    liquidity: StrictInt = Field(description="Value for current offers in this market in cents")
    liquidity_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    settlement_value: Optional[StrictInt] = Field(default=None, description="The settlement value of the YES/LONG side of the contract in cents. Only filled after determination")
    settlement_value_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    expiration_value: StrictStr = Field(description="The value that was considered for the settlement")
    category: StrictStr
    risk_limit_cents: StrictInt
    fee_waiver_expiration_time: Optional[datetime] = Field(default=None, description="Time when this market's fee waiver expires")
    early_close_condition: Optional[StrictStr] = Field(default=None, description="The condition under which the market can close early")
    tick_size: StrictInt = Field(description="The minimum price movement in the market")
    strike_type: Optional[StrictStr] = Field(default=None, description="Strike type defines how the market strike is defined and evaluated")
    floor_strike: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Minimum expiration value that leads to a YES settlement")
    cap_strike: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maximum expiration value that leads to a YES settlement")
    functional_strike: Optional[StrictStr] = Field(default=None, description="Mapping from expiration values to settlement values")
    custom_strike: Optional[Dict[str, Any]] = Field(default=None, description="Expiration value for each target that leads to a YES settlement")
    rules_primary: StrictStr = Field(description="A plain language description of the most important market terms")
    rules_secondary: StrictStr = Field(description="A plain language description of secondary market terms")
    mve_collection_ticker: Optional[StrictStr] = Field(default=None, description="The ticker of the multivariate event collection")
    mve_selected_legs: Optional[List[MveSelectedLeg]] = None
    primary_participant_key: Optional[StrictStr] = None
    price_level_structure: StrictStr = Field(description="Price level structure for this market, defining price ranges and tick sizes")
    price_ranges: List[PriceRange] = Field(description="Valid price ranges for orders on this market")
    __properties: ClassVar[List[str]] = ["ticker", "event_ticker", "market_type", "title", "subtitle", "yes_sub_title", "no_sub_title", "created_time", "open_time", "close_time", "expected_expiration_time", "expiration_time", "latest_expiration_time", "settlement_timer_seconds", "status", "response_price_units", "yes_bid", "yes_bid_dollars", "yes_ask", "yes_ask_dollars", "no_bid", "no_bid_dollars", "no_ask", "no_ask_dollars", "last_price", "last_price_dollars", "volume", "volume_24h", "result", "can_close_early", "open_interest", "notional_value", "notional_value_dollars", "previous_yes_bid", "previous_yes_bid_dollars", "previous_yes_ask", "previous_yes_ask_dollars", "previous_price", "previous_price_dollars", "liquidity", "liquidity_dollars", "settlement_value", "settlement_value_dollars", "expiration_value", "category", "risk_limit_cents", "fee_waiver_expiration_time", "early_close_condition", "tick_size", "strike_type", "floor_strike", "cap_strike", "functional_strike", "custom_strike", "rules_primary", "rules_secondary", "mve_collection_ticker", "mve_selected_legs", "primary_participant_key", "price_level_structure", "price_ranges"]

    @field_validator('market_type')
    def market_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['binary', 'scalar']):
            raise ValueError("must be one of enum values ('binary', 'scalar')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['initialized', 'active', 'closed', 'settled', 'determined']):
            raise ValueError("must be one of enum values ('initialized', 'active', 'closed', 'settled', 'determined')")
        return value

    @field_validator('response_price_units')
    def response_price_units_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['usd_cent']):
            raise ValueError("must be one of enum values ('usd_cent')")
        return value

    @field_validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['yes', 'no', '']):
            raise ValueError("must be one of enum values ('yes', 'no', '')")
        return value

    @field_validator('strike_type')
    def strike_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['greater', 'greater_or_equal', 'less', 'less_or_equal', 'between', 'functional', 'custom', 'structured']):
            raise ValueError("must be one of enum values ('greater', 'greater_or_equal', 'less', 'less_or_equal', 'between', 'functional', 'custom', 'structured')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Market from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in mve_selected_legs (list)
        _items = []
        if self.mve_selected_legs:
            for _item_mve_selected_legs in self.mve_selected_legs:
                if _item_mve_selected_legs:
                    _items.append(_item_mve_selected_legs.to_dict())
            _dict['mve_selected_legs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in price_ranges (list)
        _items = []
        if self.price_ranges:
            for _item_price_ranges in self.price_ranges:
                if _item_price_ranges:
                    _items.append(_item_price_ranges.to_dict())
            _dict['price_ranges'] = _items
        # set to None if expected_expiration_time (nullable) is None
        # and model_fields_set contains the field
        if self.expected_expiration_time is None and "expected_expiration_time" in self.model_fields_set:
            _dict['expected_expiration_time'] = None

        # set to None if settlement_value (nullable) is None
        # and model_fields_set contains the field
        if self.settlement_value is None and "settlement_value" in self.model_fields_set:
            _dict['settlement_value'] = None

        # set to None if fee_waiver_expiration_time (nullable) is None
        # and model_fields_set contains the field
        if self.fee_waiver_expiration_time is None and "fee_waiver_expiration_time" in self.model_fields_set:
            _dict['fee_waiver_expiration_time'] = None

        # set to None if early_close_condition (nullable) is None
        # and model_fields_set contains the field
        if self.early_close_condition is None and "early_close_condition" in self.model_fields_set:
            _dict['early_close_condition'] = None

        # set to None if floor_strike (nullable) is None
        # and model_fields_set contains the field
        if self.floor_strike is None and "floor_strike" in self.model_fields_set:
            _dict['floor_strike'] = None

        # set to None if cap_strike (nullable) is None
        # and model_fields_set contains the field
        if self.cap_strike is None and "cap_strike" in self.model_fields_set:
            _dict['cap_strike'] = None

        # set to None if functional_strike (nullable) is None
        # and model_fields_set contains the field
        if self.functional_strike is None and "functional_strike" in self.model_fields_set:
            _dict['functional_strike'] = None

        # set to None if custom_strike (nullable) is None
        # and model_fields_set contains the field
        if self.custom_strike is None and "custom_strike" in self.model_fields_set:
            _dict['custom_strike'] = None

        # set to None if primary_participant_key (nullable) is None
        # and model_fields_set contains the field
        if self.primary_participant_key is None and "primary_participant_key" in self.model_fields_set:
            _dict['primary_participant_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Market from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "event_ticker": obj.get("event_ticker"),
            "market_type": obj.get("market_type"),
            "title": obj.get("title"),
            "subtitle": obj.get("subtitle"),
            "yes_sub_title": obj.get("yes_sub_title"),
            "no_sub_title": obj.get("no_sub_title"),
            "created_time": obj.get("created_time"),
            "open_time": obj.get("open_time"),
            "close_time": obj.get("close_time"),
            "expected_expiration_time": obj.get("expected_expiration_time"),
            "expiration_time": obj.get("expiration_time"),
            "latest_expiration_time": obj.get("latest_expiration_time"),
            "settlement_timer_seconds": obj.get("settlement_timer_seconds"),
            "status": obj.get("status"),
            "response_price_units": obj.get("response_price_units"),
            "yes_bid": obj.get("yes_bid"),
            "yes_bid_dollars": obj.get("yes_bid_dollars"),
            "yes_ask": obj.get("yes_ask"),
            "yes_ask_dollars": obj.get("yes_ask_dollars"),
            "no_bid": obj.get("no_bid"),
            "no_bid_dollars": obj.get("no_bid_dollars"),
            "no_ask": obj.get("no_ask"),
            "no_ask_dollars": obj.get("no_ask_dollars"),
            "last_price": obj.get("last_price"),
            "last_price_dollars": obj.get("last_price_dollars"),
            "volume": obj.get("volume"),
            "volume_24h": obj.get("volume_24h"),
            "result": obj.get("result"),
            "can_close_early": obj.get("can_close_early"),
            "open_interest": obj.get("open_interest"),
            "notional_value": obj.get("notional_value"),
            "notional_value_dollars": obj.get("notional_value_dollars"),
            "previous_yes_bid": obj.get("previous_yes_bid"),
            "previous_yes_bid_dollars": obj.get("previous_yes_bid_dollars"),
            "previous_yes_ask": obj.get("previous_yes_ask"),
            "previous_yes_ask_dollars": obj.get("previous_yes_ask_dollars"),
            "previous_price": obj.get("previous_price"),
            "previous_price_dollars": obj.get("previous_price_dollars"),
            "liquidity": obj.get("liquidity"),
            "liquidity_dollars": obj.get("liquidity_dollars"),
            "settlement_value": obj.get("settlement_value"),
            "settlement_value_dollars": obj.get("settlement_value_dollars"),
            "expiration_value": obj.get("expiration_value"),
            "category": obj.get("category"),
            "risk_limit_cents": obj.get("risk_limit_cents"),
            "fee_waiver_expiration_time": obj.get("fee_waiver_expiration_time"),
            "early_close_condition": obj.get("early_close_condition"),
            "tick_size": obj.get("tick_size"),
            "strike_type": obj.get("strike_type"),
            "floor_strike": obj.get("floor_strike"),
            "cap_strike": obj.get("cap_strike"),
            "functional_strike": obj.get("functional_strike"),
            "custom_strike": obj.get("custom_strike"),
            "rules_primary": obj.get("rules_primary"),
            "rules_secondary": obj.get("rules_secondary"),
            "mve_collection_ticker": obj.get("mve_collection_ticker"),
            "mve_selected_legs": [MveSelectedLeg.from_dict(_item) for _item in obj["mve_selected_legs"]] if obj.get("mve_selected_legs") is not None else None,
            "primary_participant_key": obj.get("primary_participant_key"),
            "price_level_structure": obj.get("price_level_structure"),
            "price_ranges": [PriceRange.from_dict(_item) for _item in obj["price_ranges"]] if obj.get("price_ranges") is not None else None
        })
        return _obj


