# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from kalshi_python_async.models.maintenance_window import MaintenanceWindow
from kalshi_python_async.models.weekly_schedule import WeeklySchedule
from typing import Optional, Set
from typing_extensions import Self

class Schedule(BaseModel):
    """
    Schedule
    """ # noqa: E501
    standard_hours: List[WeeklySchedule] = Field(description="The standard operating hours of the exchange. All times are expressed in ET. Outside of these times trading will be unavailable.")
    maintenance_windows: List[MaintenanceWindow] = Field(description="Scheduled maintenance windows, during which the exchange may be unavailable.")
    __properties: ClassVar[List[str]] = ["standard_hours", "maintenance_windows"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Schedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in standard_hours (list)
        _items = []
        if self.standard_hours:
            for _item_standard_hours in self.standard_hours:
                if _item_standard_hours:
                    _items.append(_item_standard_hours.to_dict())
            _dict['standard_hours'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in maintenance_windows (list)
        _items = []
        if self.maintenance_windows:
            for _item_maintenance_windows in self.maintenance_windows:
                if _item_maintenance_windows:
                    _items.append(_item_maintenance_windows.to_dict())
            _dict['maintenance_windows'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Schedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "standard_hours": [WeeklySchedule.from_dict(_item) for _item in obj["standard_hours"]] if obj.get("standard_hours") is not None else None,
            "maintenance_windows": [MaintenanceWindow.from_dict(_item) for _item in obj["maintenance_windows"]] if obj.get("maintenance_windows") is not None else None
        })
        return _obj


