# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MarketPosition(BaseModel):
    """
    MarketPosition
    """ # noqa: E501
    ticker: StrictStr = Field(description="Unique identifier for the market")
    total_traded: StrictInt = Field(description="Total spent on this market in cents")
    total_traded_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    position: StrictInt = Field(description="Number of contracts bought in this market. Negative means NO contracts and positive means YES contracts")
    market_exposure: StrictInt = Field(description="Cost of the aggregate market position in cents")
    market_exposure_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    realized_pnl: StrictInt = Field(description="Locked in profit and loss, in cents")
    realized_pnl_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    resting_orders_count: StrictInt = Field(description="[DEPRECATED] Aggregate size of resting orders in contract units")
    fees_paid: StrictInt = Field(description="Fees paid on fill orders, in cents")
    fees_paid_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    last_updated_ts: Optional[datetime] = Field(default=None, description="Last time the position is updated")
    __properties: ClassVar[List[str]] = ["ticker", "total_traded", "total_traded_dollars", "position", "market_exposure", "market_exposure_dollars", "realized_pnl", "realized_pnl_dollars", "resting_orders_count", "fees_paid", "fees_paid_dollars", "last_updated_ts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MarketPosition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MarketPosition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "total_traded": obj.get("total_traded"),
            "total_traded_dollars": obj.get("total_traded_dollars"),
            "position": obj.get("position"),
            "market_exposure": obj.get("market_exposure"),
            "market_exposure_dollars": obj.get("market_exposure_dollars"),
            "realized_pnl": obj.get("realized_pnl"),
            "realized_pnl_dollars": obj.get("realized_pnl_dollars"),
            "resting_orders_count": obj.get("resting_orders_count"),
            "fees_paid": obj.get("fees_paid"),
            "fees_paid_dollars": obj.get("fees_paid_dollars"),
            "last_updated_ts": obj.get("last_updated_ts")
        })
        return _obj


