# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AssociatedEvent(BaseModel):
    """
    AssociatedEvent
    """ # noqa: E501
    ticker: StrictStr = Field(description="The event ticker.")
    is_yes_only: StrictBool = Field(description="Whether only the 'yes' side can be used for this event.")
    size_max: Optional[StrictInt] = Field(default=None, description="Maximum number of markets from this event (inclusive). Null means no limit.")
    size_min: Optional[StrictInt] = Field(default=None, description="Minimum number of markets from this event (inclusive). Null means no limit.")
    active_quoters: List[StrictStr] = Field(description="List of active quoters for this event.")
    __properties: ClassVar[List[str]] = ["ticker", "is_yes_only", "size_max", "size_min", "active_quoters"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssociatedEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if size_max (nullable) is None
        # and model_fields_set contains the field
        if self.size_max is None and "size_max" in self.model_fields_set:
            _dict['size_max'] = None

        # set to None if size_min (nullable) is None
        # and model_fields_set contains the field
        if self.size_min is None and "size_min" in self.model_fields_set:
            _dict['size_min'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssociatedEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "is_yes_only": obj.get("is_yes_only"),
            "size_max": obj.get("size_max"),
            "size_min": obj.get("size_min"),
            "active_quoters": obj.get("active_quoters")
        })
        return _obj


