# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from kalshi_python_async.models.self_trade_prevention_type import SelfTradePreventionType
from typing import Optional, Set
from typing_extensions import Self

class CreateOrderRequest(BaseModel):
    """
    CreateOrderRequest
    """ # noqa: E501
    ticker: StrictStr
    client_order_id: Optional[StrictStr] = None
    side: StrictStr
    action: StrictStr
    count: Annotated[int, Field(strict=True, ge=1)]
    type: Optional[StrictStr] = None
    yes_price: Optional[Annotated[int, Field(le=99, strict=True, ge=1)]] = None
    no_price: Optional[Annotated[int, Field(le=99, strict=True, ge=1)]] = None
    yes_price_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    no_price_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    expiration_ts: Optional[StrictInt] = None
    time_in_force: Optional[StrictStr] = None
    buy_max_cost: Optional[StrictInt] = Field(default=None, description="Maximum cost in cents. When specified, the order will automatically have Fill-or-Kill (FoK) behavior.")
    post_only: Optional[StrictBool] = None
    reduce_only: Optional[StrictBool] = None
    sell_position_floor: Optional[StrictInt] = Field(default=None, description="Deprecated: Use reduce_only instead. Only accepts value of 0.")
    self_trade_prevention_type: Optional[SelfTradePreventionType] = None
    order_group_id: Optional[StrictStr] = Field(default=None, description="The order group this order is part of")
    cancel_order_on_pause: Optional[StrictBool] = Field(default=None, description="If this flag is set to true, the order will be canceled if the order is open and trading on the exchange is paused for any reason.")
    __properties: ClassVar[List[str]] = ["ticker", "client_order_id", "side", "action", "count", "type", "yes_price", "no_price", "yes_price_dollars", "no_price_dollars", "expiration_ts", "time_in_force", "buy_max_cost", "post_only", "reduce_only", "sell_position_floor", "self_trade_prevention_type", "order_group_id", "cancel_order_on_pause"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['limit', 'market']):
            raise ValueError("must be one of enum values ('limit', 'market')")
        return value

    @field_validator('time_in_force')
    def time_in_force_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['fill_or_kill', 'good_till_canceled', 'immediate_or_cancel']):
            raise ValueError("must be one of enum values ('fill_or_kill', 'good_till_canceled', 'immediate_or_cancel')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateOrderRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateOrderRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "client_order_id": obj.get("client_order_id"),
            "side": obj.get("side"),
            "action": obj.get("action"),
            "count": obj.get("count"),
            "type": obj.get("type"),
            "yes_price": obj.get("yes_price"),
            "no_price": obj.get("no_price"),
            "yes_price_dollars": obj.get("yes_price_dollars"),
            "no_price_dollars": obj.get("no_price_dollars"),
            "expiration_ts": obj.get("expiration_ts"),
            "time_in_force": obj.get("time_in_force"),
            "buy_max_cost": obj.get("buy_max_cost"),
            "post_only": obj.get("post_only"),
            "reduce_only": obj.get("reduce_only"),
            "sell_position_floor": obj.get("sell_position_floor"),
            "self_trade_prevention_type": obj.get("self_trade_prevention_type"),
            "order_group_id": obj.get("order_group_id"),
            "cancel_order_on_pause": obj.get("cancel_order_on_pause")
        })
        return _obj


