# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kalshi_python_async.models.event_position import EventPosition
from kalshi_python_async.models.market_position import MarketPosition
from typing import Optional, Set
from typing_extensions import Self

class GetPositionsResponse(BaseModel):
    """
    GetPositionsResponse
    """ # noqa: E501
    cursor: Optional[StrictStr] = Field(default=None, description="The Cursor represents a pointer to the next page of records in the pagination. Use the value returned here in the cursor query parameter for this end-point to get the next page containing limit records. An empty value of this field indicates there is no next page.")
    market_positions: List[MarketPosition] = Field(description="List of market positions")
    event_positions: List[EventPosition] = Field(description="List of event positions")
    __properties: ClassVar[List[str]] = ["cursor", "market_positions", "event_positions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetPositionsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in market_positions (list)
        _items = []
        if self.market_positions:
            for _item_market_positions in self.market_positions:
                if _item_market_positions:
                    _items.append(_item_market_positions.to_dict())
            _dict['market_positions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in event_positions (list)
        _items = []
        if self.event_positions:
            for _item_event_positions in self.event_positions:
                if _item_event_positions:
                    _items.append(_item_event_positions.to_dict())
            _dict['event_positions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetPositionsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cursor": obj.get("cursor"),
            "market_positions": [MarketPosition.from_dict(_item) for _item in obj["market_positions"]] if obj.get("market_positions") is not None else None,
            "event_positions": [EventPosition.from_dict(_item) for _item in obj["event_positions"]] if obj.get("event_positions") is not None else None
        })
        return _obj


