# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from kalshi_python_async.models.order_status import OrderStatus
from kalshi_python_async.models.self_trade_prevention_type import SelfTradePreventionType
from typing import Optional, Set
from typing_extensions import Self

class Order(BaseModel):
    """
    Order
    """ # noqa: E501
    order_id: StrictStr
    user_id: StrictStr = Field(description="Unique identifier for users")
    client_order_id: StrictStr
    ticker: StrictStr
    side: StrictStr
    action: StrictStr
    type: StrictStr
    status: OrderStatus
    yes_price: StrictInt
    no_price: StrictInt
    yes_price_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    no_price_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    fill_count: StrictInt = Field(description="The number of contracts that have been filled")
    remaining_count: StrictInt
    initial_count: StrictInt = Field(description="The initial size of the order (contract units)")
    taker_fees: StrictInt = Field(description="Fees paid on filled taker contracts, in cents")
    maker_fees: StrictInt = Field(description="Fees paid on filled maker contracts, in cents")
    taker_fill_cost: StrictInt = Field(description="The cost of filled taker orders in cents")
    maker_fill_cost: StrictInt = Field(description="The cost of filled maker orders in cents")
    taker_fill_cost_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    maker_fill_cost_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    queue_position: StrictInt = Field(description="**DEPRECATED**: This field is deprecated and will always return 0. Please use the GET /portfolio/orders/{order_id}/queue_position endpoint instead")
    taker_fees_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    maker_fees_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    expiration_time: Optional[datetime] = None
    created_time: Optional[datetime] = None
    last_update_time: Optional[datetime] = Field(default=None, description="The last update to an order (modify, cancel, fill)")
    self_trade_prevention_type: Optional[SelfTradePreventionType] = None
    order_group_id: Optional[StrictStr] = Field(default=None, description="The order group this order is part of")
    cancel_order_on_pause: Optional[StrictBool] = Field(default=None, description="If this flag is set to true, the order will be canceled if the order is open and trading on the exchange is paused for any reason.")
    __properties: ClassVar[List[str]] = ["order_id", "user_id", "client_order_id", "ticker", "side", "action", "type", "status", "yes_price", "no_price", "yes_price_dollars", "no_price_dollars", "fill_count", "remaining_count", "initial_count", "taker_fees", "maker_fees", "taker_fill_cost", "maker_fill_cost", "taker_fill_cost_dollars", "maker_fill_cost_dollars", "queue_position", "taker_fees_dollars", "maker_fees_dollars", "expiration_time", "created_time", "last_update_time", "self_trade_prevention_type", "order_group_id", "cancel_order_on_pause"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['limit', 'market']):
            raise ValueError("must be one of enum values ('limit', 'market')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Order from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if expiration_time (nullable) is None
        # and model_fields_set contains the field
        if self.expiration_time is None and "expiration_time" in self.model_fields_set:
            _dict['expiration_time'] = None

        # set to None if created_time (nullable) is None
        # and model_fields_set contains the field
        if self.created_time is None and "created_time" in self.model_fields_set:
            _dict['created_time'] = None

        # set to None if last_update_time (nullable) is None
        # and model_fields_set contains the field
        if self.last_update_time is None and "last_update_time" in self.model_fields_set:
            _dict['last_update_time'] = None

        # set to None if order_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.order_group_id is None and "order_group_id" in self.model_fields_set:
            _dict['order_group_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Order from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "order_id": obj.get("order_id"),
            "user_id": obj.get("user_id"),
            "client_order_id": obj.get("client_order_id"),
            "ticker": obj.get("ticker"),
            "side": obj.get("side"),
            "action": obj.get("action"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "yes_price": obj.get("yes_price"),
            "no_price": obj.get("no_price"),
            "yes_price_dollars": obj.get("yes_price_dollars"),
            "no_price_dollars": obj.get("no_price_dollars"),
            "fill_count": obj.get("fill_count"),
            "remaining_count": obj.get("remaining_count"),
            "initial_count": obj.get("initial_count"),
            "taker_fees": obj.get("taker_fees"),
            "maker_fees": obj.get("maker_fees"),
            "taker_fill_cost": obj.get("taker_fill_cost"),
            "maker_fill_cost": obj.get("maker_fill_cost"),
            "taker_fill_cost_dollars": obj.get("taker_fill_cost_dollars"),
            "maker_fill_cost_dollars": obj.get("maker_fill_cost_dollars"),
            "queue_position": obj.get("queue_position"),
            "taker_fees_dollars": obj.get("taker_fees_dollars"),
            "maker_fees_dollars": obj.get("maker_fees_dollars"),
            "expiration_time": obj.get("expiration_time"),
            "created_time": obj.get("created_time"),
            "last_update_time": obj.get("last_update_time"),
            "self_trade_prevention_type": obj.get("self_trade_prevention_type"),
            "order_group_id": obj.get("order_group_id"),
            "cancel_order_on_pause": obj.get("cancel_order_on_pause")
        })
        return _obj


