# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from kalshi_python_async.models.mve_selected_leg import MveSelectedLeg
from typing import Optional, Set
from typing_extensions import Self

class RFQ(BaseModel):
    """
    RFQ
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the RFQ")
    creator_id: StrictStr = Field(description="Public communications ID of the RFQ creator")
    market_ticker: StrictStr = Field(description="The ticker of the market this RFQ is for")
    contracts: StrictInt = Field(description="Number of contracts requested in the RFQ")
    target_cost_centi_cents: Optional[StrictInt] = Field(default=None, description="Total value of the RFQ in centi-cents")
    status: StrictStr = Field(description="Current status of the RFQ (open, closed)")
    created_ts: datetime = Field(description="Timestamp when the RFQ was created")
    mve_collection_ticker: Optional[StrictStr] = Field(default=None, description="Ticker of the MVE collection this market belongs to")
    mve_selected_legs: Optional[List[MveSelectedLeg]] = Field(default=None, description="Selected legs for the MVE collection")
    rest_remainder: Optional[StrictBool] = Field(default=None, description="Whether to rest the remainder of the RFQ after execution")
    cancellation_reason: Optional[StrictStr] = Field(default=None, description="Reason for RFQ cancellation if cancelled")
    creator_user_id: Optional[StrictStr] = Field(default=None, description="User ID of the RFQ creator (private field)")
    cancelled_ts: Optional[datetime] = Field(default=None, description="Timestamp when the RFQ was cancelled")
    updated_ts: Optional[datetime] = Field(default=None, description="Timestamp when the RFQ was last updated")
    __properties: ClassVar[List[str]] = ["id", "creator_id", "market_ticker", "contracts", "target_cost_centi_cents", "status", "created_ts", "mve_collection_ticker", "mve_selected_legs", "rest_remainder", "cancellation_reason", "creator_user_id", "cancelled_ts", "updated_ts"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['open', 'closed']):
            raise ValueError("must be one of enum values ('open', 'closed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RFQ from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in mve_selected_legs (list)
        _items = []
        if self.mve_selected_legs:
            for _item_mve_selected_legs in self.mve_selected_legs:
                if _item_mve_selected_legs:
                    _items.append(_item_mve_selected_legs.to_dict())
            _dict['mve_selected_legs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RFQ from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "creator_id": obj.get("creator_id"),
            "market_ticker": obj.get("market_ticker"),
            "contracts": obj.get("contracts"),
            "target_cost_centi_cents": obj.get("target_cost_centi_cents"),
            "status": obj.get("status"),
            "created_ts": obj.get("created_ts"),
            "mve_collection_ticker": obj.get("mve_collection_ticker"),
            "mve_selected_legs": [MveSelectedLeg.from_dict(_item) for _item in obj["mve_selected_legs"]] if obj.get("mve_selected_legs") is not None else None,
            "rest_remainder": obj.get("rest_remainder"),
            "cancellation_reason": obj.get("cancellation_reason"),
            "creator_user_id": obj.get("creator_user_id"),
            "cancelled_ts": obj.get("cancelled_ts"),
            "updated_ts": obj.get("updated_ts")
        })
        return _obj


