# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from kalshi_python_async.models.settlement_source import SettlementSource
from typing import Optional, Set
from typing_extensions import Self

class Series(BaseModel):
    """
    Series
    """ # noqa: E501
    ticker: StrictStr = Field(description="Ticker that identifies this series.")
    frequency: StrictStr = Field(description="Description of the frequency of the series. There is no fixed value set here, but will be something human-readable like weekly, daily, one-off.")
    title: StrictStr = Field(description="Title describing the series. For full context use you should use this field with the title field of the events belonging to this series.")
    category: StrictStr = Field(description="Category specifies the category which this series belongs to.")
    tags: List[StrictStr] = Field(description="Tags specifies the subjects that this series relates to, multiple series from different categories can have the same tags.")
    settlement_sources: List[SettlementSource] = Field(description="SettlementSources specifies the official sources used for the determination of markets within the series. Methodology is defined in the rulebook.")
    contract_url: StrictStr = Field(description="ContractUrl provides a direct link to the original filing of the contract which underlies the series.")
    contract_terms_url: StrictStr = Field(description="ContractTermsUrl is the URL to the current terms of the contract underlying the series.")
    product_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Internal product metadata of the series.")
    fee_type: StrictStr = Field(description="FeeType is a string representing the series' fee structure. Fee structures can be found at https://kalshi.com/docs/kalshi-fee-schedule.pdf. 'quadratic' is described by the General Trading Fees Table, 'quadratic_with_maker_fees' is described by the General Trading Fees Table with maker fees described in the Maker Fees section, 'flat' is described by the Specific Trading Fees Table.")
    fee_multiplier: Union[StrictFloat, StrictInt] = Field(description="FeeMultiplier is a floating point multiplier applied to the fee calculations.")
    additional_prohibitions: List[StrictStr] = Field(description="AdditionalProhibitions is a list of additional trading prohibitions for this series.")
    __properties: ClassVar[List[str]] = ["ticker", "frequency", "title", "category", "tags", "settlement_sources", "contract_url", "contract_terms_url", "product_metadata", "fee_type", "fee_multiplier", "additional_prohibitions"]

    @field_validator('fee_type')
    def fee_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['quadratic', 'quadratic_with_maker_fees', 'flat']):
            raise ValueError("must be one of enum values ('quadratic', 'quadratic_with_maker_fees', 'flat')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Series from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in settlement_sources (list)
        _items = []
        if self.settlement_sources:
            for _item_settlement_sources in self.settlement_sources:
                if _item_settlement_sources:
                    _items.append(_item_settlement_sources.to_dict())
            _dict['settlement_sources'] = _items
        # set to None if product_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.product_metadata is None and "product_metadata" in self.model_fields_set:
            _dict['product_metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Series from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "frequency": obj.get("frequency"),
            "title": obj.get("title"),
            "category": obj.get("category"),
            "tags": obj.get("tags"),
            "settlement_sources": [SettlementSource.from_dict(_item) for _item in obj["settlement_sources"]] if obj.get("settlement_sources") is not None else None,
            "contract_url": obj.get("contract_url"),
            "contract_terms_url": obj.get("contract_terms_url"),
            "product_metadata": obj.get("product_metadata"),
            "fee_type": obj.get("fee_type"),
            "fee_multiplier": obj.get("fee_multiplier"),
            "additional_prohibitions": obj.get("additional_prohibitions")
        })
        return _obj


