# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from kalshi_python_async.models.sport_filter_details import SportFilterDetails
from typing import Optional, Set
from typing_extensions import Self

class GetFiltersBySportsResponse(BaseModel):
    """
    GetFiltersBySportsResponse
    """ # noqa: E501
    filters_by_sports: Dict[str, SportFilterDetails] = Field(description="Mapping of sports to their filter details")
    sport_ordering: List[StrictStr] = Field(description="Ordered list of sports for display")
    __properties: ClassVar[List[str]] = ["filters_by_sports", "sport_ordering"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetFiltersBySportsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in filters_by_sports (dict)
        _field_dict = {}
        if self.filters_by_sports:
            for _key_filters_by_sports in self.filters_by_sports:
                if self.filters_by_sports[_key_filters_by_sports]:
                    _field_dict[_key_filters_by_sports] = self.filters_by_sports[_key_filters_by_sports].to_dict()
            _dict['filters_by_sports'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetFiltersBySportsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "filters_by_sports": dict(
                (_k, SportFilterDetails.from_dict(_v))
                for _k, _v in obj["filters_by_sports"].items()
            )
            if obj.get("filters_by_sports") is not None
            else None,
            "sport_ordering": obj.get("sport_ordering")
        })
        return _obj


