# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from kalshi_python_async.models.associated_event import AssociatedEvent
from typing import Optional, Set
from typing_extensions import Self

class MultivariateEventCollection(BaseModel):
    """
    MultivariateEventCollection
    """ # noqa: E501
    collection_ticker: StrictStr = Field(description="Unique identifier for the collection.")
    series_ticker: StrictStr = Field(description="Series associated with the collection. Events produced in the collection will be associated with this series.")
    title: StrictStr = Field(description="Title of the collection.")
    description: StrictStr = Field(description="Short description of the collection.")
    open_date: datetime = Field(description="The open date of the collection. Before this time, the collection cannot be interacted with.")
    close_date: datetime = Field(description="The close date of the collection. After this time, the collection cannot be interacted with.")
    associated_events: List[AssociatedEvent] = Field(description="List of events with their individual configuration.")
    associated_event_tickers: List[StrictStr] = Field(description="[DEPRECATED - Use associated_events instead] A list of events associated with the collection. Markets in these events can be passed as inputs to the Lookup and Create endpoints.")
    is_ordered: StrictBool = Field(description="Whether the collection is ordered. If true, the order of markets passed into Lookup/Create affects the output. If false, the order does not matter.")
    is_single_market_per_event: StrictBool = Field(description="[DEPRECATED - Use associated_events instead] Whether the collection accepts multiple markets from the same event passed into Lookup/Create.")
    is_all_yes: StrictBool = Field(description="[DEPRECATED - Use associated_events instead] Whether the collection requires that only the market side of 'yes' may be used.")
    size_min: StrictInt = Field(description="The minimum number of markets that must be passed into Lookup/Create (inclusive).")
    size_max: StrictInt = Field(description="The maximum number of markets that must be passed into Lookup/Create (inclusive).")
    functional_description: StrictStr = Field(description="A functional description of the collection describing how inputs affect the output.")
    __properties: ClassVar[List[str]] = ["collection_ticker", "series_ticker", "title", "description", "open_date", "close_date", "associated_events", "associated_event_tickers", "is_ordered", "is_single_market_per_event", "is_all_yes", "size_min", "size_max", "functional_description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MultivariateEventCollection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associated_events (list)
        _items = []
        if self.associated_events:
            for _item_associated_events in self.associated_events:
                if _item_associated_events:
                    _items.append(_item_associated_events.to_dict())
            _dict['associated_events'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MultivariateEventCollection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collection_ticker": obj.get("collection_ticker"),
            "series_ticker": obj.get("series_ticker"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "open_date": obj.get("open_date"),
            "close_date": obj.get("close_date"),
            "associated_events": [AssociatedEvent.from_dict(_item) for _item in obj["associated_events"]] if obj.get("associated_events") is not None else None,
            "associated_event_tickers": obj.get("associated_event_tickers"),
            "is_ordered": obj.get("is_ordered"),
            "is_single_market_per_event": obj.get("is_single_market_per_event"),
            "is_all_yes": obj.get("is_all_yes"),
            "size_min": obj.get("size_min"),
            "size_max": obj.get("size_max"),
            "functional_description": obj.get("functional_description")
        })
        return _obj


