# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.6.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt, StrictBool
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from kalshi_python_async.models.batch_get_market_candlesticks_response import BatchGetMarketCandlesticksResponse
from kalshi_python_async.models.get_market_candlesticks_response import GetMarketCandlesticksResponse
from kalshi_python_async.models.get_market_orderbook_response import GetMarketOrderbookResponse
from kalshi_python_async.models.get_market_response import GetMarketResponse
from kalshi_python_async.models.get_markets_response import GetMarketsResponse
from kalshi_python_async.models.get_series_list_response import GetSeriesListResponse
from kalshi_python_async.models.get_series_response import GetSeriesResponse
from kalshi_python_async.models.get_trades_response import GetTradesResponse

from kalshi_python_async.api_client import ApiClient, RequestSerialized
from kalshi_python_async.api_response import ApiResponse
from kalshi_python_async.rest import RESTResponseType


class MarketApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def batch_get_market_candlesticks(
        self,
        market_tickers: Any,
        start_ts: Any,
        end_ts: Any,
        period_interval: Any,
        include_latest_before_start: Any = None,
    ) -> BatchGetMarketCandlesticksResponse:
        """Batch Get Market Candlesticks

        Endpoint for retrieving candlestick data for multiple markets.  - Accepts up to 100 market tickers per request - Returns up to 10,000 candlesticks total across all markets - Returns candlesticks grouped by market_id - Optionally includes a synthetic initial candlestick for price continuity (see `include_latest_before_start` parameter) 

        :param market_tickers: Comma-separated list of market tickers (maximum 100) (required)
        :type market_tickers: str
        :param start_ts: Start timestamp in Unix seconds (required)
        :type start_ts: int
        :param end_ts: End timestamp in Unix seconds (required)
        :type end_ts: int
        :param period_interval: Candlestick period interval in minutes (required)
        :type period_interval: int
        :param include_latest_before_start: If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick 
        :type include_latest_before_start: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._batch_get_market_candlesticks_serialize(
            market_tickers=market_tickers,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            include_latest_before_start=include_latest_before_start,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchGetMarketCandlesticksResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def batch_get_market_candlesticks_with_http_info(
        self,
        market_tickers: Annotated[StrictStr, Field(description="Comma-separated list of market tickers (maximum 100)")],
        start_ts: Annotated[StrictInt, Field(description="Start timestamp in Unix seconds")],
        end_ts: Annotated[StrictInt, Field(description="End timestamp in Unix seconds")],
        period_interval: Annotated[int, Field(strict=True, ge=1, description="Candlestick period interval in minutes")],
        include_latest_before_start: Annotated[Optional[StrictBool], Field(description="If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BatchGetMarketCandlesticksResponse]:
        """Batch Get Market Candlesticks

        Endpoint for retrieving candlestick data for multiple markets.  - Accepts up to 100 market tickers per request - Returns up to 10,000 candlesticks total across all markets - Returns candlesticks grouped by market_id - Optionally includes a synthetic initial candlestick for price continuity (see `include_latest_before_start` parameter) 

        :param market_tickers: Comma-separated list of market tickers (maximum 100) (required)
        :type market_tickers: str
        :param start_ts: Start timestamp in Unix seconds (required)
        :type start_ts: int
        :param end_ts: End timestamp in Unix seconds (required)
        :type end_ts: int
        :param period_interval: Candlestick period interval in minutes (required)
        :type period_interval: int
        :param include_latest_before_start: If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick 
        :type include_latest_before_start: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_get_market_candlesticks_serialize(
            market_tickers=market_tickers,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            include_latest_before_start=include_latest_before_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchGetMarketCandlesticksResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def batch_get_market_candlesticks_without_preload_content(
        self,
        market_tickers: Annotated[StrictStr, Field(description="Comma-separated list of market tickers (maximum 100)")],
        start_ts: Annotated[StrictInt, Field(description="Start timestamp in Unix seconds")],
        end_ts: Annotated[StrictInt, Field(description="End timestamp in Unix seconds")],
        period_interval: Annotated[int, Field(strict=True, ge=1, description="Candlestick period interval in minutes")],
        include_latest_before_start: Annotated[Optional[StrictBool], Field(description="If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Batch Get Market Candlesticks

        Endpoint for retrieving candlestick data for multiple markets.  - Accepts up to 100 market tickers per request - Returns up to 10,000 candlesticks total across all markets - Returns candlesticks grouped by market_id - Optionally includes a synthetic initial candlestick for price continuity (see `include_latest_before_start` parameter) 

        :param market_tickers: Comma-separated list of market tickers (maximum 100) (required)
        :type market_tickers: str
        :param start_ts: Start timestamp in Unix seconds (required)
        :type start_ts: int
        :param end_ts: End timestamp in Unix seconds (required)
        :type end_ts: int
        :param period_interval: Candlestick period interval in minutes (required)
        :type period_interval: int
        :param include_latest_before_start: If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick 
        :type include_latest_before_start: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_get_market_candlesticks_serialize(
            market_tickers=market_tickers,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            include_latest_before_start=include_latest_before_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchGetMarketCandlesticksResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _batch_get_market_candlesticks_serialize(
        self,
        market_tickers,
        start_ts,
        end_ts,
        period_interval,
        include_latest_before_start,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if market_tickers is not None:
            
            _query_params.append(('market_tickers', market_tickers))
            
        if start_ts is not None:
            
            _query_params.append(('start_ts', start_ts))
            
        if end_ts is not None:
            
            _query_params.append(('end_ts', end_ts))
            
        if period_interval is not None:
            
            _query_params.append(('period_interval', period_interval))
            
        if include_latest_before_start is not None:
            
            _query_params.append(('include_latest_before_start', include_latest_before_start))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets/candlesticks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_market(
        self,
        ticker: StrictStr,
    ) -> GetMarketResponse:
        """Get Market

         Endpoint for getting data about a specific market by its ticker. A market represents a specific binary outcome within an event that users can trade on (e.g., \"Will candidate X win?\"). Markets have yes/no positions, current prices, volume, and settlement rules.

        :param ticker: Market ticker (required)
        :type ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_market_serialize(
            ticker=ticker,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketResponse",
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_market_with_http_info(
        self,
        ticker: Annotated[StrictStr, Field(description="Market ticker")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMarketResponse]:
        """Get Market

         Endpoint for getting data about a specific market by its ticker. A market represents a specific binary outcome within an event that users can trade on (e.g., \"Will candidate X win?\"). Markets have yes/no positions, current prices, volume, and settlement rules.

        :param ticker: Market ticker (required)
        :type ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_serialize(
            ticker=ticker,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketResponse",
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_market_without_preload_content(
        self,
        ticker: Annotated[StrictStr, Field(description="Market ticker")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Market

         Endpoint for getting data about a specific market by its ticker. A market represents a specific binary outcome within an event that users can trade on (e.g., \"Will candidate X win?\"). Markets have yes/no positions, current prices, volume, and settlement rules.

        :param ticker: Market ticker (required)
        :type ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_serialize(
            ticker=ticker,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketResponse",
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_market_serialize(
        self,
        ticker,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ticker is not None:
            _path_params['ticker'] = ticker
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets/{ticker}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_market_candlesticks(
        self,
        series_ticker: StrictStr,
        ticker: StrictStr,
        start_ts: Any,
        end_ts: Any,
        period_interval: Any,
        include_latest_before_start: Any = None,
    ) -> GetMarketCandlesticksResponse:
        """Get Market Candlesticks

        Time period length of each candlestick in minutes. Valid values: 1 (1 minute), 60 (1 hour), 1440 (1 day).

        :param series_ticker: Series ticker - the series that contains the target market (required)
        :type series_ticker: str
        :param ticker: Market ticker - unique identifier for the specific market (required)
        :type ticker: str
        :param start_ts: Start timestamp (Unix timestamp). Candlesticks will include those ending on or after this time. (required)
        :type start_ts: int
        :param end_ts: End timestamp (Unix timestamp). Candlesticks will include those ending on or before this time. (required)
        :type end_ts: int
        :param period_interval: Time period length of each candlestick in minutes. Valid values are 1 (1 minute), 60 (1 hour), or 1440 (1 day). (required)
        :type period_interval: int
        :param include_latest_before_start: If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick 
        :type include_latest_before_start: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_market_candlesticks_serialize(
            series_ticker=series_ticker,
            ticker=ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            include_latest_before_start=include_latest_before_start,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketCandlesticksResponse",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_market_candlesticks_with_http_info(
        self,
        series_ticker: Annotated[StrictStr, Field(description="Series ticker - the series that contains the target market")],
        ticker: Annotated[StrictStr, Field(description="Market ticker - unique identifier for the specific market")],
        start_ts: Annotated[StrictInt, Field(description="Start timestamp (Unix timestamp). Candlesticks will include those ending on or after this time.")],
        end_ts: Annotated[StrictInt, Field(description="End timestamp (Unix timestamp). Candlesticks will include those ending on or before this time.")],
        period_interval: Annotated[StrictInt, Field(description="Time period length of each candlestick in minutes. Valid values are 1 (1 minute), 60 (1 hour), or 1440 (1 day).")],
        include_latest_before_start: Annotated[Optional[StrictBool], Field(description="If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMarketCandlesticksResponse]:
        """Get Market Candlesticks

        Time period length of each candlestick in minutes. Valid values: 1 (1 minute), 60 (1 hour), 1440 (1 day).

        :param series_ticker: Series ticker - the series that contains the target market (required)
        :type series_ticker: str
        :param ticker: Market ticker - unique identifier for the specific market (required)
        :type ticker: str
        :param start_ts: Start timestamp (Unix timestamp). Candlesticks will include those ending on or after this time. (required)
        :type start_ts: int
        :param end_ts: End timestamp (Unix timestamp). Candlesticks will include those ending on or before this time. (required)
        :type end_ts: int
        :param period_interval: Time period length of each candlestick in minutes. Valid values are 1 (1 minute), 60 (1 hour), or 1440 (1 day). (required)
        :type period_interval: int
        :param include_latest_before_start: If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick 
        :type include_latest_before_start: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_candlesticks_serialize(
            series_ticker=series_ticker,
            ticker=ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            include_latest_before_start=include_latest_before_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketCandlesticksResponse",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_market_candlesticks_without_preload_content(
        self,
        series_ticker: Annotated[StrictStr, Field(description="Series ticker - the series that contains the target market")],
        ticker: Annotated[StrictStr, Field(description="Market ticker - unique identifier for the specific market")],
        start_ts: Annotated[StrictInt, Field(description="Start timestamp (Unix timestamp). Candlesticks will include those ending on or after this time.")],
        end_ts: Annotated[StrictInt, Field(description="End timestamp (Unix timestamp). Candlesticks will include those ending on or before this time.")],
        period_interval: Annotated[StrictInt, Field(description="Time period length of each candlestick in minutes. Valid values are 1 (1 minute), 60 (1 hour), or 1440 (1 day).")],
        include_latest_before_start: Annotated[Optional[StrictBool], Field(description="If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Market Candlesticks

        Time period length of each candlestick in minutes. Valid values: 1 (1 minute), 60 (1 hour), 1440 (1 day).

        :param series_ticker: Series ticker - the series that contains the target market (required)
        :type series_ticker: str
        :param ticker: Market ticker - unique identifier for the specific market (required)
        :type ticker: str
        :param start_ts: Start timestamp (Unix timestamp). Candlesticks will include those ending on or after this time. (required)
        :type start_ts: int
        :param end_ts: End timestamp (Unix timestamp). Candlesticks will include those ending on or before this time. (required)
        :type end_ts: int
        :param period_interval: Time period length of each candlestick in minutes. Valid values are 1 (1 minute), 60 (1 hour), or 1440 (1 day). (required)
        :type period_interval: int
        :param include_latest_before_start: If true, prepends the latest candlestick available before the start_ts. This synthetic candlestick is created by: 1. Finding the most recent real candlestick before start_ts 2. Projecting it forward to the first period boundary (calculated as the next period interval after start_ts) 3. Setting all OHLC prices to null, and `previous_price` to the close price from the real candlestick 
        :type include_latest_before_start: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_candlesticks_serialize(
            series_ticker=series_ticker,
            ticker=ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            include_latest_before_start=include_latest_before_start,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketCandlesticksResponse",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_market_candlesticks_serialize(
        self,
        series_ticker,
        ticker,
        start_ts,
        end_ts,
        period_interval,
        include_latest_before_start,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if series_ticker is not None:
            _path_params['series_ticker'] = series_ticker
        if ticker is not None:
            _path_params['ticker'] = ticker
        # process the query parameters
        if start_ts is not None:
            
            _query_params.append(('start_ts', start_ts))
            
        if end_ts is not None:
            
            _query_params.append(('end_ts', end_ts))
            
        if period_interval is not None:
            
            _query_params.append(('period_interval', period_interval))
            
        if include_latest_before_start is not None:
            
            _query_params.append(('include_latest_before_start', include_latest_before_start))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/series/{series_ticker}/markets/{ticker}/candlesticks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_market_orderbook(
        self,
        ticker: StrictStr,
        depth: Any = None,
    ) -> GetMarketOrderbookResponse:
        """Get Market Orderbook

         Endpoint for getting the current order book for a specific market.  The order book shows all active bid orders for both yes and no sides of a binary market. It returns yes bids and no bids only (no asks are returned). This is because in binary markets, a bid for yes at price X is equivalent to an ask for no at price (100-X). For example, a yes bid at 7¢ is the same as a no ask at 93¢, with identical contract sizes.  Each side shows price levels with their corresponding quantities and order counts, organized from best to worst prices.

        :param ticker: Market ticker (required)
        :type ticker: str
        :param depth: Depth of the orderbook to retrieve (0 or negative means all levels, 1-100 for specific depth)
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_market_orderbook_serialize(
            ticker=ticker,
            depth=depth,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketOrderbookResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_market_orderbook_with_http_info(
        self,
        ticker: Annotated[StrictStr, Field(description="Market ticker")],
        depth: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=0)]], Field(description="Depth of the orderbook to retrieve (0 or negative means all levels, 1-100 for specific depth)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMarketOrderbookResponse]:
        """Get Market Orderbook

         Endpoint for getting the current order book for a specific market.  The order book shows all active bid orders for both yes and no sides of a binary market. It returns yes bids and no bids only (no asks are returned). This is because in binary markets, a bid for yes at price X is equivalent to an ask for no at price (100-X). For example, a yes bid at 7¢ is the same as a no ask at 93¢, with identical contract sizes.  Each side shows price levels with their corresponding quantities and order counts, organized from best to worst prices.

        :param ticker: Market ticker (required)
        :type ticker: str
        :param depth: Depth of the orderbook to retrieve (0 or negative means all levels, 1-100 for specific depth)
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_orderbook_serialize(
            ticker=ticker,
            depth=depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketOrderbookResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_market_orderbook_without_preload_content(
        self,
        ticker: Annotated[StrictStr, Field(description="Market ticker")],
        depth: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=0)]], Field(description="Depth of the orderbook to retrieve (0 or negative means all levels, 1-100 for specific depth)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Market Orderbook

         Endpoint for getting the current order book for a specific market.  The order book shows all active bid orders for both yes and no sides of a binary market. It returns yes bids and no bids only (no asks are returned). This is because in binary markets, a bid for yes at price X is equivalent to an ask for no at price (100-X). For example, a yes bid at 7¢ is the same as a no ask at 93¢, with identical contract sizes.  Each side shows price levels with their corresponding quantities and order counts, organized from best to worst prices.

        :param ticker: Market ticker (required)
        :type ticker: str
        :param depth: Depth of the orderbook to retrieve (0 or negative means all levels, 1-100 for specific depth)
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_orderbook_serialize(
            ticker=ticker,
            depth=depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketOrderbookResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_market_orderbook_serialize(
        self,
        ticker,
        depth,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ticker is not None:
            _path_params['ticker'] = ticker
        # process the query parameters
        if depth is not None:
            
            _query_params.append(('depth', depth))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'kalshiAccessSignature', 
            'kalshiAccessKey', 
            'kalshiAccessTimestamp'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets/{ticker}/orderbook',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_markets(
        self,
        limit: Any = None,
        cursor: Any = None,
        event_ticker: Any = None,
        series_ticker: Any = None,
        min_created_ts: Any = None,
        max_created_ts: Any = None,
        min_updated_ts: Any = None,
        max_close_ts: Any = None,
        min_close_ts: Any = None,
        min_settled_ts: Any = None,
        max_settled_ts: Any = None,
        status: Any = None,
        tickers: Any = None,
        mve_filter: Any = None,
    ) -> GetMarketsResponse:
        """Get Markets

        Filter by market status. Possible values: `unopened`, `open`, `closed`, `settled`. Leave empty to return markets with any status.  - Only one `status` filter may be supplied at a time.  - Timestamp filters will be mutually exclusive from other timestamp filters and certain status filters.   | Compatible Timestamp Filters | Additional Status Filters| Extra Notes |  |------------------------------|--------------------------|-------------|  | min_created_ts, max_created_ts | `unopened`, `open`, *empty* | |  | min_close_ts, max_close_ts | `closed`, *empty* | |  | min_settled_ts, max_settled_ts | `settled`, *empty* | |  | min_updated_ts | *empty* | Incompatible with all filters besides `mve_filter=exclude` | 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).
        :type event_ticker: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param min_created_ts: Filter items that created after this Unix timestamp
        :type min_created_ts: int
        :param max_created_ts: Filter items that created before this Unix timestamp
        :type max_created_ts: int
        :param min_updated_ts: Return markets updated later than this Unix timestamp. Incompatible with any other filters.
        :type min_updated_ts: int
        :param max_close_ts: Filter items that close before this Unix timestamp
        :type max_close_ts: int
        :param min_close_ts: Filter items that close after this Unix timestamp
        :type min_close_ts: int
        :param min_settled_ts: Filter items that settled after this Unix timestamp
        :type min_settled_ts: int
        :param max_settled_ts: Filter items that settled before this Unix timestamp
        :type max_settled_ts: int
        :param status: Filter by market status. Leave empty to return markets with any status.
        :type status: str
        :param tickers: Filter by specific market tickers. Comma-separated list of market tickers to retrieve.
        :type tickers: str
        :param mve_filter: Filter by multivariate events (combos). 'only' returns only multivariate events, 'exclude' excludes multivariate events.
        :type mve_filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_markets_serialize(
            limit=limit,
            cursor=cursor,
            event_ticker=event_ticker,
            series_ticker=series_ticker,
            min_created_ts=min_created_ts,
            max_created_ts=max_created_ts,
            min_updated_ts=min_updated_ts,
            max_close_ts=max_close_ts,
            min_close_ts=min_close_ts,
            min_settled_ts=min_settled_ts,
            max_settled_ts=max_settled_ts,
            status=status,
            tickers=tickers,
            mve_filter=mve_filter,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_markets_with_http_info(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 1000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        event_ticker: Annotated[Optional[StrictStr], Field(description="Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).")] = None,
        series_ticker: Annotated[Optional[StrictStr], Field(description="Filter by series ticker")] = None,
        min_created_ts: Annotated[Optional[StrictInt], Field(description="Filter items that created after this Unix timestamp")] = None,
        max_created_ts: Annotated[Optional[StrictInt], Field(description="Filter items that created before this Unix timestamp")] = None,
        min_updated_ts: Annotated[Optional[StrictInt], Field(description="Return markets updated later than this Unix timestamp. Incompatible with any other filters.")] = None,
        max_close_ts: Annotated[Optional[StrictInt], Field(description="Filter items that close before this Unix timestamp")] = None,
        min_close_ts: Annotated[Optional[StrictInt], Field(description="Filter items that close after this Unix timestamp")] = None,
        min_settled_ts: Annotated[Optional[StrictInt], Field(description="Filter items that settled after this Unix timestamp")] = None,
        max_settled_ts: Annotated[Optional[StrictInt], Field(description="Filter items that settled before this Unix timestamp")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by market status. Leave empty to return markets with any status.")] = None,
        tickers: Annotated[Optional[StrictStr], Field(description="Filter by specific market tickers. Comma-separated list of market tickers to retrieve.")] = None,
        mve_filter: Annotated[Optional[StrictStr], Field(description="Filter by multivariate events (combos). 'only' returns only multivariate events, 'exclude' excludes multivariate events.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMarketsResponse]:
        """Get Markets

        Filter by market status. Possible values: `unopened`, `open`, `closed`, `settled`. Leave empty to return markets with any status.  - Only one `status` filter may be supplied at a time.  - Timestamp filters will be mutually exclusive from other timestamp filters and certain status filters.   | Compatible Timestamp Filters | Additional Status Filters| Extra Notes |  |------------------------------|--------------------------|-------------|  | min_created_ts, max_created_ts | `unopened`, `open`, *empty* | |  | min_close_ts, max_close_ts | `closed`, *empty* | |  | min_settled_ts, max_settled_ts | `settled`, *empty* | |  | min_updated_ts | *empty* | Incompatible with all filters besides `mve_filter=exclude` | 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).
        :type event_ticker: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param min_created_ts: Filter items that created after this Unix timestamp
        :type min_created_ts: int
        :param max_created_ts: Filter items that created before this Unix timestamp
        :type max_created_ts: int
        :param min_updated_ts: Return markets updated later than this Unix timestamp. Incompatible with any other filters.
        :type min_updated_ts: int
        :param max_close_ts: Filter items that close before this Unix timestamp
        :type max_close_ts: int
        :param min_close_ts: Filter items that close after this Unix timestamp
        :type min_close_ts: int
        :param min_settled_ts: Filter items that settled after this Unix timestamp
        :type min_settled_ts: int
        :param max_settled_ts: Filter items that settled before this Unix timestamp
        :type max_settled_ts: int
        :param status: Filter by market status. Leave empty to return markets with any status.
        :type status: str
        :param tickers: Filter by specific market tickers. Comma-separated list of market tickers to retrieve.
        :type tickers: str
        :param mve_filter: Filter by multivariate events (combos). 'only' returns only multivariate events, 'exclude' excludes multivariate events.
        :type mve_filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_markets_serialize(
            limit=limit,
            cursor=cursor,
            event_ticker=event_ticker,
            series_ticker=series_ticker,
            min_created_ts=min_created_ts,
            max_created_ts=max_created_ts,
            min_updated_ts=min_updated_ts,
            max_close_ts=max_close_ts,
            min_close_ts=min_close_ts,
            min_settled_ts=min_settled_ts,
            max_settled_ts=max_settled_ts,
            status=status,
            tickers=tickers,
            mve_filter=mve_filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_markets_without_preload_content(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 1000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        event_ticker: Annotated[Optional[StrictStr], Field(description="Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).")] = None,
        series_ticker: Annotated[Optional[StrictStr], Field(description="Filter by series ticker")] = None,
        min_created_ts: Annotated[Optional[StrictInt], Field(description="Filter items that created after this Unix timestamp")] = None,
        max_created_ts: Annotated[Optional[StrictInt], Field(description="Filter items that created before this Unix timestamp")] = None,
        min_updated_ts: Annotated[Optional[StrictInt], Field(description="Return markets updated later than this Unix timestamp. Incompatible with any other filters.")] = None,
        max_close_ts: Annotated[Optional[StrictInt], Field(description="Filter items that close before this Unix timestamp")] = None,
        min_close_ts: Annotated[Optional[StrictInt], Field(description="Filter items that close after this Unix timestamp")] = None,
        min_settled_ts: Annotated[Optional[StrictInt], Field(description="Filter items that settled after this Unix timestamp")] = None,
        max_settled_ts: Annotated[Optional[StrictInt], Field(description="Filter items that settled before this Unix timestamp")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by market status. Leave empty to return markets with any status.")] = None,
        tickers: Annotated[Optional[StrictStr], Field(description="Filter by specific market tickers. Comma-separated list of market tickers to retrieve.")] = None,
        mve_filter: Annotated[Optional[StrictStr], Field(description="Filter by multivariate events (combos). 'only' returns only multivariate events, 'exclude' excludes multivariate events.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Markets

        Filter by market status. Possible values: `unopened`, `open`, `closed`, `settled`. Leave empty to return markets with any status.  - Only one `status` filter may be supplied at a time.  - Timestamp filters will be mutually exclusive from other timestamp filters and certain status filters.   | Compatible Timestamp Filters | Additional Status Filters| Extra Notes |  |------------------------------|--------------------------|-------------|  | min_created_ts, max_created_ts | `unopened`, `open`, *empty* | |  | min_close_ts, max_close_ts | `closed`, *empty* | |  | min_settled_ts, max_settled_ts | `settled`, *empty* | |  | min_updated_ts | *empty* | Incompatible with all filters besides `mve_filter=exclude` | 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).
        :type event_ticker: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param min_created_ts: Filter items that created after this Unix timestamp
        :type min_created_ts: int
        :param max_created_ts: Filter items that created before this Unix timestamp
        :type max_created_ts: int
        :param min_updated_ts: Return markets updated later than this Unix timestamp. Incompatible with any other filters.
        :type min_updated_ts: int
        :param max_close_ts: Filter items that close before this Unix timestamp
        :type max_close_ts: int
        :param min_close_ts: Filter items that close after this Unix timestamp
        :type min_close_ts: int
        :param min_settled_ts: Filter items that settled after this Unix timestamp
        :type min_settled_ts: int
        :param max_settled_ts: Filter items that settled before this Unix timestamp
        :type max_settled_ts: int
        :param status: Filter by market status. Leave empty to return markets with any status.
        :type status: str
        :param tickers: Filter by specific market tickers. Comma-separated list of market tickers to retrieve.
        :type tickers: str
        :param mve_filter: Filter by multivariate events (combos). 'only' returns only multivariate events, 'exclude' excludes multivariate events.
        :type mve_filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_markets_serialize(
            limit=limit,
            cursor=cursor,
            event_ticker=event_ticker,
            series_ticker=series_ticker,
            min_created_ts=min_created_ts,
            max_created_ts=max_created_ts,
            min_updated_ts=min_updated_ts,
            max_close_ts=max_close_ts,
            min_close_ts=min_close_ts,
            min_settled_ts=min_settled_ts,
            max_settled_ts=max_settled_ts,
            status=status,
            tickers=tickers,
            mve_filter=mve_filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_markets_serialize(
        self,
        limit,
        cursor,
        event_ticker,
        series_ticker,
        min_created_ts,
        max_created_ts,
        min_updated_ts,
        max_close_ts,
        min_close_ts,
        min_settled_ts,
        max_settled_ts,
        status,
        tickers,
        mve_filter,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if event_ticker is not None:
            
            _query_params.append(('event_ticker', event_ticker))
            
        if series_ticker is not None:
            
            _query_params.append(('series_ticker', series_ticker))
            
        if min_created_ts is not None:
            
            _query_params.append(('min_created_ts', min_created_ts))
            
        if max_created_ts is not None:
            
            _query_params.append(('max_created_ts', max_created_ts))
            
        if min_updated_ts is not None:
            
            _query_params.append(('min_updated_ts', min_updated_ts))
            
        if max_close_ts is not None:
            
            _query_params.append(('max_close_ts', max_close_ts))
            
        if min_close_ts is not None:
            
            _query_params.append(('min_close_ts', min_close_ts))
            
        if min_settled_ts is not None:
            
            _query_params.append(('min_settled_ts', min_settled_ts))
            
        if max_settled_ts is not None:
            
            _query_params.append(('max_settled_ts', max_settled_ts))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if tickers is not None:
            
            _query_params.append(('tickers', tickers))
            
        if mve_filter is not None:
            
            _query_params.append(('mve_filter', mve_filter))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_series(
        self,
        series_ticker: StrictStr,
        include_volume: Any = None,
    ) -> GetSeriesResponse:
        """Get Series

         Endpoint for getting data about a specific series by its ticker.  A series represents a template for recurring events that follow the same format and rules (e.g., \"Monthly Jobs Report\", \"Weekly Initial Jobless Claims\", \"Daily Weather in NYC\"). Series define the structure, settlement sources, and metadata that will be applied to each recurring event instance within that series.

        :param series_ticker: The ticker of the series to retrieve (required)
        :type series_ticker: str
        :param include_volume: If true, includes the total volume traded across all events in this series.
        :type include_volume: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_series_serialize(
            series_ticker=series_ticker,
            include_volume=include_volume,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSeriesResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_series_with_http_info(
        self,
        series_ticker: Annotated[StrictStr, Field(description="The ticker of the series to retrieve")],
        include_volume: Annotated[Optional[StrictBool], Field(description="If true, includes the total volume traded across all events in this series.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetSeriesResponse]:
        """Get Series

         Endpoint for getting data about a specific series by its ticker.  A series represents a template for recurring events that follow the same format and rules (e.g., \"Monthly Jobs Report\", \"Weekly Initial Jobless Claims\", \"Daily Weather in NYC\"). Series define the structure, settlement sources, and metadata that will be applied to each recurring event instance within that series.

        :param series_ticker: The ticker of the series to retrieve (required)
        :type series_ticker: str
        :param include_volume: If true, includes the total volume traded across all events in this series.
        :type include_volume: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_series_serialize(
            series_ticker=series_ticker,
            include_volume=include_volume,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSeriesResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_series_without_preload_content(
        self,
        series_ticker: Annotated[StrictStr, Field(description="The ticker of the series to retrieve")],
        include_volume: Annotated[Optional[StrictBool], Field(description="If true, includes the total volume traded across all events in this series.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Series

         Endpoint for getting data about a specific series by its ticker.  A series represents a template for recurring events that follow the same format and rules (e.g., \"Monthly Jobs Report\", \"Weekly Initial Jobless Claims\", \"Daily Weather in NYC\"). Series define the structure, settlement sources, and metadata that will be applied to each recurring event instance within that series.

        :param series_ticker: The ticker of the series to retrieve (required)
        :type series_ticker: str
        :param include_volume: If true, includes the total volume traded across all events in this series.
        :type include_volume: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_series_serialize(
            series_ticker=series_ticker,
            include_volume=include_volume,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSeriesResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_series_serialize(
        self,
        series_ticker,
        include_volume,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if series_ticker is not None:
            _path_params['series_ticker'] = series_ticker
        # process the query parameters
        if include_volume is not None:
            
            _query_params.append(('include_volume', include_volume))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/series/{series_ticker}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_series_list(
        self,
        category: Any = None,
        tags: Any = None,
        include_product_metadata: Any = None,
        include_volume: Any = None,
    ) -> GetSeriesListResponse:
        """Get Series List

         Endpoint for getting data about multiple series with specified filters.  A series represents a template for recurring events that follow the same format and rules (e.g., \"Monthly Jobs Report\", \"Weekly Initial Jobless Claims\", \"Daily Weather in NYC\"). This endpoint allows you to browse and discover available series templates by category.

        :param category: 
        :type category: str
        :param tags: 
        :type tags: str
        :param include_product_metadata: 
        :type include_product_metadata: bool
        :param include_volume: If true, includes the total volume traded across all events in each series.
        :type include_volume: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_series_list_serialize(
            category=category,
            tags=tags,
            include_product_metadata=include_product_metadata,
            include_volume=include_volume,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSeriesListResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_series_list_with_http_info(
        self,
        category: Optional[StrictStr] = None,
        tags: Optional[StrictStr] = None,
        include_product_metadata: Optional[StrictBool] = None,
        include_volume: Annotated[Optional[StrictBool], Field(description="If true, includes the total volume traded across all events in each series.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetSeriesListResponse]:
        """Get Series List

         Endpoint for getting data about multiple series with specified filters.  A series represents a template for recurring events that follow the same format and rules (e.g., \"Monthly Jobs Report\", \"Weekly Initial Jobless Claims\", \"Daily Weather in NYC\"). This endpoint allows you to browse and discover available series templates by category.

        :param category: 
        :type category: str
        :param tags: 
        :type tags: str
        :param include_product_metadata: 
        :type include_product_metadata: bool
        :param include_volume: If true, includes the total volume traded across all events in each series.
        :type include_volume: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_series_list_serialize(
            category=category,
            tags=tags,
            include_product_metadata=include_product_metadata,
            include_volume=include_volume,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSeriesListResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_series_list_without_preload_content(
        self,
        category: Optional[StrictStr] = None,
        tags: Optional[StrictStr] = None,
        include_product_metadata: Optional[StrictBool] = None,
        include_volume: Annotated[Optional[StrictBool], Field(description="If true, includes the total volume traded across all events in each series.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Series List

         Endpoint for getting data about multiple series with specified filters.  A series represents a template for recurring events that follow the same format and rules (e.g., \"Monthly Jobs Report\", \"Weekly Initial Jobless Claims\", \"Daily Weather in NYC\"). This endpoint allows you to browse and discover available series templates by category.

        :param category: 
        :type category: str
        :param tags: 
        :type tags: str
        :param include_product_metadata: 
        :type include_product_metadata: bool
        :param include_volume: If true, includes the total volume traded across all events in each series.
        :type include_volume: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_series_list_serialize(
            category=category,
            tags=tags,
            include_product_metadata=include_product_metadata,
            include_volume=include_volume,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSeriesListResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_series_list_serialize(
        self,
        category,
        tags,
        include_product_metadata,
        include_volume,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if category is not None:
            
            _query_params.append(('category', category))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if include_product_metadata is not None:
            
            _query_params.append(('include_product_metadata', include_product_metadata))
            
        if include_volume is not None:
            
            _query_params.append(('include_volume', include_volume))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/series',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_trades(
        self,
        limit: Any = None,
        cursor: Any = None,
        ticker: Any = None,
        min_ts: Any = None,
        max_ts: Any = None,
    ) -> GetTradesResponse:
        """Get Trades

         Endpoint for getting all trades for all markets.  A trade represents a completed transaction between two users on a specific market. Each trade includes the market ticker, price, quantity, and timestamp information.  This endpoint returns a paginated response. Use the 'limit' parameter to control page size (1-1000, defaults to 100). The response includes a 'cursor' field - pass this value in the 'cursor' parameter of your next request to get the next page. An empty cursor indicates no more pages are available.

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Filter items after this Unix timestamp
        :type min_ts: int
        :param max_ts: Filter items before this Unix timestamp
        :type max_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_trades_serialize(
            limit=limit,
            cursor=cursor,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTradesResponse",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_trades_with_http_info(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 1000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        ticker: Annotated[Optional[StrictStr], Field(description="Filter by market ticker")] = None,
        min_ts: Annotated[Optional[StrictInt], Field(description="Filter items after this Unix timestamp")] = None,
        max_ts: Annotated[Optional[StrictInt], Field(description="Filter items before this Unix timestamp")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTradesResponse]:
        """Get Trades

         Endpoint for getting all trades for all markets.  A trade represents a completed transaction between two users on a specific market. Each trade includes the market ticker, price, quantity, and timestamp information.  This endpoint returns a paginated response. Use the 'limit' parameter to control page size (1-1000, defaults to 100). The response includes a 'cursor' field - pass this value in the 'cursor' parameter of your next request to get the next page. An empty cursor indicates no more pages are available.

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Filter items after this Unix timestamp
        :type min_ts: int
        :param max_ts: Filter items before this Unix timestamp
        :type max_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trades_serialize(
            limit=limit,
            cursor=cursor,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTradesResponse",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_trades_without_preload_content(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 1000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        ticker: Annotated[Optional[StrictStr], Field(description="Filter by market ticker")] = None,
        min_ts: Annotated[Optional[StrictInt], Field(description="Filter items after this Unix timestamp")] = None,
        max_ts: Annotated[Optional[StrictInt], Field(description="Filter items before this Unix timestamp")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Trades

         Endpoint for getting all trades for all markets.  A trade represents a completed transaction between two users on a specific market. Each trade includes the market ticker, price, quantity, and timestamp information.  This endpoint returns a paginated response. Use the 'limit' parameter to control page size (1-1000, defaults to 100). The response includes a 'cursor' field - pass this value in the 'cursor' parameter of your next request to get the next page. An empty cursor indicates no more pages are available.

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Filter items after this Unix timestamp
        :type min_ts: int
        :param max_ts: Filter items before this Unix timestamp
        :type max_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trades_serialize(
            limit=limit,
            cursor=cursor,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTradesResponse",
            '400': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_trades_serialize(
        self,
        limit,
        cursor,
        ticker,
        min_ts,
        max_ts,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if ticker is not None:
            
            _query_params.append(('ticker', ticker))
            
        if min_ts is not None:
            
            _query_params.append(('min_ts', min_ts))
            
        if max_ts is not None:
            
            _query_params.append(('max_ts', max_ts))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets/trades',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


