# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.6.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from kalshi_python_async.models.daily_schedule import DailySchedule
from typing import Optional, Set
from typing_extensions import Self

class WeeklySchedule(BaseModel):
    """
    WeeklySchedule
    """ # noqa: E501
    start_time: datetime = Field(description="Start date and time for when this weekly schedule is effective.")
    end_time: datetime = Field(description="End date and time for when this weekly schedule is no longer effective.")
    monday: List[DailySchedule] = Field(description="Trading hours for Monday. May contain multiple sessions.")
    tuesday: List[DailySchedule] = Field(description="Trading hours for Tuesday. May contain multiple sessions.")
    wednesday: List[DailySchedule] = Field(description="Trading hours for Wednesday. May contain multiple sessions.")
    thursday: List[DailySchedule] = Field(description="Trading hours for Thursday. May contain multiple sessions.")
    friday: List[DailySchedule] = Field(description="Trading hours for Friday. May contain multiple sessions.")
    saturday: List[DailySchedule] = Field(description="Trading hours for Saturday. May contain multiple sessions.")
    sunday: List[DailySchedule] = Field(description="Trading hours for Sunday. May contain multiple sessions.")
    __properties: ClassVar[List[str]] = ["start_time", "end_time", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WeeklySchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in monday (list)
        _items = []
        if self.monday:
            for _item_monday in self.monday:
                if _item_monday:
                    _items.append(_item_monday.to_dict())
            _dict['monday'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tuesday (list)
        _items = []
        if self.tuesday:
            for _item_tuesday in self.tuesday:
                if _item_tuesday:
                    _items.append(_item_tuesday.to_dict())
            _dict['tuesday'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in wednesday (list)
        _items = []
        if self.wednesday:
            for _item_wednesday in self.wednesday:
                if _item_wednesday:
                    _items.append(_item_wednesday.to_dict())
            _dict['wednesday'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in thursday (list)
        _items = []
        if self.thursday:
            for _item_thursday in self.thursday:
                if _item_thursday:
                    _items.append(_item_thursday.to_dict())
            _dict['thursday'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in friday (list)
        _items = []
        if self.friday:
            for _item_friday in self.friday:
                if _item_friday:
                    _items.append(_item_friday.to_dict())
            _dict['friday'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in saturday (list)
        _items = []
        if self.saturday:
            for _item_saturday in self.saturday:
                if _item_saturday:
                    _items.append(_item_saturday.to_dict())
            _dict['saturday'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sunday (list)
        _items = []
        if self.sunday:
            for _item_sunday in self.sunday:
                if _item_sunday:
                    _items.append(_item_sunday.to_dict())
            _dict['sunday'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WeeklySchedule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "start_time": obj.get("start_time"),
            "end_time": obj.get("end_time"),
            "monday": [DailySchedule.from_dict(_item) for _item in obj["monday"]] if obj.get("monday") is not None else None,
            "tuesday": [DailySchedule.from_dict(_item) for _item in obj["tuesday"]] if obj.get("tuesday") is not None else None,
            "wednesday": [DailySchedule.from_dict(_item) for _item in obj["wednesday"]] if obj.get("wednesday") is not None else None,
            "thursday": [DailySchedule.from_dict(_item) for _item in obj["thursday"]] if obj.get("thursday") is not None else None,
            "friday": [DailySchedule.from_dict(_item) for _item in obj["friday"]] if obj.get("friday") is not None else None,
            "saturday": [DailySchedule.from_dict(_item) for _item in obj["saturday"]] if obj.get("saturday") is not None else None,
            "sunday": [DailySchedule.from_dict(_item) for _item in obj["sunday"]] if obj.get("sunday") is not None else None
        })
        return _obj


