# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kalshi_python_sync.models.market_metadata import MarketMetadata
from kalshi_python_sync.models.settlement_source import SettlementSource
from typing import Optional, Set
from typing_extensions import Self

class GetEventMetadataResponse(BaseModel):
    """
    GetEventMetadataResponse
    """ # noqa: E501
    image_url: StrictStr = Field(description="A path to an image that represents this event.")
    featured_image_url: Optional[StrictStr] = Field(default=None, description="A path to an image that represents the image of the featured market.")
    market_details: List[MarketMetadata] = Field(description="Metadata for the markets in this event.")
    settlement_sources: List[SettlementSource] = Field(description="A list of settlement sources for this event.")
    competition: Optional[StrictStr] = Field(default=None, description="Event competition.")
    competition_scope: Optional[StrictStr] = Field(default=None, description="Event scope, based on the competition.")
    __properties: ClassVar[List[str]] = ["image_url", "featured_image_url", "market_details", "settlement_sources", "competition", "competition_scope"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetEventMetadataResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in market_details (list)
        _items = []
        if self.market_details:
            for _item_market_details in self.market_details:
                if _item_market_details:
                    _items.append(_item_market_details.to_dict())
            _dict['market_details'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in settlement_sources (list)
        _items = []
        if self.settlement_sources:
            for _item_settlement_sources in self.settlement_sources:
                if _item_settlement_sources:
                    _items.append(_item_settlement_sources.to_dict())
            _dict['settlement_sources'] = _items
        # set to None if competition (nullable) is None
        # and model_fields_set contains the field
        if self.competition is None and "competition" in self.model_fields_set:
            _dict['competition'] = None

        # set to None if competition_scope (nullable) is None
        # and model_fields_set contains the field
        if self.competition_scope is None and "competition_scope" in self.model_fields_set:
            _dict['competition_scope'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetEventMetadataResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "image_url": obj.get("image_url"),
            "featured_image_url": obj.get("featured_image_url"),
            "market_details": [MarketMetadata.from_dict(_item) for _item in obj["market_details"]] if obj.get("market_details") is not None else None,
            "settlement_sources": [SettlementSource.from_dict(_item) for _item in obj["settlement_sources"]] if obj.get("settlement_sources") is not None else None,
            "competition": obj.get("competition"),
            "competition_scope": obj.get("competition_scope")
        })
        return _obj


