# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt, StrictBool
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from kalshi_python_sync.models.get_event_candlesticks_response import GetEventCandlesticksResponse
from kalshi_python_sync.models.get_event_forecast_percentiles_history_response import GetEventForecastPercentilesHistoryResponse
from kalshi_python_sync.models.get_event_metadata_response import GetEventMetadataResponse
from kalshi_python_sync.models.get_event_response import GetEventResponse
from kalshi_python_sync.models.get_events_response import GetEventsResponse
from kalshi_python_sync.models.get_multivariate_events_response import GetMultivariateEventsResponse

from kalshi_python_sync.api_client import ApiClient, RequestSerialized
from kalshi_python_sync.api_response import ApiResponse
from kalshi_python_sync.rest import RESTResponseType


class EventsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_event(
        self,
        event_ticker: StrictStr,
        with_nested_markets: Any = None,
    ) -> GetEventResponse:
        """Get Event

         Endpoint for getting data about an event by its ticker.  An event represents a real-world occurrence that can be traded on, such as an election, sports game, or economic indicator release. Events contain one or more markets where users can place trades on different outcomes.

        :param event_ticker: Event ticker (required)
        :type event_ticker: str
        :param with_nested_markets: If true, markets are included within the event object. If false (default), markets are returned as a separate top-level field in the response.
        :type with_nested_markets: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_event_serialize(
            event_ticker=event_ticker,
            with_nested_markets=with_nested_markets,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventResponse",
            '400': None,
            '404': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_event_with_http_info(
        self,
        event_ticker: Annotated[StrictStr, Field(description="Event ticker")],
        with_nested_markets: Annotated[Optional[StrictBool], Field(description="If true, markets are included within the event object. If false (default), markets are returned as a separate top-level field in the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetEventResponse]:
        """Get Event

         Endpoint for getting data about an event by its ticker.  An event represents a real-world occurrence that can be traded on, such as an election, sports game, or economic indicator release. Events contain one or more markets where users can place trades on different outcomes.

        :param event_ticker: Event ticker (required)
        :type event_ticker: str
        :param with_nested_markets: If true, markets are included within the event object. If false (default), markets are returned as a separate top-level field in the response.
        :type with_nested_markets: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_serialize(
            event_ticker=event_ticker,
            with_nested_markets=with_nested_markets,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventResponse",
            '400': None,
            '404': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_event_without_preload_content(
        self,
        event_ticker: Annotated[StrictStr, Field(description="Event ticker")],
        with_nested_markets: Annotated[Optional[StrictBool], Field(description="If true, markets are included within the event object. If false (default), markets are returned as a separate top-level field in the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Event

         Endpoint for getting data about an event by its ticker.  An event represents a real-world occurrence that can be traded on, such as an election, sports game, or economic indicator release. Events contain one or more markets where users can place trades on different outcomes.

        :param event_ticker: Event ticker (required)
        :type event_ticker: str
        :param with_nested_markets: If true, markets are included within the event object. If false (default), markets are returned as a separate top-level field in the response.
        :type with_nested_markets: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_serialize(
            event_ticker=event_ticker,
            with_nested_markets=with_nested_markets,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventResponse",
            '400': None,
            '404': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_event_serialize(
        self,
        event_ticker,
        with_nested_markets,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if event_ticker is not None:
            _path_params['event_ticker'] = event_ticker
        # process the query parameters
        if with_nested_markets is not None:
            
            _query_params.append(('with_nested_markets', with_nested_markets))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/events/{event_ticker}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_event_forecast_percentiles_history(
        self,
        ticker: StrictStr,
        series_ticker: StrictStr,
        percentiles: Any,
        start_ts: Any,
        end_ts: Any,
        period_interval: Any,
    ) -> GetEventForecastPercentilesHistoryResponse:
        """Get Event Forecast Percentile History

        Endpoint for getting the historical raw and formatted forecast numbers for an event at specific percentiles.

        :param ticker: The event ticker (required)
        :type ticker: str
        :param series_ticker: The series ticker (required)
        :type series_ticker: str
        :param percentiles: Array of percentile values to retrieve (0-10000, max 10 values) (required)
        :type percentiles: List[int]
        :param start_ts: Start timestamp for the range (required)
        :type start_ts: int
        :param end_ts: End timestamp for the range (required)
        :type end_ts: int
        :param period_interval: Specifies the length of each forecast period, in minutes. 0 for 5-second intervals, or 1, 60, or 1440 for minute-based intervals. (required)
        :type period_interval: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_event_forecast_percentiles_history_serialize(
            ticker=ticker,
            series_ticker=series_ticker,
            percentiles=percentiles,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventForecastPercentilesHistoryResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_event_forecast_percentiles_history_with_http_info(
        self,
        ticker: Annotated[StrictStr, Field(description="The event ticker")],
        series_ticker: Annotated[StrictStr, Field(description="The series ticker")],
        percentiles: Annotated[List[Annotated[int, Field(le=10000, strict=True, ge=0)]], Field(max_length=10, description="Array of percentile values to retrieve (0-10000, max 10 values)")],
        start_ts: Annotated[StrictInt, Field(description="Start timestamp for the range")],
        end_ts: Annotated[StrictInt, Field(description="End timestamp for the range")],
        period_interval: Annotated[StrictInt, Field(description="Specifies the length of each forecast period, in minutes. 0 for 5-second intervals, or 1, 60, or 1440 for minute-based intervals.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetEventForecastPercentilesHistoryResponse]:
        """Get Event Forecast Percentile History

        Endpoint for getting the historical raw and formatted forecast numbers for an event at specific percentiles.

        :param ticker: The event ticker (required)
        :type ticker: str
        :param series_ticker: The series ticker (required)
        :type series_ticker: str
        :param percentiles: Array of percentile values to retrieve (0-10000, max 10 values) (required)
        :type percentiles: List[int]
        :param start_ts: Start timestamp for the range (required)
        :type start_ts: int
        :param end_ts: End timestamp for the range (required)
        :type end_ts: int
        :param period_interval: Specifies the length of each forecast period, in minutes. 0 for 5-second intervals, or 1, 60, or 1440 for minute-based intervals. (required)
        :type period_interval: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_forecast_percentiles_history_serialize(
            ticker=ticker,
            series_ticker=series_ticker,
            percentiles=percentiles,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventForecastPercentilesHistoryResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_event_forecast_percentiles_history_without_preload_content(
        self,
        ticker: Annotated[StrictStr, Field(description="The event ticker")],
        series_ticker: Annotated[StrictStr, Field(description="The series ticker")],
        percentiles: Annotated[List[Annotated[int, Field(le=10000, strict=True, ge=0)]], Field(max_length=10, description="Array of percentile values to retrieve (0-10000, max 10 values)")],
        start_ts: Annotated[StrictInt, Field(description="Start timestamp for the range")],
        end_ts: Annotated[StrictInt, Field(description="End timestamp for the range")],
        period_interval: Annotated[StrictInt, Field(description="Specifies the length of each forecast period, in minutes. 0 for 5-second intervals, or 1, 60, or 1440 for minute-based intervals.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Event Forecast Percentile History

        Endpoint for getting the historical raw and formatted forecast numbers for an event at specific percentiles.

        :param ticker: The event ticker (required)
        :type ticker: str
        :param series_ticker: The series ticker (required)
        :type series_ticker: str
        :param percentiles: Array of percentile values to retrieve (0-10000, max 10 values) (required)
        :type percentiles: List[int]
        :param start_ts: Start timestamp for the range (required)
        :type start_ts: int
        :param end_ts: End timestamp for the range (required)
        :type end_ts: int
        :param period_interval: Specifies the length of each forecast period, in minutes. 0 for 5-second intervals, or 1, 60, or 1440 for minute-based intervals. (required)
        :type period_interval: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_forecast_percentiles_history_serialize(
            ticker=ticker,
            series_ticker=series_ticker,
            percentiles=percentiles,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventForecastPercentilesHistoryResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_event_forecast_percentiles_history_serialize(
        self,
        ticker,
        series_ticker,
        percentiles,
        start_ts,
        end_ts,
        period_interval,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'percentiles': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ticker is not None:
            _path_params['ticker'] = ticker
        if series_ticker is not None:
            _path_params['series_ticker'] = series_ticker
        # process the query parameters
        if percentiles is not None:
            
            _query_params.append(('percentiles', percentiles))
            
        if start_ts is not None:
            
            _query_params.append(('start_ts', start_ts))
            
        if end_ts is not None:
            
            _query_params.append(('end_ts', end_ts))
            
        if period_interval is not None:
            
            _query_params.append(('period_interval', period_interval))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'kalshiAccessSignature', 
            'kalshiAccessKey', 
            'kalshiAccessTimestamp'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/series/{series_ticker}/events/{ticker}/forecast_percentile_history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_event_metadata(
        self,
        event_ticker: StrictStr,
    ) -> GetEventMetadataResponse:
        """Get Event Metadata

         Endpoint for getting metadata about an event by its ticker.  Returns only the metadata information for an event.

        :param event_ticker: Event ticker (required)
        :type event_ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_event_metadata_serialize(
            event_ticker=event_ticker,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventMetadataResponse",
            '400': None,
            '404': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_event_metadata_with_http_info(
        self,
        event_ticker: Annotated[StrictStr, Field(description="Event ticker")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetEventMetadataResponse]:
        """Get Event Metadata

         Endpoint for getting metadata about an event by its ticker.  Returns only the metadata information for an event.

        :param event_ticker: Event ticker (required)
        :type event_ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_metadata_serialize(
            event_ticker=event_ticker,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventMetadataResponse",
            '400': None,
            '404': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_event_metadata_without_preload_content(
        self,
        event_ticker: Annotated[StrictStr, Field(description="Event ticker")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Event Metadata

         Endpoint for getting metadata about an event by its ticker.  Returns only the metadata information for an event.

        :param event_ticker: Event ticker (required)
        :type event_ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_event_metadata_serialize(
            event_ticker=event_ticker,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventMetadataResponse",
            '400': None,
            '404': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_event_metadata_serialize(
        self,
        event_ticker,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if event_ticker is not None:
            _path_params['event_ticker'] = event_ticker
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/events/{event_ticker}/metadata',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_events(
        self,
        limit: Any = None,
        cursor: Any = None,
        with_nested_markets: Any = None,
        with_milestones: Any = None,
        status: Any = None,
        series_ticker: Any = None,
        min_close_ts: Any = None,
    ) -> GetEventsResponse:
        """Get Events

        Get all events. This endpoint excludes multivariate events. To retrieve multivariate events, use the GET /events/multivariate endpoint. 

        :param limit: Parameter to specify the number of results per page. Defaults to 200. Maximum value is 200.
        :type limit: int
        :param cursor: Parameter to specify the pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param with_nested_markets: Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.
        :type with_nested_markets: bool
        :param with_milestones: If true, includes related milestones as a field alongside events.
        :type with_milestones: bool
        :param status: Filter by event status. Possible values are 'open', 'closed', 'settled'. Leave empty to return events with any status.
        :type status: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param min_close_ts: Filter events with at least one market with close timestamp greater than this Unix timestamp (in seconds).
        :type min_close_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_events_serialize(
            limit=limit,
            cursor=cursor,
            with_nested_markets=with_nested_markets,
            with_milestones=with_milestones,
            status=status,
            series_ticker=series_ticker,
            min_close_ts=min_close_ts,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_events_with_http_info(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="Parameter to specify the number of results per page. Defaults to 200. Maximum value is 200.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Parameter to specify the pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        with_nested_markets: Annotated[Optional[StrictBool], Field(description="Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.")] = None,
        with_milestones: Annotated[Optional[StrictBool], Field(description="If true, includes related milestones as a field alongside events.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by event status. Possible values are 'open', 'closed', 'settled'. Leave empty to return events with any status.")] = None,
        series_ticker: Annotated[Optional[StrictStr], Field(description="Filter by series ticker")] = None,
        min_close_ts: Annotated[Optional[StrictInt], Field(description="Filter events with at least one market with close timestamp greater than this Unix timestamp (in seconds).")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetEventsResponse]:
        """Get Events

        Get all events. This endpoint excludes multivariate events. To retrieve multivariate events, use the GET /events/multivariate endpoint. 

        :param limit: Parameter to specify the number of results per page. Defaults to 200. Maximum value is 200.
        :type limit: int
        :param cursor: Parameter to specify the pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param with_nested_markets: Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.
        :type with_nested_markets: bool
        :param with_milestones: If true, includes related milestones as a field alongside events.
        :type with_milestones: bool
        :param status: Filter by event status. Possible values are 'open', 'closed', 'settled'. Leave empty to return events with any status.
        :type status: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param min_close_ts: Filter events with at least one market with close timestamp greater than this Unix timestamp (in seconds).
        :type min_close_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_events_serialize(
            limit=limit,
            cursor=cursor,
            with_nested_markets=with_nested_markets,
            with_milestones=with_milestones,
            status=status,
            series_ticker=series_ticker,
            min_close_ts=min_close_ts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_events_without_preload_content(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="Parameter to specify the number of results per page. Defaults to 200. Maximum value is 200.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Parameter to specify the pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        with_nested_markets: Annotated[Optional[StrictBool], Field(description="Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.")] = None,
        with_milestones: Annotated[Optional[StrictBool], Field(description="If true, includes related milestones as a field alongside events.")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by event status. Possible values are 'open', 'closed', 'settled'. Leave empty to return events with any status.")] = None,
        series_ticker: Annotated[Optional[StrictStr], Field(description="Filter by series ticker")] = None,
        min_close_ts: Annotated[Optional[StrictInt], Field(description="Filter events with at least one market with close timestamp greater than this Unix timestamp (in seconds).")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Events

        Get all events. This endpoint excludes multivariate events. To retrieve multivariate events, use the GET /events/multivariate endpoint. 

        :param limit: Parameter to specify the number of results per page. Defaults to 200. Maximum value is 200.
        :type limit: int
        :param cursor: Parameter to specify the pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param with_nested_markets: Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.
        :type with_nested_markets: bool
        :param with_milestones: If true, includes related milestones as a field alongside events.
        :type with_milestones: bool
        :param status: Filter by event status. Possible values are 'open', 'closed', 'settled'. Leave empty to return events with any status.
        :type status: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param min_close_ts: Filter events with at least one market with close timestamp greater than this Unix timestamp (in seconds).
        :type min_close_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_events_serialize(
            limit=limit,
            cursor=cursor,
            with_nested_markets=with_nested_markets,
            with_milestones=with_milestones,
            status=status,
            series_ticker=series_ticker,
            min_close_ts=min_close_ts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_events_serialize(
        self,
        limit,
        cursor,
        with_nested_markets,
        with_milestones,
        status,
        series_ticker,
        min_close_ts,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if with_nested_markets is not None:
            
            _query_params.append(('with_nested_markets', with_nested_markets))
            
        if with_milestones is not None:
            
            _query_params.append(('with_milestones', with_milestones))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if series_ticker is not None:
            
            _query_params.append(('series_ticker', series_ticker))
            
        if min_close_ts is not None:
            
            _query_params.append(('min_close_ts', min_close_ts))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/events',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_market_candlesticks_by_event(
        self,
        ticker: StrictStr,
        series_ticker: StrictStr,
        start_ts: Any,
        end_ts: Any,
        period_interval: Any,
    ) -> GetEventCandlesticksResponse:
        """Get Event Candlesticks

         End-point for returning aggregated data across all markets corresponding to an event.

        :param ticker: The event ticker (required)
        :type ticker: str
        :param series_ticker: The series ticker (required)
        :type series_ticker: str
        :param start_ts: Start timestamp for the range (required)
        :type start_ts: int
        :param end_ts: End timestamp for the range (required)
        :type end_ts: int
        :param period_interval: Specifies the length of each candlestick period, in minutes. Must be one minute, one hour, or one day. (required)
        :type period_interval: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_market_candlesticks_by_event_serialize(
            ticker=ticker,
            series_ticker=series_ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventCandlesticksResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_market_candlesticks_by_event_with_http_info(
        self,
        ticker: Annotated[StrictStr, Field(description="The event ticker")],
        series_ticker: Annotated[StrictStr, Field(description="The series ticker")],
        start_ts: Annotated[StrictInt, Field(description="Start timestamp for the range")],
        end_ts: Annotated[StrictInt, Field(description="End timestamp for the range")],
        period_interval: Annotated[StrictInt, Field(description="Specifies the length of each candlestick period, in minutes. Must be one minute, one hour, or one day.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetEventCandlesticksResponse]:
        """Get Event Candlesticks

         End-point for returning aggregated data across all markets corresponding to an event.

        :param ticker: The event ticker (required)
        :type ticker: str
        :param series_ticker: The series ticker (required)
        :type series_ticker: str
        :param start_ts: Start timestamp for the range (required)
        :type start_ts: int
        :param end_ts: End timestamp for the range (required)
        :type end_ts: int
        :param period_interval: Specifies the length of each candlestick period, in minutes. Must be one minute, one hour, or one day. (required)
        :type period_interval: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_candlesticks_by_event_serialize(
            ticker=ticker,
            series_ticker=series_ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventCandlesticksResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_market_candlesticks_by_event_without_preload_content(
        self,
        ticker: Annotated[StrictStr, Field(description="The event ticker")],
        series_ticker: Annotated[StrictStr, Field(description="The series ticker")],
        start_ts: Annotated[StrictInt, Field(description="Start timestamp for the range")],
        end_ts: Annotated[StrictInt, Field(description="End timestamp for the range")],
        period_interval: Annotated[StrictInt, Field(description="Specifies the length of each candlestick period, in minutes. Must be one minute, one hour, or one day.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Event Candlesticks

         End-point for returning aggregated data across all markets corresponding to an event.

        :param ticker: The event ticker (required)
        :type ticker: str
        :param series_ticker: The series ticker (required)
        :type series_ticker: str
        :param start_ts: Start timestamp for the range (required)
        :type start_ts: int
        :param end_ts: End timestamp for the range (required)
        :type end_ts: int
        :param period_interval: Specifies the length of each candlestick period, in minutes. Must be one minute, one hour, or one day. (required)
        :type period_interval: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_candlesticks_by_event_serialize(
            ticker=ticker,
            series_ticker=series_ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetEventCandlesticksResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_market_candlesticks_by_event_serialize(
        self,
        ticker,
        series_ticker,
        start_ts,
        end_ts,
        period_interval,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ticker is not None:
            _path_params['ticker'] = ticker
        if series_ticker is not None:
            _path_params['series_ticker'] = series_ticker
        # process the query parameters
        if start_ts is not None:
            
            _query_params.append(('start_ts', start_ts))
            
        if end_ts is not None:
            
            _query_params.append(('end_ts', end_ts))
            
        if period_interval is not None:
            
            _query_params.append(('period_interval', period_interval))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/series/{series_ticker}/events/{ticker}/candlesticks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_multivariate_events(
        self,
        limit: Any = None,
        cursor: Any = None,
        series_ticker: Any = None,
        collection_ticker: Any = None,
        with_nested_markets: Any = None,
    ) -> GetMultivariateEventsResponse:
        """Get Multivariate Events

        Retrieve multivariate (combo) events. These are dynamically created events from multivariate event collections. Supports filtering by series and collection ticker.

        :param limit: Number of results per page. Defaults to 100. Maximum value is 200.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results.
        :type cursor: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param collection_ticker: Filter events by collection ticker. Returns only multivariate events belonging to the specified collection. Cannot be used together with series_ticker.
        :type collection_ticker: str
        :param with_nested_markets: Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.
        :type with_nested_markets: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_multivariate_events_serialize(
            limit=limit,
            cursor=cursor,
            series_ticker=series_ticker,
            collection_ticker=collection_ticker,
            with_nested_markets=with_nested_markets,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMultivariateEventsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_multivariate_events_with_http_info(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 200.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results.")] = None,
        series_ticker: Annotated[Optional[StrictStr], Field(description="Filter by series ticker")] = None,
        collection_ticker: Annotated[Optional[StrictStr], Field(description="Filter events by collection ticker. Returns only multivariate events belonging to the specified collection. Cannot be used together with series_ticker.")] = None,
        with_nested_markets: Annotated[Optional[StrictBool], Field(description="Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMultivariateEventsResponse]:
        """Get Multivariate Events

        Retrieve multivariate (combo) events. These are dynamically created events from multivariate event collections. Supports filtering by series and collection ticker.

        :param limit: Number of results per page. Defaults to 100. Maximum value is 200.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results.
        :type cursor: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param collection_ticker: Filter events by collection ticker. Returns only multivariate events belonging to the specified collection. Cannot be used together with series_ticker.
        :type collection_ticker: str
        :param with_nested_markets: Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.
        :type with_nested_markets: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_multivariate_events_serialize(
            limit=limit,
            cursor=cursor,
            series_ticker=series_ticker,
            collection_ticker=collection_ticker,
            with_nested_markets=with_nested_markets,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMultivariateEventsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_multivariate_events_without_preload_content(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 200.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results.")] = None,
        series_ticker: Annotated[Optional[StrictStr], Field(description="Filter by series ticker")] = None,
        collection_ticker: Annotated[Optional[StrictStr], Field(description="Filter events by collection ticker. Returns only multivariate events belonging to the specified collection. Cannot be used together with series_ticker.")] = None,
        with_nested_markets: Annotated[Optional[StrictBool], Field(description="Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Multivariate Events

        Retrieve multivariate (combo) events. These are dynamically created events from multivariate event collections. Supports filtering by series and collection ticker.

        :param limit: Number of results per page. Defaults to 100. Maximum value is 200.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results.
        :type cursor: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param collection_ticker: Filter events by collection ticker. Returns only multivariate events belonging to the specified collection. Cannot be used together with series_ticker.
        :type collection_ticker: str
        :param with_nested_markets: Parameter to specify if nested markets should be included in the response. When true, each event will include a 'markets' field containing a list of Market objects associated with that event.
        :type with_nested_markets: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_multivariate_events_serialize(
            limit=limit,
            cursor=cursor,
            series_ticker=series_ticker,
            collection_ticker=collection_ticker,
            with_nested_markets=with_nested_markets,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMultivariateEventsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_multivariate_events_serialize(
        self,
        limit,
        cursor,
        series_ticker,
        collection_ticker,
        with_nested_markets,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if series_ticker is not None:
            
            _query_params.append(('series_ticker', series_ticker))
            
        if collection_ticker is not None:
            
            _query_params.append(('collection_ticker', collection_ticker))
            
        if with_nested_markets is not None:
            
            _query_params.append(('with_nested_markets', with_nested_markets))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/events/multivariate',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


