# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from kalshi_python_sync.models.market_candlestick import MarketCandlestick
from typing import Optional, Set
from typing_extensions import Self

class MarketCandlesticksResponse(BaseModel):
    """
    MarketCandlesticksResponse
    """ # noqa: E501
    market_ticker: StrictStr = Field(description="Market ticker string (e.g., 'INXD-24JAN01').")
    candlesticks: List[MarketCandlestick] = Field(description="Array of candlestick data points for the market. Includes an initial data point at the start timestamp when available.")
    __properties: ClassVar[List[str]] = ["market_ticker", "candlesticks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MarketCandlesticksResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in candlesticks (list)
        _items = []
        if self.candlesticks:
            for _item_candlesticks in self.candlesticks:
                if _item_candlesticks:
                    _items.append(_item_candlesticks.to_dict())
            _dict['candlesticks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MarketCandlesticksResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "market_ticker": obj.get("market_ticker"),
            "candlesticks": [MarketCandlestick.from_dict(_item) for _item in obj["candlesticks"]] if obj.get("candlesticks") is not None else None
        })
        return _obj


