# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt, StrictBool
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated
from kalshi_python_sync.models.get_milestone_response import GetMilestoneResponse
from kalshi_python_sync.models.get_milestones_response import GetMilestonesResponse

from kalshi_python_sync.api_client import ApiClient, RequestSerialized
from kalshi_python_sync.api_response import ApiResponse
from kalshi_python_sync.rest import RESTResponseType


class MilestoneApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_milestone(
        self,
        milestone_id: StrictStr,
    ) -> GetMilestoneResponse:
        """Get Milestone

         Endpoint for getting data about a specific milestone by its ID.

        :param milestone_id: Milestone ID (required)
        :type milestone_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_milestone_serialize(
            milestone_id=milestone_id,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestoneResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_milestone_with_http_info(
        self,
        milestone_id: Annotated[StrictStr, Field(description="Milestone ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMilestoneResponse]:
        """Get Milestone

         Endpoint for getting data about a specific milestone by its ID.

        :param milestone_id: Milestone ID (required)
        :type milestone_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestone_serialize(
            milestone_id=milestone_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestoneResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_milestone_without_preload_content(
        self,
        milestone_id: Annotated[StrictStr, Field(description="Milestone ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Milestone

         Endpoint for getting data about a specific milestone by its ID.

        :param milestone_id: Milestone ID (required)
        :type milestone_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestone_serialize(
            milestone_id=milestone_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestoneResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_milestone_serialize(
        self,
        milestone_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if milestone_id is not None:
            _path_params['milestone_id'] = milestone_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/milestones/{milestone_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_milestones(
        self,
        limit: Any,
        minimum_start_date: Any = None,
        category: Any = None,
        competition: Any = None,
        source_id: Any = None,
        type: Any = None,
        related_event_ticker: Any = None,
        cursor: Any = None,
    ) -> GetMilestonesResponse:
        """Get Milestones

        Minimum start date to filter milestones. Format: RFC3339 timestamp

        :param limit: Number of milestones to return per page (required)
        :type limit: int
        :param minimum_start_date: Minimum start date to filter milestones. Format RFC3339 timestamp
        :type minimum_start_date: datetime
        :param category: Filter by milestone category
        :type category: str
        :param competition: Filter by competition
        :type competition: str
        :param source_id: Filter by source id
        :type source_id: str
        :param type: Filter by milestone type
        :type type: str
        :param related_event_ticker: Filter by related event ticker
        :type related_event_ticker: str
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_milestones_serialize(
            limit=limit,
            minimum_start_date=minimum_start_date,
            category=category,
            competition=competition,
            source_id=source_id,
            type=type,
            related_event_ticker=related_event_ticker,
            cursor=cursor,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestonesResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_milestones_with_http_info(
        self,
        limit: Annotated[int, Field(le=500, strict=True, ge=1, description="Number of milestones to return per page")],
        minimum_start_date: Annotated[Optional[datetime], Field(description="Minimum start date to filter milestones. Format RFC3339 timestamp")] = None,
        category: Annotated[Optional[StrictStr], Field(description="Filter by milestone category")] = None,
        competition: Annotated[Optional[StrictStr], Field(description="Filter by competition")] = None,
        source_id: Annotated[Optional[StrictStr], Field(description="Filter by source id")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filter by milestone type")] = None,
        related_event_ticker: Annotated[Optional[StrictStr], Field(description="Filter by related event ticker")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMilestonesResponse]:
        """Get Milestones

        Minimum start date to filter milestones. Format: RFC3339 timestamp

        :param limit: Number of milestones to return per page (required)
        :type limit: int
        :param minimum_start_date: Minimum start date to filter milestones. Format RFC3339 timestamp
        :type minimum_start_date: datetime
        :param category: Filter by milestone category
        :type category: str
        :param competition: Filter by competition
        :type competition: str
        :param source_id: Filter by source id
        :type source_id: str
        :param type: Filter by milestone type
        :type type: str
        :param related_event_ticker: Filter by related event ticker
        :type related_event_ticker: str
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestones_serialize(
            limit=limit,
            minimum_start_date=minimum_start_date,
            category=category,
            competition=competition,
            source_id=source_id,
            type=type,
            related_event_ticker=related_event_ticker,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestonesResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_milestones_without_preload_content(
        self,
        limit: Annotated[int, Field(le=500, strict=True, ge=1, description="Number of milestones to return per page")],
        minimum_start_date: Annotated[Optional[datetime], Field(description="Minimum start date to filter milestones. Format RFC3339 timestamp")] = None,
        category: Annotated[Optional[StrictStr], Field(description="Filter by milestone category")] = None,
        competition: Annotated[Optional[StrictStr], Field(description="Filter by competition")] = None,
        source_id: Annotated[Optional[StrictStr], Field(description="Filter by source id")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filter by milestone type")] = None,
        related_event_ticker: Annotated[Optional[StrictStr], Field(description="Filter by related event ticker")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Milestones

        Minimum start date to filter milestones. Format: RFC3339 timestamp

        :param limit: Number of milestones to return per page (required)
        :type limit: int
        :param minimum_start_date: Minimum start date to filter milestones. Format RFC3339 timestamp
        :type minimum_start_date: datetime
        :param category: Filter by milestone category
        :type category: str
        :param competition: Filter by competition
        :type competition: str
        :param source_id: Filter by source id
        :type source_id: str
        :param type: Filter by milestone type
        :type type: str
        :param related_event_ticker: Filter by related event ticker
        :type related_event_ticker: str
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_milestones_serialize(
            limit=limit,
            minimum_start_date=minimum_start_date,
            category=category,
            competition=competition,
            source_id=source_id,
            type=type,
            related_event_ticker=related_event_ticker,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMilestonesResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_milestones_serialize(
        self,
        limit,
        minimum_start_date,
        category,
        competition,
        source_id,
        type,
        related_event_ticker,
        cursor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if minimum_start_date is not None:
            if isinstance(minimum_start_date, datetime):
                _query_params.append(
                    (
                        'minimum_start_date',
                        minimum_start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('minimum_start_date', minimum_start_date))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if competition is not None:
            
            _query_params.append(('competition', competition))
            
        if source_id is not None:
            
            _query_params.append(('source_id', source_id))
            
        if type is not None:
            
            _query_params.append(('type', type))
            
        if related_event_ticker is not None:
            
            _query_params.append(('related_event_ticker', related_event_ticker))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/milestones',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


