# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Milestone(BaseModel):
    """
    Milestone
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the milestone.")
    category: StrictStr = Field(description="Category of the milestone.")
    type: StrictStr = Field(description="Type of the milestone.")
    start_date: datetime = Field(description="Start date of the milestone.")
    end_date: Optional[datetime] = Field(default=None, description="End date of the milestone, if any.")
    related_event_tickers: List[StrictStr] = Field(description="List of event tickers related to this milestone.")
    title: StrictStr = Field(description="Title of the milestone.")
    notification_message: StrictStr = Field(description="Notification message for the milestone.")
    source_id: Optional[StrictStr] = Field(default=None, description="Source id of milestone if available.")
    details: Dict[str, Any] = Field(description="Additional details about the milestone.")
    primary_event_tickers: List[StrictStr] = Field(description="List of event tickers directly related to the outcome of this milestone.")
    last_updated_ts: datetime = Field(description="Last time this structured target was updated.")
    __properties: ClassVar[List[str]] = ["id", "category", "type", "start_date", "end_date", "related_event_tickers", "title", "notification_message", "source_id", "details", "primary_event_tickers", "last_updated_ts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Milestone from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['end_date'] = None

        # set to None if source_id (nullable) is None
        # and model_fields_set contains the field
        if self.source_id is None and "source_id" in self.model_fields_set:
            _dict['source_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Milestone from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "category": obj.get("category"),
            "type": obj.get("type"),
            "start_date": obj.get("start_date"),
            "end_date": obj.get("end_date"),
            "related_event_tickers": obj.get("related_event_tickers"),
            "title": obj.get("title"),
            "notification_message": obj.get("notification_message"),
            "source_id": obj.get("source_id"),
            "details": obj.get("details"),
            "primary_event_tickers": obj.get("primary_event_tickers"),
            "last_updated_ts": obj.get("last_updated_ts")
        })
        return _obj


