# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AmendOrderRequest(BaseModel):
    """
    AmendOrderRequest
    """ # noqa: E501
    ticker: StrictStr = Field(description="Market ticker")
    side: StrictStr = Field(description="Side of the order")
    action: StrictStr = Field(description="Action of the order")
    client_order_id: StrictStr = Field(description="The original client-specified order ID to be amended")
    updated_client_order_id: StrictStr = Field(description="The new client-specified order ID after amendment")
    yes_price: Optional[Annotated[int, Field(le=99, strict=True, ge=1)]] = Field(default=None, description="Updated yes price for the order in cents")
    no_price: Optional[Annotated[int, Field(le=99, strict=True, ge=1)]] = Field(default=None, description="Updated no price for the order in cents")
    yes_price_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    no_price_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    count: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=None, description="Updated quantity for the order (whole contracts only). If updating quantity, provide count or count_fp; if both provided they must match.")
    count_fp: Optional[StrictStr] = Field(default=None, description="Fixed-point contract count string (2 decimals, e.g., \"10.00\"; referred to as \"fp\" in field names). Requests accept 0–2 decimal places (e.g., \"10\", \"10.0\", \"10.00\"); responses always emit 2 decimals. Currently only whole contract values are permitted, but the format supports future fractional precision. Integer contract count fields are legacy and will be deprecated; when both integer and fp fields are provided, they must match.")
    __properties: ClassVar[List[str]] = ["ticker", "side", "action", "client_order_id", "updated_client_order_id", "yes_price", "no_price", "yes_price_dollars", "no_price_dollars", "count", "count_fp"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AmendOrderRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AmendOrderRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "side": obj.get("side"),
            "action": obj.get("action"),
            "client_order_id": obj.get("client_order_id"),
            "updated_client_order_id": obj.get("updated_client_order_id"),
            "yes_price": obj.get("yes_price"),
            "no_price": obj.get("no_price"),
            "yes_price_dollars": obj.get("yes_price_dollars"),
            "no_price_dollars": obj.get("no_price_dollars"),
            "count": obj.get("count"),
            "count_fp": obj.get("count_fp")
        })
        return _obj


