# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from kalshi_python_sync.models.market_candlestick import MarketCandlestick
from typing import Optional, Set
from typing_extensions import Self

class GetEventCandlesticksResponse(BaseModel):
    """
    GetEventCandlesticksResponse
    """ # noqa: E501
    market_tickers: List[StrictStr] = Field(description="Array of market tickers in the event.")
    market_candlesticks: List[List[MarketCandlestick]] = Field(description="Array of market candlestick arrays, one for each market in the event.")
    adjusted_end_ts: StrictInt = Field(description="Adjusted end timestamp if the requested candlesticks would be larger than maxAggregateCandidates.")
    __properties: ClassVar[List[str]] = ["market_tickers", "market_candlesticks", "adjusted_end_ts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetEventCandlesticksResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in market_candlesticks (list of list)
        _items = []
        if self.market_candlesticks:
            for _item_market_candlesticks in self.market_candlesticks:
                if _item_market_candlesticks:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_market_candlesticks if _inner_item is not None]
                    )
            _dict['market_candlesticks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetEventCandlesticksResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "market_tickers": obj.get("market_tickers"),
            "market_candlesticks": [
                    [MarketCandlestick.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["market_candlesticks"]
                ] if obj.get("market_candlesticks") is not None else None,
            "adjusted_end_ts": obj.get("adjusted_end_ts")
        })
        return _obj


