# coding: utf-8

# flake8: noqa

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.6.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

__version__ = "3.6.0"

# import apis into sdk package
from kalshi_python_sync.api.account_api import AccountApi
from kalshi_python_sync.api.api_keys_api import ApiKeysApi
from kalshi_python_sync.api.communications_api import CommunicationsApi
from kalshi_python_sync.api.events_api import EventsApi
from kalshi_python_sync.api.exchange_api import ExchangeApi
from kalshi_python_sync.api.fcm_api import FcmApi
from kalshi_python_sync.api.incentive_programs_api import IncentiveProgramsApi
from kalshi_python_sync.api.live_data_api import LiveDataApi
from kalshi_python_sync.api.market_api import MarketApi
from kalshi_python_sync.api.milestone_api import MilestoneApi
from kalshi_python_sync.api.multivariate_api import MultivariateApi
from kalshi_python_sync.api.order_groups_api import OrderGroupsApi
from kalshi_python_sync.api.orders_api import OrdersApi
from kalshi_python_sync.api.portfolio_api import PortfolioApi
from kalshi_python_sync.api.search_api import SearchApi
from kalshi_python_sync.api.structured_targets_api import StructuredTargetsApi


# import ApiClient
from kalshi_python_sync.api_response import ApiResponse
from kalshi_python_sync.api_client import ApiClient
from kalshi_python_sync.configuration import Configuration
from kalshi_python_sync.exceptions import OpenApiException
from kalshi_python_sync.exceptions import ApiTypeError
from kalshi_python_sync.exceptions import ApiValueError
from kalshi_python_sync.exceptions import ApiKeyError
from kalshi_python_sync.exceptions import ApiAttributeError
from kalshi_python_sync.exceptions import ApiException

# Kalshi-specific authentication
from kalshi_python_sync.auth import KalshiAuth

# Convenience imports for exceptions
from kalshi_python_sync.exceptions import (
    BadRequestException,
    UnauthorizedException,
    ForbiddenException,
    NotFoundException,
    ConflictException,
    ServiceException,
    UnprocessableEntityException,
)

# import models into sdk package
from kalshi_python_sync.models.accept_quote_request import AcceptQuoteRequest
from kalshi_python_sync.models.amend_order_request import AmendOrderRequest
from kalshi_python_sync.models.amend_order_response import AmendOrderResponse
from kalshi_python_sync.models.announcement import Announcement
from kalshi_python_sync.models.api_key import ApiKey
from kalshi_python_sync.models.apply_subaccount_transfer_request import ApplySubaccountTransferRequest
from kalshi_python_sync.models.associated_event import AssociatedEvent
from kalshi_python_sync.models.batch_cancel_orders_individual_response import BatchCancelOrdersIndividualResponse
from kalshi_python_sync.models.batch_cancel_orders_request import BatchCancelOrdersRequest
from kalshi_python_sync.models.batch_cancel_orders_response import BatchCancelOrdersResponse
from kalshi_python_sync.models.batch_create_orders_individual_response import BatchCreateOrdersIndividualResponse
from kalshi_python_sync.models.batch_create_orders_request import BatchCreateOrdersRequest
from kalshi_python_sync.models.batch_create_orders_response import BatchCreateOrdersResponse
from kalshi_python_sync.models.batch_get_market_candlesticks_response import BatchGetMarketCandlesticksResponse
from kalshi_python_sync.models.bid_ask_distribution import BidAskDistribution
from kalshi_python_sync.models.cancel_order_response import CancelOrderResponse
from kalshi_python_sync.models.create_api_key_request import CreateApiKeyRequest
from kalshi_python_sync.models.create_api_key_response import CreateApiKeyResponse
from kalshi_python_sync.models.create_market_in_multivariate_event_collection_request import CreateMarketInMultivariateEventCollectionRequest
from kalshi_python_sync.models.create_market_in_multivariate_event_collection_response import CreateMarketInMultivariateEventCollectionResponse
from kalshi_python_sync.models.create_order_group_request import CreateOrderGroupRequest
from kalshi_python_sync.models.create_order_group_response import CreateOrderGroupResponse
from kalshi_python_sync.models.create_order_request import CreateOrderRequest
from kalshi_python_sync.models.create_order_response import CreateOrderResponse
from kalshi_python_sync.models.create_quote_request import CreateQuoteRequest
from kalshi_python_sync.models.create_quote_response import CreateQuoteResponse
from kalshi_python_sync.models.create_rfq_request import CreateRFQRequest
from kalshi_python_sync.models.create_rfq_response import CreateRFQResponse
from kalshi_python_sync.models.create_subaccount_response import CreateSubaccountResponse
from kalshi_python_sync.models.daily_schedule import DailySchedule
from kalshi_python_sync.models.decrease_order_request import DecreaseOrderRequest
from kalshi_python_sync.models.decrease_order_response import DecreaseOrderResponse
from kalshi_python_sync.models.error_response import ErrorResponse
from kalshi_python_sync.models.event_data import EventData
from kalshi_python_sync.models.event_position import EventPosition
from kalshi_python_sync.models.exchange_instance import ExchangeInstance
from kalshi_python_sync.models.exchange_status import ExchangeStatus
from kalshi_python_sync.models.fill import Fill
from kalshi_python_sync.models.forecast_percentiles_point import ForecastPercentilesPoint
from kalshi_python_sync.models.generate_api_key_request import GenerateApiKeyRequest
from kalshi_python_sync.models.generate_api_key_response import GenerateApiKeyResponse
from kalshi_python_sync.models.get_account_api_limits_response import GetAccountApiLimitsResponse
from kalshi_python_sync.models.get_api_keys_response import GetApiKeysResponse
from kalshi_python_sync.models.get_balance_response import GetBalanceResponse
from kalshi_python_sync.models.get_communications_id_response import GetCommunicationsIDResponse
from kalshi_python_sync.models.get_event_candlesticks_response import GetEventCandlesticksResponse
from kalshi_python_sync.models.get_event_forecast_percentiles_history_response import GetEventForecastPercentilesHistoryResponse
from kalshi_python_sync.models.get_event_metadata_response import GetEventMetadataResponse
from kalshi_python_sync.models.get_event_response import GetEventResponse
from kalshi_python_sync.models.get_events_response import GetEventsResponse
from kalshi_python_sync.models.get_exchange_announcements_response import GetExchangeAnnouncementsResponse
from kalshi_python_sync.models.get_exchange_schedule_response import GetExchangeScheduleResponse
from kalshi_python_sync.models.get_fills_response import GetFillsResponse
from kalshi_python_sync.models.get_filters_by_sports_response import GetFiltersBySportsResponse
from kalshi_python_sync.models.get_incentive_programs_response import GetIncentiveProgramsResponse
from kalshi_python_sync.models.get_live_data_response import GetLiveDataResponse
from kalshi_python_sync.models.get_live_datas_response import GetLiveDatasResponse
from kalshi_python_sync.models.get_market_candlesticks_response import GetMarketCandlesticksResponse
from kalshi_python_sync.models.get_market_orderbook_response import GetMarketOrderbookResponse
from kalshi_python_sync.models.get_market_response import GetMarketResponse
from kalshi_python_sync.models.get_markets_response import GetMarketsResponse
from kalshi_python_sync.models.get_milestone_response import GetMilestoneResponse
from kalshi_python_sync.models.get_milestones_response import GetMilestonesResponse
from kalshi_python_sync.models.get_multivariate_event_collection_lookup_history_response import GetMultivariateEventCollectionLookupHistoryResponse
from kalshi_python_sync.models.get_multivariate_event_collection_response import GetMultivariateEventCollectionResponse
from kalshi_python_sync.models.get_multivariate_event_collections_response import GetMultivariateEventCollectionsResponse
from kalshi_python_sync.models.get_multivariate_events_response import GetMultivariateEventsResponse
from kalshi_python_sync.models.get_order_group_response import GetOrderGroupResponse
from kalshi_python_sync.models.get_order_groups_response import GetOrderGroupsResponse
from kalshi_python_sync.models.get_order_queue_position_response import GetOrderQueuePositionResponse
from kalshi_python_sync.models.get_order_queue_positions_response import GetOrderQueuePositionsResponse
from kalshi_python_sync.models.get_order_response import GetOrderResponse
from kalshi_python_sync.models.get_orders_response import GetOrdersResponse
from kalshi_python_sync.models.get_portfolio_resting_order_total_value_response import GetPortfolioRestingOrderTotalValueResponse
from kalshi_python_sync.models.get_positions_response import GetPositionsResponse
from kalshi_python_sync.models.get_quote_response import GetQuoteResponse
from kalshi_python_sync.models.get_quotes_response import GetQuotesResponse
from kalshi_python_sync.models.get_rfq_response import GetRFQResponse
from kalshi_python_sync.models.get_rfqs_response import GetRFQsResponse
from kalshi_python_sync.models.get_series_fee_changes_response import GetSeriesFeeChangesResponse
from kalshi_python_sync.models.get_series_list_response import GetSeriesListResponse
from kalshi_python_sync.models.get_series_response import GetSeriesResponse
from kalshi_python_sync.models.get_settlements_response import GetSettlementsResponse
from kalshi_python_sync.models.get_structured_target_response import GetStructuredTargetResponse
from kalshi_python_sync.models.get_structured_targets_response import GetStructuredTargetsResponse
from kalshi_python_sync.models.get_subaccount_balances_response import GetSubaccountBalancesResponse
from kalshi_python_sync.models.get_subaccount_transfers_response import GetSubaccountTransfersResponse
from kalshi_python_sync.models.get_tags_for_series_categories_response import GetTagsForSeriesCategoriesResponse
from kalshi_python_sync.models.get_trades_response import GetTradesResponse
from kalshi_python_sync.models.get_user_data_timestamp_response import GetUserDataTimestampResponse
from kalshi_python_sync.models.incentive_program import IncentiveProgram
from kalshi_python_sync.models.intra_exchange_instance_transfer_request import IntraExchangeInstanceTransferRequest
from kalshi_python_sync.models.intra_exchange_instance_transfer_response import IntraExchangeInstanceTransferResponse
from kalshi_python_sync.models.live_data import LiveData
from kalshi_python_sync.models.lookup_point import LookupPoint
from kalshi_python_sync.models.lookup_tickers_for_market_in_multivariate_event_collection_request import LookupTickersForMarketInMultivariateEventCollectionRequest
from kalshi_python_sync.models.lookup_tickers_for_market_in_multivariate_event_collection_response import LookupTickersForMarketInMultivariateEventCollectionResponse
from kalshi_python_sync.models.maintenance_window import MaintenanceWindow
from kalshi_python_sync.models.market import Market
from kalshi_python_sync.models.market_candlestick import MarketCandlestick
from kalshi_python_sync.models.market_candlesticks_response import MarketCandlesticksResponse
from kalshi_python_sync.models.market_metadata import MarketMetadata
from kalshi_python_sync.models.market_position import MarketPosition
from kalshi_python_sync.models.milestone import Milestone
from kalshi_python_sync.models.multivariate_event_collection import MultivariateEventCollection
from kalshi_python_sync.models.mve_selected_leg import MveSelectedLeg
from kalshi_python_sync.models.order import Order
from kalshi_python_sync.models.order_group import OrderGroup
from kalshi_python_sync.models.order_queue_position import OrderQueuePosition
from kalshi_python_sync.models.order_status import OrderStatus
from kalshi_python_sync.models.orderbook import Orderbook
from kalshi_python_sync.models.orderbook_count_fp import OrderbookCountFp
from kalshi_python_sync.models.percentile_point import PercentilePoint
from kalshi_python_sync.models.price_distribution import PriceDistribution
from kalshi_python_sync.models.price_range import PriceRange
from kalshi_python_sync.models.quote import Quote
from kalshi_python_sync.models.rfq import RFQ
from kalshi_python_sync.models.schedule import Schedule
from kalshi_python_sync.models.scope_list import ScopeList
from kalshi_python_sync.models.self_trade_prevention_type import SelfTradePreventionType
from kalshi_python_sync.models.series import Series
from kalshi_python_sync.models.series_fee_change import SeriesFeeChange
from kalshi_python_sync.models.settlement import Settlement
from kalshi_python_sync.models.settlement_source import SettlementSource
from kalshi_python_sync.models.sport_filter_details import SportFilterDetails
from kalshi_python_sync.models.structured_target import StructuredTarget
from kalshi_python_sync.models.subaccount_balance import SubaccountBalance
from kalshi_python_sync.models.subaccount_transfer import SubaccountTransfer
from kalshi_python_sync.models.ticker_pair import TickerPair
from kalshi_python_sync.models.trade import Trade
from kalshi_python_sync.models.update_order_group_limit_request import UpdateOrderGroupLimitRequest
from kalshi_python_sync.models.weekly_schedule import WeeklySchedule


# KalshiClient with custom authentication
class KalshiClient(ApiClient):
    """Convenience client that combines all API classes into a single interface with Kalshi auth"""

    def __init__(self, configuration=None):
        super().__init__(configuration)

        # Initialize Kalshi authentication if credentials are configured
        self.kalshi_auth = None
        if configuration and hasattr(configuration, 'api_key_id') and hasattr(configuration, 'private_key_pem'):
            self.kalshi_auth = KalshiAuth(
                configuration.api_key_id,
                configuration.private_key_pem
            )

        # Initialize all API instances
        self._account_api = AccountApi(self)
        self._api_keys_api = ApiKeysApi(self)
        self._communications_api = CommunicationsApi(self)
        self._events_api = EventsApi(self)
        self._exchange_api = ExchangeApi(self)
        self._fcm_api = FcmApi(self)
        self._incentive_programs_api = IncentiveProgramsApi(self)
        self._live_data_api = LiveDataApi(self)
        self._market_api = MarketApi(self)
        self._milestone_api = MilestoneApi(self)
        self._multivariate_api = MultivariateApi(self)
        self._order_groups_api = OrderGroupsApi(self)
        self._orders_api = OrdersApi(self)
        self._portfolio_api = PortfolioApi(self)
        self._search_api = SearchApi(self)
        self._structured_targets_api = StructuredTargetsApi(self)


    def update_params_for_auth(
        self,
        headers,
        queries,
        auth_settings,
        resource_path,
        method,
        body,
        request_auth=None
    ):
        """Override to add Kalshi custom authentication headers"""
        # Skip if no authentication configured
        if not self.kalshi_auth:
            return super().update_params_for_auth(
                headers, queries, auth_settings, resource_path, method, body, request_auth
            )

        # Build full path - resource_path doesn't include base path
        full_path = f"/trade-api/v2{resource_path}"

        # Get auth headers from KalshiAuth
        auth_headers = self.kalshi_auth.create_auth_headers(method, full_path)
        headers.update(auth_headers)

        return super().update_params_for_auth(
            headers, queries, auth_settings, resource_path, method, body, request_auth
        )

    def __getattr__(self, name):
        """Dynamically forward method calls to the appropriate API instance"""
        # Try each API instance to see if it has the method
        api_names = [
            '_account_api',
            '_api_keys_api',
            '_communications_api',
            '_events_api',
            '_exchange_api',
            '_fcm_api',
            '_incentive_programs_api',
            '_live_data_api',
            '_market_api',
            '_milestone_api',
            '_multivariate_api',
            '_order_groups_api',
            '_orders_api',
            '_portfolio_api',
            '_search_api',
            '_structured_targets_api',
        ]
        for api_name in api_names:
            if hasattr(self, api_name):
                api_instance = getattr(self, api_name)
                if hasattr(api_instance, name):
                    return getattr(api_instance, name)

        # If not found in any API, raise AttributeError
        raise AttributeError(f"'{type(self).__name__}' object has no attribute '{name}'")
