# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.6.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt, StrictBool
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from kalshi_python_sync.models.get_orders_response import GetOrdersResponse
from kalshi_python_sync.models.get_positions_response import GetPositionsResponse

from kalshi_python_sync.api_client import ApiClient, RequestSerialized
from kalshi_python_sync.api_response import ApiResponse
from kalshi_python_sync.rest import RESTResponseType


class FcmApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_fcm_orders(
        self,
        subtrader_id: Any,
        cursor: Any = None,
        event_ticker: Any = None,
        ticker: Any = None,
        min_ts: Any = None,
        max_ts: Any = None,
        status: Any = None,
        limit: Any = None,
    ) -> GetOrdersResponse:
        """Get FCM Orders

        Endpoint for FCM members to get orders filtered by subtrader ID. This endpoint requires FCM member access level and allows filtering orders by subtrader ID. 

        :param subtrader_id: Restricts the response to orders for a specific subtrader (FCM members only) (required)
        :type subtrader_id: str
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).
        :type event_ticker: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Restricts the response to orders after a timestamp, formatted as a Unix Timestamp
        :type min_ts: int
        :param max_ts: Restricts the response to orders before a timestamp, formatted as a Unix Timestamp
        :type max_ts: int
        :param status: Restricts the response to orders that have a certain status
        :type status: str
        :param limit: Parameter to specify the number of results per page. Defaults to 100
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_fcm_orders_serialize(
            subtrader_id=subtrader_id,
            cursor=cursor,
            event_ticker=event_ticker,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            status=status,
            limit=limit,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrdersResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_fcm_orders_with_http_info(
        self,
        subtrader_id: Annotated[StrictStr, Field(description="Restricts the response to orders for a specific subtrader (FCM members only)")],
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        event_ticker: Annotated[Optional[StrictStr], Field(description="Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).")] = None,
        ticker: Annotated[Optional[StrictStr], Field(description="Filter by market ticker")] = None,
        min_ts: Annotated[Optional[StrictInt], Field(description="Restricts the response to orders after a timestamp, formatted as a Unix Timestamp")] = None,
        max_ts: Annotated[Optional[StrictInt], Field(description="Restricts the response to orders before a timestamp, formatted as a Unix Timestamp")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Restricts the response to orders that have a certain status")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Parameter to specify the number of results per page. Defaults to 100")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetOrdersResponse]:
        """Get FCM Orders

        Endpoint for FCM members to get orders filtered by subtrader ID. This endpoint requires FCM member access level and allows filtering orders by subtrader ID. 

        :param subtrader_id: Restricts the response to orders for a specific subtrader (FCM members only) (required)
        :type subtrader_id: str
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).
        :type event_ticker: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Restricts the response to orders after a timestamp, formatted as a Unix Timestamp
        :type min_ts: int
        :param max_ts: Restricts the response to orders before a timestamp, formatted as a Unix Timestamp
        :type max_ts: int
        :param status: Restricts the response to orders that have a certain status
        :type status: str
        :param limit: Parameter to specify the number of results per page. Defaults to 100
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fcm_orders_serialize(
            subtrader_id=subtrader_id,
            cursor=cursor,
            event_ticker=event_ticker,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            status=status,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrdersResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_fcm_orders_without_preload_content(
        self,
        subtrader_id: Annotated[StrictStr, Field(description="Restricts the response to orders for a specific subtrader (FCM members only)")],
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        event_ticker: Annotated[Optional[StrictStr], Field(description="Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).")] = None,
        ticker: Annotated[Optional[StrictStr], Field(description="Filter by market ticker")] = None,
        min_ts: Annotated[Optional[StrictInt], Field(description="Restricts the response to orders after a timestamp, formatted as a Unix Timestamp")] = None,
        max_ts: Annotated[Optional[StrictInt], Field(description="Restricts the response to orders before a timestamp, formatted as a Unix Timestamp")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Restricts the response to orders that have a certain status")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Parameter to specify the number of results per page. Defaults to 100")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get FCM Orders

        Endpoint for FCM members to get orders filtered by subtrader ID. This endpoint requires FCM member access level and allows filtering orders by subtrader ID. 

        :param subtrader_id: Restricts the response to orders for a specific subtrader (FCM members only) (required)
        :type subtrader_id: str
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Event ticker of desired positions. Multiple event tickers can be provided as a comma-separated list (maximum 10).
        :type event_ticker: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Restricts the response to orders after a timestamp, formatted as a Unix Timestamp
        :type min_ts: int
        :param max_ts: Restricts the response to orders before a timestamp, formatted as a Unix Timestamp
        :type max_ts: int
        :param status: Restricts the response to orders that have a certain status
        :type status: str
        :param limit: Parameter to specify the number of results per page. Defaults to 100
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fcm_orders_serialize(
            subtrader_id=subtrader_id,
            cursor=cursor,
            event_ticker=event_ticker,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            status=status,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrdersResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_fcm_orders_serialize(
        self,
        subtrader_id,
        cursor,
        event_ticker,
        ticker,
        min_ts,
        max_ts,
        status,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if subtrader_id is not None:
            
            _query_params.append(('subtrader_id', subtrader_id))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if event_ticker is not None:
            
            _query_params.append(('event_ticker', event_ticker))
            
        if ticker is not None:
            
            _query_params.append(('ticker', ticker))
            
        if min_ts is not None:
            
            _query_params.append(('min_ts', min_ts))
            
        if max_ts is not None:
            
            _query_params.append(('max_ts', max_ts))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'kalshiAccessSignature', 
            'kalshiAccessKey', 
            'kalshiAccessTimestamp'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fcm/orders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_fcm_positions(
        self,
        subtrader_id: Any,
        ticker: Any = None,
        event_ticker: Any = None,
        count_filter: Any = None,
        settlement_status: Any = None,
        limit: Any = None,
        cursor: Any = None,
    ) -> GetPositionsResponse:
        """Get FCM Positions

        Endpoint for FCM members to get market positions filtered by subtrader ID. This endpoint requires FCM member access level and allows filtering positions by subtrader ID. 

        :param subtrader_id: Restricts the response to positions for a specific subtrader (FCM members only) (required)
        :type subtrader_id: str
        :param ticker: Ticker of desired positions
        :type ticker: str
        :param event_ticker: Event ticker of desired positions
        :type event_ticker: str
        :param count_filter: Restricts the positions to those with any of following fields with non-zero values, as a comma separated list
        :type count_filter: str
        :param settlement_status: Settlement status of the markets to return. Defaults to unsettled
        :type settlement_status: str
        :param limit: Parameter to specify the number of results per page. Defaults to 100
        :type limit: int
        :param cursor: The Cursor represents a pointer to the next page of records in the pagination
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_fcm_positions_serialize(
            subtrader_id=subtrader_id,
            ticker=ticker,
            event_ticker=event_ticker,
            count_filter=count_filter,
            settlement_status=settlement_status,
            limit=limit,
            cursor=cursor,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPositionsResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_fcm_positions_with_http_info(
        self,
        subtrader_id: Annotated[StrictStr, Field(description="Restricts the response to positions for a specific subtrader (FCM members only)")],
        ticker: Annotated[Optional[StrictStr], Field(description="Ticker of desired positions")] = None,
        event_ticker: Annotated[Optional[StrictStr], Field(description="Event ticker of desired positions")] = None,
        count_filter: Annotated[Optional[StrictStr], Field(description="Restricts the positions to those with any of following fields with non-zero values, as a comma separated list")] = None,
        settlement_status: Annotated[Optional[StrictStr], Field(description="Settlement status of the markets to return. Defaults to unsettled")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Parameter to specify the number of results per page. Defaults to 100")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The Cursor represents a pointer to the next page of records in the pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPositionsResponse]:
        """Get FCM Positions

        Endpoint for FCM members to get market positions filtered by subtrader ID. This endpoint requires FCM member access level and allows filtering positions by subtrader ID. 

        :param subtrader_id: Restricts the response to positions for a specific subtrader (FCM members only) (required)
        :type subtrader_id: str
        :param ticker: Ticker of desired positions
        :type ticker: str
        :param event_ticker: Event ticker of desired positions
        :type event_ticker: str
        :param count_filter: Restricts the positions to those with any of following fields with non-zero values, as a comma separated list
        :type count_filter: str
        :param settlement_status: Settlement status of the markets to return. Defaults to unsettled
        :type settlement_status: str
        :param limit: Parameter to specify the number of results per page. Defaults to 100
        :type limit: int
        :param cursor: The Cursor represents a pointer to the next page of records in the pagination
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fcm_positions_serialize(
            subtrader_id=subtrader_id,
            ticker=ticker,
            event_ticker=event_ticker,
            count_filter=count_filter,
            settlement_status=settlement_status,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPositionsResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_fcm_positions_without_preload_content(
        self,
        subtrader_id: Annotated[StrictStr, Field(description="Restricts the response to positions for a specific subtrader (FCM members only)")],
        ticker: Annotated[Optional[StrictStr], Field(description="Ticker of desired positions")] = None,
        event_ticker: Annotated[Optional[StrictStr], Field(description="Event ticker of desired positions")] = None,
        count_filter: Annotated[Optional[StrictStr], Field(description="Restricts the positions to those with any of following fields with non-zero values, as a comma separated list")] = None,
        settlement_status: Annotated[Optional[StrictStr], Field(description="Settlement status of the markets to return. Defaults to unsettled")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Parameter to specify the number of results per page. Defaults to 100")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The Cursor represents a pointer to the next page of records in the pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get FCM Positions

        Endpoint for FCM members to get market positions filtered by subtrader ID. This endpoint requires FCM member access level and allows filtering positions by subtrader ID. 

        :param subtrader_id: Restricts the response to positions for a specific subtrader (FCM members only) (required)
        :type subtrader_id: str
        :param ticker: Ticker of desired positions
        :type ticker: str
        :param event_ticker: Event ticker of desired positions
        :type event_ticker: str
        :param count_filter: Restricts the positions to those with any of following fields with non-zero values, as a comma separated list
        :type count_filter: str
        :param settlement_status: Settlement status of the markets to return. Defaults to unsettled
        :type settlement_status: str
        :param limit: Parameter to specify the number of results per page. Defaults to 100
        :type limit: int
        :param cursor: The Cursor represents a pointer to the next page of records in the pagination
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fcm_positions_serialize(
            subtrader_id=subtrader_id,
            ticker=ticker,
            event_ticker=event_ticker,
            count_filter=count_filter,
            settlement_status=settlement_status,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPositionsResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_fcm_positions_serialize(
        self,
        subtrader_id,
        ticker,
        event_ticker,
        count_filter,
        settlement_status,
        limit,
        cursor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if subtrader_id is not None:
            
            _query_params.append(('subtrader_id', subtrader_id))
            
        if ticker is not None:
            
            _query_params.append(('ticker', ticker))
            
        if event_ticker is not None:
            
            _query_params.append(('event_ticker', event_ticker))
            
        if count_filter is not None:
            
            _query_params.append(('count_filter', count_filter))
            
        if settlement_status is not None:
            
            _query_params.append(('settlement_status', settlement_status))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'kalshiAccessSignature', 
            'kalshiAccessKey', 
            'kalshiAccessTimestamp'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fcm/positions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


