# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.6.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from kalshi_python_sync.models.bid_ask_distribution import BidAskDistribution
from kalshi_python_sync.models.price_distribution import PriceDistribution
from typing import Optional, Set
from typing_extensions import Self

class MarketCandlestick(BaseModel):
    """
    MarketCandlestick
    """ # noqa: E501
    end_period_ts: StrictInt = Field(description="Unix timestamp for the inclusive end of the candlestick period.")
    yes_bid: BidAskDistribution
    yes_ask: BidAskDistribution
    price: PriceDistribution
    volume: StrictInt = Field(description="Number of contracts bought on the market during the candlestick period.")
    volume_fp: StrictStr = Field(description="Fixed-point contract count string (2 decimals, e.g., \"10.00\"; referred to as \"fp\" in field names). Requests accept 0–2 decimal places (e.g., \"10\", \"10.0\", \"10.00\"); responses always emit 2 decimals. Currently only whole contract values are permitted, but the format supports future fractional precision. Integer contract count fields are legacy and will be deprecated; when both integer and fp fields are provided, they must match.")
    open_interest: StrictInt = Field(description="Number of contracts bought on the market by end of the candlestick period (end_period_ts).")
    open_interest_fp: StrictStr = Field(description="Fixed-point contract count string (2 decimals, e.g., \"10.00\"; referred to as \"fp\" in field names). Requests accept 0–2 decimal places (e.g., \"10\", \"10.0\", \"10.00\"); responses always emit 2 decimals. Currently only whole contract values are permitted, but the format supports future fractional precision. Integer contract count fields are legacy and will be deprecated; when both integer and fp fields are provided, they must match.")
    __properties: ClassVar[List[str]] = ["end_period_ts", "yes_bid", "yes_ask", "price", "volume", "volume_fp", "open_interest", "open_interest_fp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MarketCandlestick from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of yes_bid
        if self.yes_bid:
            _dict['yes_bid'] = self.yes_bid.to_dict()
        # override the default output from pydantic by calling `to_dict()` of yes_ask
        if self.yes_ask:
            _dict['yes_ask'] = self.yes_ask.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MarketCandlestick from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "end_period_ts": obj.get("end_period_ts"),
            "yes_bid": BidAskDistribution.from_dict(obj["yes_bid"]) if obj.get("yes_bid") is not None else None,
            "yes_ask": BidAskDistribution.from_dict(obj["yes_ask"]) if obj.get("yes_ask") is not None else None,
            "price": PriceDistribution.from_dict(obj["price"]) if obj.get("price") is not None else None,
            "volume": obj.get("volume"),
            "volume_fp": obj.get("volume_fp"),
            "open_interest": obj.get("open_interest"),
            "open_interest_fp": obj.get("open_interest_fp")
        })
        return _obj


