# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.6.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PriceDistribution(BaseModel):
    """
    PriceDistribution
    """ # noqa: E501
    open: Optional[StrictInt] = Field(default=None, description="First traded YES contract price on the market during the candlestick period (in cents). May be null if there was no trade during the period.")
    open_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    low: Optional[StrictInt] = Field(default=None, description="Lowest traded YES contract price on the market during the candlestick period (in cents). May be null if there was no trade during the period.")
    low_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    high: Optional[StrictInt] = Field(default=None, description="Highest traded YES contract price on the market during the candlestick period (in cents). May be null if there was no trade during the period.")
    high_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    close: Optional[StrictInt] = Field(default=None, description="Last traded YES contract price on the market during the candlestick period (in cents). May be null if there was no trade during the period.")
    close_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    mean: Optional[StrictInt] = Field(default=None, description="Mean traded YES contract price on the market during the candlestick period (in cents). May be null if there was no trade during the period.")
    mean_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    previous: Optional[StrictInt] = Field(default=None, description="Last traded YES contract price on the market before the candlestick period (in cents). May be null if there were no trades before the period.")
    previous_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    min: Optional[StrictInt] = Field(default=None, description="Minimum close price of any market during the candlestick period (in cents).")
    min_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    max: Optional[StrictInt] = Field(default=None, description="Maximum close price of any market during the candlestick period (in cents).")
    max_dollars: Optional[StrictStr] = Field(default=None, description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    __properties: ClassVar[List[str]] = ["open", "open_dollars", "low", "low_dollars", "high", "high_dollars", "close", "close_dollars", "mean", "mean_dollars", "previous", "previous_dollars", "min", "min_dollars", "max", "max_dollars"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PriceDistribution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if open (nullable) is None
        # and model_fields_set contains the field
        if self.open is None and "open" in self.model_fields_set:
            _dict['open'] = None

        # set to None if low (nullable) is None
        # and model_fields_set contains the field
        if self.low is None and "low" in self.model_fields_set:
            _dict['low'] = None

        # set to None if high (nullable) is None
        # and model_fields_set contains the field
        if self.high is None and "high" in self.model_fields_set:
            _dict['high'] = None

        # set to None if close (nullable) is None
        # and model_fields_set contains the field
        if self.close is None and "close" in self.model_fields_set:
            _dict['close'] = None

        # set to None if mean (nullable) is None
        # and model_fields_set contains the field
        if self.mean is None and "mean" in self.model_fields_set:
            _dict['mean'] = None

        # set to None if previous (nullable) is None
        # and model_fields_set contains the field
        if self.previous is None and "previous" in self.model_fields_set:
            _dict['previous'] = None

        # set to None if min (nullable) is None
        # and model_fields_set contains the field
        if self.min is None and "min" in self.model_fields_set:
            _dict['min'] = None

        # set to None if max (nullable) is None
        # and model_fields_set contains the field
        if self.max is None and "max" in self.model_fields_set:
            _dict['max'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PriceDistribution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "open": obj.get("open"),
            "open_dollars": obj.get("open_dollars"),
            "low": obj.get("low"),
            "low_dollars": obj.get("low_dollars"),
            "high": obj.get("high"),
            "high_dollars": obj.get("high_dollars"),
            "close": obj.get("close"),
            "close_dollars": obj.get("close_dollars"),
            "mean": obj.get("mean"),
            "mean_dollars": obj.get("mean_dollars"),
            "previous": obj.get("previous"),
            "previous_dollars": obj.get("previous_dollars"),
            "min": obj.get("min"),
            "min_dollars": obj.get("min_dollars"),
            "max": obj.get("max"),
            "max_dollars": obj.get("max_dollars")
        })
        return _obj


