# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.6.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Quote(BaseModel):
    """
    Quote
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the quote")
    rfq_id: StrictStr = Field(description="ID of the RFQ this quote is responding to")
    creator_id: StrictStr = Field(description="Public communications ID of the quote creator")
    rfq_creator_id: StrictStr = Field(description="Public communications ID of the RFQ creator")
    market_ticker: StrictStr = Field(description="The ticker of the market this quote is for")
    contracts: StrictInt = Field(description="Number of contracts in the quote")
    contracts_fp: StrictStr = Field(description="Fixed-point contract count string (2 decimals, e.g., \"10.00\"; referred to as \"fp\" in field names). Requests accept 0–2 decimal places (e.g., \"10\", \"10.0\", \"10.00\"); responses always emit 2 decimals. Currently only whole contract values are permitted, but the format supports future fractional precision. Integer contract count fields are legacy and will be deprecated; when both integer and fp fields are provided, they must match.")
    yes_bid: StrictInt = Field(description="Bid price for YES contracts, in cents")
    no_bid: StrictInt = Field(description="Bid price for NO contracts, in cents")
    yes_bid_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    no_bid_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    created_ts: datetime = Field(description="Timestamp when the quote was created")
    updated_ts: datetime = Field(description="Timestamp when the quote was last updated")
    status: StrictStr = Field(description="Current status of the quote")
    accepted_side: Optional[StrictStr] = Field(default=None, description="The side that was accepted (yes or no)")
    accepted_ts: Optional[datetime] = Field(default=None, description="Timestamp when the quote was accepted")
    confirmed_ts: Optional[datetime] = Field(default=None, description="Timestamp when the quote was confirmed")
    executed_ts: Optional[datetime] = Field(default=None, description="Timestamp when the quote was executed")
    cancelled_ts: Optional[datetime] = Field(default=None, description="Timestamp when the quote was cancelled")
    rest_remainder: Optional[StrictBool] = Field(default=None, description="Whether to rest the remainder of the quote after execution")
    cancellation_reason: Optional[StrictStr] = Field(default=None, description="Reason for quote cancellation if cancelled")
    creator_user_id: Optional[StrictStr] = Field(default=None, description="User ID of the quote creator (private field)")
    rfq_creator_user_id: Optional[StrictStr] = Field(default=None, description="User ID of the RFQ creator (private field)")
    rfq_target_cost_centi_cents: Optional[StrictInt] = Field(default=None, description="Total value requested in the RFQ in centi-cents")
    rfq_creator_order_id: Optional[StrictStr] = Field(default=None, description="Order ID for the RFQ creator (private field)")
    creator_order_id: Optional[StrictStr] = Field(default=None, description="Order ID for the quote creator (private field)")
    __properties: ClassVar[List[str]] = ["id", "rfq_id", "creator_id", "rfq_creator_id", "market_ticker", "contracts", "contracts_fp", "yes_bid", "no_bid", "yes_bid_dollars", "no_bid_dollars", "created_ts", "updated_ts", "status", "accepted_side", "accepted_ts", "confirmed_ts", "executed_ts", "cancelled_ts", "rest_remainder", "cancellation_reason", "creator_user_id", "rfq_creator_user_id", "rfq_target_cost_centi_cents", "rfq_creator_order_id", "creator_order_id"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['open', 'accepted', 'confirmed', 'executed', 'cancelled']):
            raise ValueError("must be one of enum values ('open', 'accepted', 'confirmed', 'executed', 'cancelled')")
        return value

    @field_validator('accepted_side')
    def accepted_side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Quote from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Quote from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "rfq_id": obj.get("rfq_id"),
            "creator_id": obj.get("creator_id"),
            "rfq_creator_id": obj.get("rfq_creator_id"),
            "market_ticker": obj.get("market_ticker"),
            "contracts": obj.get("contracts"),
            "contracts_fp": obj.get("contracts_fp"),
            "yes_bid": obj.get("yes_bid"),
            "no_bid": obj.get("no_bid"),
            "yes_bid_dollars": obj.get("yes_bid_dollars"),
            "no_bid_dollars": obj.get("no_bid_dollars"),
            "created_ts": obj.get("created_ts"),
            "updated_ts": obj.get("updated_ts"),
            "status": obj.get("status"),
            "accepted_side": obj.get("accepted_side"),
            "accepted_ts": obj.get("accepted_ts"),
            "confirmed_ts": obj.get("confirmed_ts"),
            "executed_ts": obj.get("executed_ts"),
            "cancelled_ts": obj.get("cancelled_ts"),
            "rest_remainder": obj.get("rest_remainder"),
            "cancellation_reason": obj.get("cancellation_reason"),
            "creator_user_id": obj.get("creator_user_id"),
            "rfq_creator_user_id": obj.get("rfq_creator_user_id"),
            "rfq_target_cost_centi_cents": obj.get("rfq_target_cost_centi_cents"),
            "rfq_creator_order_id": obj.get("rfq_creator_order_id"),
            "creator_order_id": obj.get("creator_order_id")
        })
        return _obj


