# coding: utf-8

"""
    Kalshi Trade API

    This documentation describes Kalshi's trading API (known as Trade API v2). By using this API, you agree to Kalshi's Developer Agreement (https://kalshi.com/developer-agreement).  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@kalshi.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from kalshi_python.api_client import ApiClient


class MarketApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_event(self, event_ticker, **kwargs):  # noqa: E501
        """GetEvent  # noqa: E501

        Endpoint for getting data about an event by its ticker.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event(event_ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_ticker: Should be filled with the ticker of the event. (required)
        :return: GetEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_with_http_info(event_ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_with_http_info(event_ticker, **kwargs)  # noqa: E501
            return data

    def get_event_with_http_info(self, event_ticker, **kwargs):  # noqa: E501
        """GetEvent  # noqa: E501

        Endpoint for getting data about an event by its ticker.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_with_http_info(event_ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_ticker: Should be filled with the ticker of the event. (required)
        :return: GetEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_ticker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_ticker' is set
        if ('event_ticker' not in params or
                params['event_ticker'] is None):
            raise ValueError("Missing the required parameter `event_ticker` when calling `get_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_ticker' in params:
            path_params['event_ticker'] = params['event_ticker']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/events/{event_ticker}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_events(self, **kwargs):  # noqa: E501
        """GetEvents  # noqa: E501

        Endpoint for getting data about all events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Parameter to specify the number of results per page. Defaults to 100.
        :param str cursor: The Cursor represents a pointer to the next page of records in the pagination. So this optional parameter, when filled, should be filled with the cursor string returned in a previous request to this end-point. Filling this would basically tell the api to get the next page containing the number of records passed on the limit parameter. On the other side not filling it tells the api you want to get the first page for another query. The cursor does not store any filters, so if any filter parameters like series_ticker was passed in the original query they must be passed again.
        :param str status: Restricts the events to those with certain statuses, as a comma separated list. The following values are accepted: open, closed, settled.
        :param str series_ticker: Series ticker to retrieve contracts for.
        :return: GetEventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_events_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_events_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_events_with_http_info(self, **kwargs):  # noqa: E501
        """GetEvents  # noqa: E501

        Endpoint for getting data about all events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Parameter to specify the number of results per page. Defaults to 100.
        :param str cursor: The Cursor represents a pointer to the next page of records in the pagination. So this optional parameter, when filled, should be filled with the cursor string returned in a previous request to this end-point. Filling this would basically tell the api to get the next page containing the number of records passed on the limit parameter. On the other side not filling it tells the api you want to get the first page for another query. The cursor does not store any filters, so if any filter parameters like series_ticker was passed in the original query they must be passed again.
        :param str status: Restricts the events to those with certain statuses, as a comma separated list. The following values are accepted: open, closed, settled.
        :param str series_ticker: Series ticker to retrieve contracts for.
        :return: GetEventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor', 'status', 'series_ticker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'series_ticker' in params:
            query_params.append(('series_ticker', params['series_ticker']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetEventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_market(self, ticker, **kwargs):  # noqa: E501
        """GetMarket  # noqa: E501

        Endpoint for getting data about a specific market.  The value for the ticker path parameter should match the ticker of the target market.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_market(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: Market ticker for the market being retrieved. (required)
        :return: GetMarketResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_market_with_http_info(ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_market_with_http_info(ticker, **kwargs)  # noqa: E501
            return data

    def get_market_with_http_info(self, ticker, **kwargs):  # noqa: E501
        """GetMarket  # noqa: E501

        Endpoint for getting data about a specific market.  The value for the ticker path parameter should match the ticker of the target market.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_market_with_http_info(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: Market ticker for the market being retrieved. (required)
        :return: GetMarketResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_market" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_market`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/markets/{ticker}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetMarketResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_market_history(self, ticker, **kwargs):  # noqa: E501
        """GetMarketHistory  # noqa: E501

        Endpoint for getting the statistics history for a market.  The value for the ticker path parameter should match the ticker of the target market. The min_ts parameter is optional, and will restrict statistics to those after provided timestamp. The min_ts is inclusive, which means a market history point at min_ts will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_market_history(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: Market ticker (required)
        :param int limit: Parameter to specify the number of results per page. Defaults to 100.
        :param str cursor: The Cursor represents a pointer to the next page of records in the pagination. So this optional parameter, when filled, should be filled with the cursor string returned in a previous request to this end-point. Filling this would basically tell the api to get the next page containing the number of records passed on the limit parameter. On the other side not filling it tells the api you want to get the first page for another query. The cursor does not store any filters, so if any filter parameters like max_ts or min_ts were passed in the original query they must be passed again.
        :param int min_ts: If provided, MinTs restricts history to trades starting from MinTs.  Default value: 1 hour ago.
        :param int max_ts: If provided, MaxTs restricts history to trades up until MaxTs
        :return: GetMarketHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_market_history_with_http_info(ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_market_history_with_http_info(ticker, **kwargs)  # noqa: E501
            return data

    def get_market_history_with_http_info(self, ticker, **kwargs):  # noqa: E501
        """GetMarketHistory  # noqa: E501

        Endpoint for getting the statistics history for a market.  The value for the ticker path parameter should match the ticker of the target market. The min_ts parameter is optional, and will restrict statistics to those after provided timestamp. The min_ts is inclusive, which means a market history point at min_ts will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_market_history_with_http_info(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: Market ticker (required)
        :param int limit: Parameter to specify the number of results per page. Defaults to 100.
        :param str cursor: The Cursor represents a pointer to the next page of records in the pagination. So this optional parameter, when filled, should be filled with the cursor string returned in a previous request to this end-point. Filling this would basically tell the api to get the next page containing the number of records passed on the limit parameter. On the other side not filling it tells the api you want to get the first page for another query. The cursor does not store any filters, so if any filter parameters like max_ts or min_ts were passed in the original query they must be passed again.
        :param int min_ts: If provided, MinTs restricts history to trades starting from MinTs.  Default value: 1 hour ago.
        :param int max_ts: If provided, MaxTs restricts history to trades up until MaxTs
        :return: GetMarketHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker', 'limit', 'cursor', 'min_ts', 'max_ts']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_market_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_market_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'min_ts' in params:
            query_params.append(('min_ts', params['min_ts']))  # noqa: E501
        if 'max_ts' in params:
            query_params.append(('max_ts', params['max_ts']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer_token']  # noqa: E501

        return self.api_client.call_api(
            '/markets/{ticker}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetMarketHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_market_orderbook(self, ticker, **kwargs):  # noqa: E501
        """GetMarketOrderbook  # noqa: E501

        Endpoint for getting the orderbook for a market.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_market_orderbook(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: Market ticker. (required)
        :param int depth: Depth specifies the maximum number of orderbook price levels on either side.
        :return: GetMarketOrderbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_market_orderbook_with_http_info(ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_market_orderbook_with_http_info(ticker, **kwargs)  # noqa: E501
            return data

    def get_market_orderbook_with_http_info(self, ticker, **kwargs):  # noqa: E501
        """GetMarketOrderbook  # noqa: E501

        Endpoint for getting the orderbook for a market.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_market_orderbook_with_http_info(ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ticker: Market ticker. (required)
        :param int depth: Depth specifies the maximum number of orderbook price levels on either side.
        :return: GetMarketOrderbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker', 'depth']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_market_orderbook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ticker' is set
        if ('ticker' not in params or
                params['ticker'] is None):
            raise ValueError("Missing the required parameter `ticker` when calling `get_market_orderbook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ticker' in params:
            path_params['ticker'] = params['ticker']  # noqa: E501

        query_params = []
        if 'depth' in params:
            query_params.append(('depth', params['depth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer_token']  # noqa: E501

        return self.api_client.call_api(
            '/markets/{ticker}/orderbook', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetMarketOrderbookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_markets(self, **kwargs):  # noqa: E501
        """GetMarkets  # noqa: E501

        Endpoint for listing and discovering markets on Kalshi.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_markets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Parameter to specify the number of results per page. Defaults to 100.
        :param str cursor: The Cursor represents a pointer to the next page of records in the pagination. So this optional parameter, when filled, should be filled with the cursor string returned in a previous request to this end-point. Filling this would basically tell the api to get the next page containing the number of records passed on the limit parameter. On the other side not filling it tells the api you want to get the first page for another query. The cursor does not store any filters, so if any filter parameters like tickers, max_ts or min_ts were passed in the original query they must be passed again.
        :param str event_ticker: Event ticker to retrieve markets for.
        :param str series_ticker: Series ticker to retrieve contracts for.
        :param int max_close_ts: Restricts the markets to those that are closing in or before this timestamp.
        :param int min_close_ts: Restricts the markets to those that are closing in or after this timestamp.
        :param str status: Restricts the markets to those with certain statuses, as a comma separated list. The following values are accepted: open, closed, settled.
        :param str tickers: Restricts the markets to those with certain tickers, as a comma separated list.
        :return: GetMarketsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_markets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_markets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_markets_with_http_info(self, **kwargs):  # noqa: E501
        """GetMarkets  # noqa: E501

        Endpoint for listing and discovering markets on Kalshi.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_markets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Parameter to specify the number of results per page. Defaults to 100.
        :param str cursor: The Cursor represents a pointer to the next page of records in the pagination. So this optional parameter, when filled, should be filled with the cursor string returned in a previous request to this end-point. Filling this would basically tell the api to get the next page containing the number of records passed on the limit parameter. On the other side not filling it tells the api you want to get the first page for another query. The cursor does not store any filters, so if any filter parameters like tickers, max_ts or min_ts were passed in the original query they must be passed again.
        :param str event_ticker: Event ticker to retrieve markets for.
        :param str series_ticker: Series ticker to retrieve contracts for.
        :param int max_close_ts: Restricts the markets to those that are closing in or before this timestamp.
        :param int min_close_ts: Restricts the markets to those that are closing in or after this timestamp.
        :param str status: Restricts the markets to those with certain statuses, as a comma separated list. The following values are accepted: open, closed, settled.
        :param str tickers: Restricts the markets to those with certain tickers, as a comma separated list.
        :return: GetMarketsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor', 'event_ticker', 'series_ticker', 'max_close_ts', 'min_close_ts', 'status', 'tickers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_markets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'event_ticker' in params:
            query_params.append(('event_ticker', params['event_ticker']))  # noqa: E501
        if 'series_ticker' in params:
            query_params.append(('series_ticker', params['series_ticker']))  # noqa: E501
        if 'max_close_ts' in params:
            query_params.append(('max_close_ts', params['max_close_ts']))  # noqa: E501
        if 'min_close_ts' in params:
            query_params.append(('min_close_ts', params['min_close_ts']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'tickers' in params:
            query_params.append(('tickers', params['tickers']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer_token']  # noqa: E501

        return self.api_client.call_api(
            '/markets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetMarketsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_series(self, series_ticker, **kwargs):  # noqa: E501
        """GetSeries  # noqa: E501

        Endpoint for getting data about a series by its ticker.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_series(series_ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str series_ticker: Should be filled with the ticker of the series. (required)
        :return: GetSeriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_series_with_http_info(series_ticker, **kwargs)  # noqa: E501
        else:
            (data) = self.get_series_with_http_info(series_ticker, **kwargs)  # noqa: E501
            return data

    def get_series_with_http_info(self, series_ticker, **kwargs):  # noqa: E501
        """GetSeries  # noqa: E501

        Endpoint for getting data about a series by its ticker.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_series_with_http_info(series_ticker, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str series_ticker: Should be filled with the ticker of the series. (required)
        :return: GetSeriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['series_ticker']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_series" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'series_ticker' is set
        if ('series_ticker' not in params or
                params['series_ticker'] is None):
            raise ValueError("Missing the required parameter `series_ticker` when calling `get_series`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'series_ticker' in params:
            path_params['series_ticker'] = params['series_ticker']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/series/{series_ticker}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSeriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trades(self, **kwargs):  # noqa: E501
        """GetTrades  # noqa: E501

        Endpoint for getting all trades for all markets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trades(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cursor: The Cursor represents a pointer to the next page of records in the pagination. So this optional parameter, when filled, should be filled with the cursor string returned in a previous request to this end-point. Filling this would basically tell the api to get the next page containing the number of records passed on the limit parameter. On the other side not filling it tells the api you want to get the first page for another query. The cursor does not store any filters, so if any filter parameters like ticker, max_ts or min_ts were passed in the original query they must be passed again.
        :param int limit: Parameter to specify the number of results per page. Defaults to 100.
        :param str ticker: Parameter to specify a specific market to get trades from.
        :param int min_ts: Restricts the response to trades after a timestamp.
        :param int max_ts: Restricts the response to trades before a timestamp.
        :return: PublicTradesGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trades_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_trades_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_trades_with_http_info(self, **kwargs):  # noqa: E501
        """GetTrades  # noqa: E501

        Endpoint for getting all trades for all markets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trades_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cursor: The Cursor represents a pointer to the next page of records in the pagination. So this optional parameter, when filled, should be filled with the cursor string returned in a previous request to this end-point. Filling this would basically tell the api to get the next page containing the number of records passed on the limit parameter. On the other side not filling it tells the api you want to get the first page for another query. The cursor does not store any filters, so if any filter parameters like ticker, max_ts or min_ts were passed in the original query they must be passed again.
        :param int limit: Parameter to specify the number of results per page. Defaults to 100.
        :param str ticker: Parameter to specify a specific market to get trades from.
        :param int min_ts: Restricts the response to trades after a timestamp.
        :param int max_ts: Restricts the response to trades before a timestamp.
        :return: PublicTradesGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cursor', 'limit', 'ticker', 'min_ts', 'max_ts']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trades" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'ticker' in params:
            query_params.append(('ticker', params['ticker']))  # noqa: E501
        if 'min_ts' in params:
            query_params.append(('min_ts', params['min_ts']))  # noqa: E501
        if 'max_ts' in params:
            query_params.append(('max_ts', params['max_ts']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/markets/trades', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublicTradesGetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
