# coding: utf-8

"""
    Kalshi Trade API

    This documentation describes Kalshi's trading API (known as Trade API v2). By using this API, you agree to Kalshi's Developer Agreement (https://kalshi.com/developer-agreement).  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@kalshi.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateOrderRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'str',
        'buy_max_cost': 'int',
        'client_order_id': 'str',
        'count': 'int',
        'expiration_ts': 'int',
        'no_price': 'int',
        'sell_position_floor': 'int',
        'side': 'str',
        'ticker': 'str',
        'type': 'str',
        'yes_price': 'int'
    }

    attribute_map = {
        'action': 'action',
        'buy_max_cost': 'buy_max_cost',
        'client_order_id': 'client_order_id',
        'count': 'count',
        'expiration_ts': 'expiration_ts',
        'no_price': 'no_price',
        'sell_position_floor': 'sell_position_floor',
        'side': 'side',
        'ticker': 'ticker',
        'type': 'type',
        'yes_price': 'yes_price'
    }

    def __init__(self, action=None, buy_max_cost=None, client_order_id=None, count=None, expiration_ts=None, no_price=None, sell_position_floor=None, side=None, ticker=None, type=None, yes_price=None):  # noqa: E501
        """CreateOrderRequest - a model defined in Swagger"""  # noqa: E501
        self._action = None
        self._buy_max_cost = None
        self._client_order_id = None
        self._count = None
        self._expiration_ts = None
        self._no_price = None
        self._sell_position_floor = None
        self._side = None
        self._ticker = None
        self._type = None
        self._yes_price = None
        self.discriminator = None
        self.action = action
        if buy_max_cost is not None:
            self.buy_max_cost = buy_max_cost
        self.client_order_id = client_order_id
        self.count = count
        if expiration_ts is not None:
            self.expiration_ts = expiration_ts
        if no_price is not None:
            self.no_price = no_price
        if sell_position_floor is not None:
            self.sell_position_floor = sell_position_floor
        self.side = side
        self.ticker = ticker
        self.type = type
        if yes_price is not None:
            self.yes_price = yes_price

    @property
    def action(self):
        """Gets the action of this CreateOrderRequest.  # noqa: E501

        Specifies if this is a buy or sell order.  # noqa: E501

        :return: The action of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this CreateOrderRequest.

        Specifies if this is a buy or sell order.  # noqa: E501

        :param action: The action of this CreateOrderRequest.  # noqa: E501
        :type: str
        """
        if action is None:
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501

        self._action = action

    @property
    def buy_max_cost(self):
        """Gets the buy_max_cost of this CreateOrderRequest.  # noqa: E501

        If type = market and action = buy, buy_max_cost represents the maximum cents that can be spent to acquire a position.  # noqa: E501

        :return: The buy_max_cost of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._buy_max_cost

    @buy_max_cost.setter
    def buy_max_cost(self, buy_max_cost):
        """Sets the buy_max_cost of this CreateOrderRequest.

        If type = market and action = buy, buy_max_cost represents the maximum cents that can be spent to acquire a position.  # noqa: E501

        :param buy_max_cost: The buy_max_cost of this CreateOrderRequest.  # noqa: E501
        :type: int
        """

        self._buy_max_cost = buy_max_cost

    @property
    def client_order_id(self):
        """Gets the client_order_id of this CreateOrderRequest.  # noqa: E501

        Member-provided UUID to attach to the order.  # noqa: E501

        :return: The client_order_id of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._client_order_id

    @client_order_id.setter
    def client_order_id(self, client_order_id):
        """Sets the client_order_id of this CreateOrderRequest.

        Member-provided UUID to attach to the order.  # noqa: E501

        :param client_order_id: The client_order_id of this CreateOrderRequest.  # noqa: E501
        :type: str
        """
        if client_order_id is None:
            raise ValueError("Invalid value for `client_order_id`, must not be `None`")  # noqa: E501

        self._client_order_id = client_order_id

    @property
    def count(self):
        """Gets the count of this CreateOrderRequest.  # noqa: E501

        Number of contracts to be bought or sold.  # noqa: E501

        :return: The count of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """Sets the count of this CreateOrderRequest.

        Number of contracts to be bought or sold.  # noqa: E501

        :param count: The count of this CreateOrderRequest.  # noqa: E501
        :type: int
        """
        if count is None:
            raise ValueError("Invalid value for `count`, must not be `None`")  # noqa: E501

        self._count = count

    @property
    def expiration_ts(self):
        """Gets the expiration_ts of this CreateOrderRequest.  # noqa: E501

        Expiration time of the order, in unix seconds.  If this is not supplied, the order won't expire until explicitly cancelled. This is also known as Good 'Till Cancelled (GTC).  If the time is in the past, the order will attempt to partially or completely fill and the remaining unfilled quantity will be cancelled. This is also known as Immediate-or-Cancel (IOC).  If the time is in the future, the remaining unfilled quantity order will expire at the specified time.  # noqa: E501

        :return: The expiration_ts of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._expiration_ts

    @expiration_ts.setter
    def expiration_ts(self, expiration_ts):
        """Sets the expiration_ts of this CreateOrderRequest.

        Expiration time of the order, in unix seconds.  If this is not supplied, the order won't expire until explicitly cancelled. This is also known as Good 'Till Cancelled (GTC).  If the time is in the past, the order will attempt to partially or completely fill and the remaining unfilled quantity will be cancelled. This is also known as Immediate-or-Cancel (IOC).  If the time is in the future, the remaining unfilled quantity order will expire at the specified time.  # noqa: E501

        :param expiration_ts: The expiration_ts of this CreateOrderRequest.  # noqa: E501
        :type: int
        """

        self._expiration_ts = expiration_ts

    @property
    def no_price(self):
        """Gets the no_price of this CreateOrderRequest.  # noqa: E501

        Submitting price of the No side of the trade, in cents. Exactly one of yes_price and no_price must be passed. If both prices are passed, return 400.  # noqa: E501

        :return: The no_price of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._no_price

    @no_price.setter
    def no_price(self, no_price):
        """Sets the no_price of this CreateOrderRequest.

        Submitting price of the No side of the trade, in cents. Exactly one of yes_price and no_price must be passed. If both prices are passed, return 400.  # noqa: E501

        :param no_price: The no_price of this CreateOrderRequest.  # noqa: E501
        :type: int
        """

        self._no_price = no_price

    @property
    def sell_position_floor(self):
        """Gets the sell_position_floor of this CreateOrderRequest.  # noqa: E501

        SellPositionFloor will not let you flip position for a market order if set to 0.  # noqa: E501

        :return: The sell_position_floor of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._sell_position_floor

    @sell_position_floor.setter
    def sell_position_floor(self, sell_position_floor):
        """Sets the sell_position_floor of this CreateOrderRequest.

        SellPositionFloor will not let you flip position for a market order if set to 0.  # noqa: E501

        :param sell_position_floor: The sell_position_floor of this CreateOrderRequest.  # noqa: E501
        :type: int
        """

        self._sell_position_floor = sell_position_floor

    @property
    def side(self):
        """Gets the side of this CreateOrderRequest.  # noqa: E501

        Specifies if this is a 'yes' or 'no' order.  # noqa: E501

        :return: The side of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._side

    @side.setter
    def side(self, side):
        """Sets the side of this CreateOrderRequest.

        Specifies if this is a 'yes' or 'no' order.  # noqa: E501

        :param side: The side of this CreateOrderRequest.  # noqa: E501
        :type: str
        """
        if side is None:
            raise ValueError("Invalid value for `side`, must not be `None`")  # noqa: E501

        self._side = side

    @property
    def ticker(self):
        """Gets the ticker of this CreateOrderRequest.  # noqa: E501

        The ticker of the market the order will be placed in.  # noqa: E501

        :return: The ticker of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._ticker

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this CreateOrderRequest.

        The ticker of the market the order will be placed in.  # noqa: E501

        :param ticker: The ticker of this CreateOrderRequest.  # noqa: E501
        :type: str
        """
        if ticker is None:
            raise ValueError("Invalid value for `ticker`, must not be `None`")  # noqa: E501

        self._ticker = ticker

    @property
    def type(self):
        """Gets the type of this CreateOrderRequest.  # noqa: E501

        Specifies if this is a \"market\" or a \"limit\" order. Note that either the Yes Price or the No Price must be provided for limit orders.  # noqa: E501

        :return: The type of this CreateOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CreateOrderRequest.

        Specifies if this is a \"market\" or a \"limit\" order. Note that either the Yes Price or the No Price must be provided for limit orders.  # noqa: E501

        :param type: The type of this CreateOrderRequest.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def yes_price(self):
        """Gets the yes_price of this CreateOrderRequest.  # noqa: E501

        Submitting price of the Yes side of the trade, in cents. Exactly one of yes_price and no_price must be passed. If both prices are passed, return 400.  # noqa: E501

        :return: The yes_price of this CreateOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._yes_price

    @yes_price.setter
    def yes_price(self, yes_price):
        """Sets the yes_price of this CreateOrderRequest.

        Submitting price of the Yes side of the trade, in cents. Exactly one of yes_price and no_price must be passed. If both prices are passed, return 400.  # noqa: E501

        :param yes_price: The yes_price of this CreateOrderRequest.  # noqa: E501
        :type: int
        """

        self._yes_price = yes_price

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateOrderRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateOrderRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
