# coding: utf-8

"""
    Kalshi Trade API

    This documentation describes Kalshi's trading API (known as Trade API v2). By using this API, you agree to Kalshi's Developer Agreement (https://kalshi.com/developer-agreement).  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@kalshi.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EventData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category': 'str',
        'event_ticker': 'str',
        'mutually_exclusive': 'bool',
        'series_ticker': 'str',
        'strike_date': 'OutputTime',
        'strike_period': 'str',
        'sub_title': 'str',
        'title': 'str'
    }

    attribute_map = {
        'category': 'category',
        'event_ticker': 'event_ticker',
        'mutually_exclusive': 'mutually_exclusive',
        'series_ticker': 'series_ticker',
        'strike_date': 'strike_date',
        'strike_period': 'strike_period',
        'sub_title': 'sub_title',
        'title': 'title'
    }

    def __init__(self, category=None, event_ticker=None, mutually_exclusive=None, series_ticker=None, strike_date=None, strike_period=None, sub_title=None, title=None):  # noqa: E501
        """EventData - a model defined in Swagger"""  # noqa: E501
        self._category = None
        self._event_ticker = None
        self._mutually_exclusive = None
        self._series_ticker = None
        self._strike_date = None
        self._strike_period = None
        self._sub_title = None
        self._title = None
        self.discriminator = None
        self.category = category
        self.event_ticker = event_ticker
        self.mutually_exclusive = mutually_exclusive
        self.series_ticker = series_ticker
        if strike_date is not None:
            self.strike_date = strike_date
        if strike_period is not None:
            self.strike_period = strike_period
        self.sub_title = sub_title
        self.title = title

    @property
    def category(self):
        """Gets the category of this EventData.  # noqa: E501

        Event category.  # noqa: E501

        :return: The category of this EventData.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this EventData.

        Event category.  # noqa: E501

        :param category: The category of this EventData.  # noqa: E501
        :type: str
        """
        if category is None:
            raise ValueError("Invalid value for `category`, must not be `None`")  # noqa: E501

        self._category = category

    @property
    def event_ticker(self):
        """Gets the event_ticker of this EventData.  # noqa: E501

        Unique identifier for events.  # noqa: E501

        :return: The event_ticker of this EventData.  # noqa: E501
        :rtype: str
        """
        return self._event_ticker

    @event_ticker.setter
    def event_ticker(self, event_ticker):
        """Sets the event_ticker of this EventData.

        Unique identifier for events.  # noqa: E501

        :param event_ticker: The event_ticker of this EventData.  # noqa: E501
        :type: str
        """
        if event_ticker is None:
            raise ValueError("Invalid value for `event_ticker`, must not be `None`")  # noqa: E501

        self._event_ticker = event_ticker

    @property
    def mutually_exclusive(self):
        """Gets the mutually_exclusive of this EventData.  # noqa: E501

        If true then the event is mutually exclusive.  # noqa: E501

        :return: The mutually_exclusive of this EventData.  # noqa: E501
        :rtype: bool
        """
        return self._mutually_exclusive

    @mutually_exclusive.setter
    def mutually_exclusive(self, mutually_exclusive):
        """Sets the mutually_exclusive of this EventData.

        If true then the event is mutually exclusive.  # noqa: E501

        :param mutually_exclusive: The mutually_exclusive of this EventData.  # noqa: E501
        :type: bool
        """
        if mutually_exclusive is None:
            raise ValueError("Invalid value for `mutually_exclusive`, must not be `None`")  # noqa: E501

        self._mutually_exclusive = mutually_exclusive

    @property
    def series_ticker(self):
        """Gets the series_ticker of this EventData.  # noqa: E501

        Unique identifier for series.  # noqa: E501

        :return: The series_ticker of this EventData.  # noqa: E501
        :rtype: str
        """
        return self._series_ticker

    @series_ticker.setter
    def series_ticker(self, series_ticker):
        """Sets the series_ticker of this EventData.

        Unique identifier for series.  # noqa: E501

        :param series_ticker: The series_ticker of this EventData.  # noqa: E501
        :type: str
        """
        if series_ticker is None:
            raise ValueError("Invalid value for `series_ticker`, must not be `None`")  # noqa: E501

        self._series_ticker = series_ticker

    @property
    def strike_date(self):
        """Gets the strike_date of this EventData.  # noqa: E501


        :return: The strike_date of this EventData.  # noqa: E501
        :rtype: OutputTime
        """
        return self._strike_date

    @strike_date.setter
    def strike_date(self, strike_date):
        """Sets the strike_date of this EventData.


        :param strike_date: The strike_date of this EventData.  # noqa: E501
        :type: OutputTime
        """

        self._strike_date = strike_date

    @property
    def strike_period(self):
        """Gets the strike_period of this EventData.  # noqa: E501

        The strike period for this event. This will be filled when the event strike is not a date. If it is a date then the 'strike_date' field should be filled instead.  # noqa: E501

        :return: The strike_period of this EventData.  # noqa: E501
        :rtype: str
        """
        return self._strike_period

    @strike_period.setter
    def strike_period(self, strike_period):
        """Sets the strike_period of this EventData.

        The strike period for this event. This will be filled when the event strike is not a date. If it is a date then the 'strike_date' field should be filled instead.  # noqa: E501

        :param strike_period: The strike_period of this EventData.  # noqa: E501
        :type: str
        """

        self._strike_period = strike_period

    @property
    def sub_title(self):
        """Gets the sub_title of this EventData.  # noqa: E501

        Shortened title.  # noqa: E501

        :return: The sub_title of this EventData.  # noqa: E501
        :rtype: str
        """
        return self._sub_title

    @sub_title.setter
    def sub_title(self, sub_title):
        """Sets the sub_title of this EventData.

        Shortened title.  # noqa: E501

        :param sub_title: The sub_title of this EventData.  # noqa: E501
        :type: str
        """
        if sub_title is None:
            raise ValueError("Invalid value for `sub_title`, must not be `None`")  # noqa: E501

        self._sub_title = sub_title

    @property
    def title(self):
        """Gets the title of this EventData.  # noqa: E501

        Event title.  # noqa: E501

        :return: The title of this EventData.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this EventData.

        Event title.  # noqa: E501

        :param title: The title of this EventData.  # noqa: E501
        :type: str
        """
        if title is None:
            raise ValueError("Invalid value for `title`, must not be `None`")  # noqa: E501

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EventData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
