# coding: utf-8

"""
    Kalshi Trade API

    This documentation describes Kalshi's trading API (known as Trade API v2). By using this API, you agree to Kalshi's Developer Agreement (https://kalshi.com/developer-agreement).  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@kalshi.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class MarketPosition(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'fees_paid': 'int',
        'market_exposure': 'int',
        'position': 'int',
        'realized_pnl': 'int',
        'resting_orders_count': 'int',
        'ticker': 'str',
        'total_traded': 'int'
    }

    attribute_map = {
        'fees_paid': 'fees_paid',
        'market_exposure': 'market_exposure',
        'position': 'position',
        'realized_pnl': 'realized_pnl',
        'resting_orders_count': 'resting_orders_count',
        'ticker': 'ticker',
        'total_traded': 'total_traded'
    }

    def __init__(self, fees_paid=None, market_exposure=None, position=None, realized_pnl=None, resting_orders_count=None, ticker=None, total_traded=None):  # noqa: E501
        """MarketPosition - a model defined in Swagger"""  # noqa: E501
        self._fees_paid = None
        self._market_exposure = None
        self._position = None
        self._realized_pnl = None
        self._resting_orders_count = None
        self._ticker = None
        self._total_traded = None
        self.discriminator = None
        self.fees_paid = fees_paid
        self.market_exposure = market_exposure
        self.position = position
        self.realized_pnl = realized_pnl
        self.resting_orders_count = resting_orders_count
        self.ticker = ticker
        self.total_traded = total_traded

    @property
    def fees_paid(self):
        """Gets the fees_paid of this MarketPosition.  # noqa: E501

        Fees paid on fill orders, in cents.  # noqa: E501

        :return: The fees_paid of this MarketPosition.  # noqa: E501
        :rtype: int
        """
        return self._fees_paid

    @fees_paid.setter
    def fees_paid(self, fees_paid):
        """Sets the fees_paid of this MarketPosition.

        Fees paid on fill orders, in cents.  # noqa: E501

        :param fees_paid: The fees_paid of this MarketPosition.  # noqa: E501
        :type: int
        """
        if fees_paid is None:
            raise ValueError("Invalid value for `fees_paid`, must not be `None`")  # noqa: E501

        self._fees_paid = fees_paid

    @property
    def market_exposure(self):
        """Gets the market_exposure of this MarketPosition.  # noqa: E501

        Cost of the aggregate market position in cents.  # noqa: E501

        :return: The market_exposure of this MarketPosition.  # noqa: E501
        :rtype: int
        """
        return self._market_exposure

    @market_exposure.setter
    def market_exposure(self, market_exposure):
        """Sets the market_exposure of this MarketPosition.

        Cost of the aggregate market position in cents.  # noqa: E501

        :param market_exposure: The market_exposure of this MarketPosition.  # noqa: E501
        :type: int
        """
        if market_exposure is None:
            raise ValueError("Invalid value for `market_exposure`, must not be `None`")  # noqa: E501

        self._market_exposure = market_exposure

    @property
    def position(self):
        """Gets the position of this MarketPosition.  # noqa: E501

        Number of contracts bought in this market. Negative means NO contracts and positive means YES contracts.  # noqa: E501

        :return: The position of this MarketPosition.  # noqa: E501
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """Sets the position of this MarketPosition.

        Number of contracts bought in this market. Negative means NO contracts and positive means YES contracts.  # noqa: E501

        :param position: The position of this MarketPosition.  # noqa: E501
        :type: int
        """
        if position is None:
            raise ValueError("Invalid value for `position`, must not be `None`")  # noqa: E501

        self._position = position

    @property
    def realized_pnl(self):
        """Gets the realized_pnl of this MarketPosition.  # noqa: E501

        Locked in profit and loss, in cents.  # noqa: E501

        :return: The realized_pnl of this MarketPosition.  # noqa: E501
        :rtype: int
        """
        return self._realized_pnl

    @realized_pnl.setter
    def realized_pnl(self, realized_pnl):
        """Sets the realized_pnl of this MarketPosition.

        Locked in profit and loss, in cents.  # noqa: E501

        :param realized_pnl: The realized_pnl of this MarketPosition.  # noqa: E501
        :type: int
        """
        if realized_pnl is None:
            raise ValueError("Invalid value for `realized_pnl`, must not be `None`")  # noqa: E501

        self._realized_pnl = realized_pnl

    @property
    def resting_orders_count(self):
        """Gets the resting_orders_count of this MarketPosition.  # noqa: E501

        Aggregate size of resting orders in contract units.  # noqa: E501

        :return: The resting_orders_count of this MarketPosition.  # noqa: E501
        :rtype: int
        """
        return self._resting_orders_count

    @resting_orders_count.setter
    def resting_orders_count(self, resting_orders_count):
        """Sets the resting_orders_count of this MarketPosition.

        Aggregate size of resting orders in contract units.  # noqa: E501

        :param resting_orders_count: The resting_orders_count of this MarketPosition.  # noqa: E501
        :type: int
        """
        if resting_orders_count is None:
            raise ValueError("Invalid value for `resting_orders_count`, must not be `None`")  # noqa: E501

        self._resting_orders_count = resting_orders_count

    @property
    def ticker(self):
        """Gets the ticker of this MarketPosition.  # noqa: E501

        Unique identifier for the market.  # noqa: E501

        :return: The ticker of this MarketPosition.  # noqa: E501
        :rtype: str
        """
        return self._ticker

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this MarketPosition.

        Unique identifier for the market.  # noqa: E501

        :param ticker: The ticker of this MarketPosition.  # noqa: E501
        :type: str
        """
        if ticker is None:
            raise ValueError("Invalid value for `ticker`, must not be `None`")  # noqa: E501

        self._ticker = ticker

    @property
    def total_traded(self):
        """Gets the total_traded of this MarketPosition.  # noqa: E501

        Total spent on this market in cents.  # noqa: E501

        :return: The total_traded of this MarketPosition.  # noqa: E501
        :rtype: int
        """
        return self._total_traded

    @total_traded.setter
    def total_traded(self, total_traded):
        """Sets the total_traded of this MarketPosition.

        Total spent on this market in cents.  # noqa: E501

        :param total_traded: The total_traded of this MarketPosition.  # noqa: E501
        :type: int
        """
        if total_traded is None:
            raise ValueError("Invalid value for `total_traded`, must not be `None`")  # noqa: E501

        self._total_traded = total_traded

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MarketPosition, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MarketPosition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
