# coding: utf-8

"""
    Kalshi Trade API

    This documentation describes Kalshi's trading API (known as Trade API v2). By using this API, you agree to Kalshi's Developer Agreement (https://kalshi.com/developer-agreement).  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@kalshi.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class MarketStatsPoint(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'no_ask': 'int',
        'no_bid': 'int',
        'open_interest': 'int',
        'ts': 'int',
        'volume': 'int',
        'yes_ask': 'int',
        'yes_bid': 'int',
        'yes_price': 'int'
    }

    attribute_map = {
        'no_ask': 'no_ask',
        'no_bid': 'no_bid',
        'open_interest': 'open_interest',
        'ts': 'ts',
        'volume': 'volume',
        'yes_ask': 'yes_ask',
        'yes_bid': 'yes_bid',
        'yes_price': 'yes_price'
    }

    def __init__(self, no_ask=None, no_bid=None, open_interest=None, ts=None, volume=None, yes_ask=None, yes_bid=None, yes_price=None):  # noqa: E501
        """MarketStatsPoint - a model defined in Swagger"""  # noqa: E501
        self._no_ask = None
        self._no_bid = None
        self._open_interest = None
        self._ts = None
        self._volume = None
        self._yes_ask = None
        self._yes_bid = None
        self._yes_price = None
        self.discriminator = None
        self.no_ask = no_ask
        self.no_bid = no_bid
        self.open_interest = open_interest
        self.ts = ts
        self.volume = volume
        self.yes_ask = yes_ask
        self.yes_bid = yes_bid
        self.yes_price = yes_price

    @property
    def no_ask(self):
        """Gets the no_ask of this MarketStatsPoint.  # noqa: E501

        Price for the lowest NO sell offer on the market by the timestamp in the request (ts).  # noqa: E501

        :return: The no_ask of this MarketStatsPoint.  # noqa: E501
        :rtype: int
        """
        return self._no_ask

    @no_ask.setter
    def no_ask(self, no_ask):
        """Sets the no_ask of this MarketStatsPoint.

        Price for the lowest NO sell offer on the market by the timestamp in the request (ts).  # noqa: E501

        :param no_ask: The no_ask of this MarketStatsPoint.  # noqa: E501
        :type: int
        """
        if no_ask is None:
            raise ValueError("Invalid value for `no_ask`, must not be `None`")  # noqa: E501

        self._no_ask = no_ask

    @property
    def no_bid(self):
        """Gets the no_bid of this MarketStatsPoint.  # noqa: E501

        Price for the highest NO buy offer on the market by the timestamp in the request (ts).  # noqa: E501

        :return: The no_bid of this MarketStatsPoint.  # noqa: E501
        :rtype: int
        """
        return self._no_bid

    @no_bid.setter
    def no_bid(self, no_bid):
        """Sets the no_bid of this MarketStatsPoint.

        Price for the highest NO buy offer on the market by the timestamp in the request (ts).  # noqa: E501

        :param no_bid: The no_bid of this MarketStatsPoint.  # noqa: E501
        :type: int
        """
        if no_bid is None:
            raise ValueError("Invalid value for `no_bid`, must not be `None`")  # noqa: E501

        self._no_bid = no_bid

    @property
    def open_interest(self):
        """Gets the open_interest of this MarketStatsPoint.  # noqa: E501

        Number of contracts bought on the market by the timestamp in the request (ts) disconsidering netting.  # noqa: E501

        :return: The open_interest of this MarketStatsPoint.  # noqa: E501
        :rtype: int
        """
        return self._open_interest

    @open_interest.setter
    def open_interest(self, open_interest):
        """Sets the open_interest of this MarketStatsPoint.

        Number of contracts bought on the market by the timestamp in the request (ts) disconsidering netting.  # noqa: E501

        :param open_interest: The open_interest of this MarketStatsPoint.  # noqa: E501
        :type: int
        """
        if open_interest is None:
            raise ValueError("Invalid value for `open_interest`, must not be `None`")  # noqa: E501

        self._open_interest = open_interest

    @property
    def ts(self):
        """Gets the ts of this MarketStatsPoint.  # noqa: E501

        Unix timestamp for the current statistics entry.  # noqa: E501

        :return: The ts of this MarketStatsPoint.  # noqa: E501
        :rtype: int
        """
        return self._ts

    @ts.setter
    def ts(self, ts):
        """Sets the ts of this MarketStatsPoint.

        Unix timestamp for the current statistics entry.  # noqa: E501

        :param ts: The ts of this MarketStatsPoint.  # noqa: E501
        :type: int
        """
        if ts is None:
            raise ValueError("Invalid value for `ts`, must not be `None`")  # noqa: E501

        self._ts = ts

    @property
    def volume(self):
        """Gets the volume of this MarketStatsPoint.  # noqa: E501

        Number of contracts bought on the market by the timestamp in the request (ts).  # noqa: E501

        :return: The volume of this MarketStatsPoint.  # noqa: E501
        :rtype: int
        """
        return self._volume

    @volume.setter
    def volume(self, volume):
        """Sets the volume of this MarketStatsPoint.

        Number of contracts bought on the market by the timestamp in the request (ts).  # noqa: E501

        :param volume: The volume of this MarketStatsPoint.  # noqa: E501
        :type: int
        """
        if volume is None:
            raise ValueError("Invalid value for `volume`, must not be `None`")  # noqa: E501

        self._volume = volume

    @property
    def yes_ask(self):
        """Gets the yes_ask of this MarketStatsPoint.  # noqa: E501

        Price for the lowest YES sell offer on the market by the timestamp in the request (ts).  # noqa: E501

        :return: The yes_ask of this MarketStatsPoint.  # noqa: E501
        :rtype: int
        """
        return self._yes_ask

    @yes_ask.setter
    def yes_ask(self, yes_ask):
        """Sets the yes_ask of this MarketStatsPoint.

        Price for the lowest YES sell offer on the market by the timestamp in the request (ts).  # noqa: E501

        :param yes_ask: The yes_ask of this MarketStatsPoint.  # noqa: E501
        :type: int
        """
        if yes_ask is None:
            raise ValueError("Invalid value for `yes_ask`, must not be `None`")  # noqa: E501

        self._yes_ask = yes_ask

    @property
    def yes_bid(self):
        """Gets the yes_bid of this MarketStatsPoint.  # noqa: E501

        Price for the highest YES buy offer on the market by the timestamp in the request (ts).  # noqa: E501

        :return: The yes_bid of this MarketStatsPoint.  # noqa: E501
        :rtype: int
        """
        return self._yes_bid

    @yes_bid.setter
    def yes_bid(self, yes_bid):
        """Sets the yes_bid of this MarketStatsPoint.

        Price for the highest YES buy offer on the market by the timestamp in the request (ts).  # noqa: E501

        :param yes_bid: The yes_bid of this MarketStatsPoint.  # noqa: E501
        :type: int
        """
        if yes_bid is None:
            raise ValueError("Invalid value for `yes_bid`, must not be `None`")  # noqa: E501

        self._yes_bid = yes_bid

    @property
    def yes_price(self):
        """Gets the yes_price of this MarketStatsPoint.  # noqa: E501

        Price for the last traded yes contract on the market by the timestamp in the request (ts).  # noqa: E501

        :return: The yes_price of this MarketStatsPoint.  # noqa: E501
        :rtype: int
        """
        return self._yes_price

    @yes_price.setter
    def yes_price(self, yes_price):
        """Sets the yes_price of this MarketStatsPoint.

        Price for the last traded yes contract on the market by the timestamp in the request (ts).  # noqa: E501

        :param yes_price: The yes_price of this MarketStatsPoint.  # noqa: E501
        :type: int
        """
        if yes_price is None:
            raise ValueError("Invalid value for `yes_price`, must not be `None`")  # noqa: E501

        self._yes_price = yes_price

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MarketStatsPoint, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MarketStatsPoint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
