# coding: utf-8

"""
    Kalshi Trade API

    This documentation describes Kalshi's trading API (known as Trade API v2). By using this API, you agree to Kalshi's Developer Agreement (https://kalshi.com/developer-agreement).  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@kalshi.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OrderConfirmation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'str',
        'client_order_id': 'str',
        'created_time': 'OutputTime',
        'expiration_time': 'OutputTime',
        'no_price': 'int',
        'order_id': 'str',
        'side': 'str',
        'status': 'str',
        'ticker': 'str',
        'type': 'str',
        'user_id': 'str',
        'yes_price': 'int'
    }

    attribute_map = {
        'action': 'action',
        'client_order_id': 'client_order_id',
        'created_time': 'created_time',
        'expiration_time': 'expiration_time',
        'no_price': 'no_price',
        'order_id': 'order_id',
        'side': 'side',
        'status': 'status',
        'ticker': 'ticker',
        'type': 'type',
        'user_id': 'user_id',
        'yes_price': 'yes_price'
    }

    def __init__(self, action=None, client_order_id=None, created_time=None, expiration_time=None, no_price=None, order_id=None, side=None, status=None, ticker=None, type=None, user_id=None, yes_price=None):  # noqa: E501
        """OrderConfirmation - a model defined in Swagger"""  # noqa: E501
        self._action = None
        self._client_order_id = None
        self._created_time = None
        self._expiration_time = None
        self._no_price = None
        self._order_id = None
        self._side = None
        self._status = None
        self._ticker = None
        self._type = None
        self._user_id = None
        self._yes_price = None
        self.discriminator = None
        self.action = action
        self.client_order_id = client_order_id
        if created_time is not None:
            self.created_time = created_time
        if expiration_time is not None:
            self.expiration_time = expiration_time
        self.no_price = no_price
        self.order_id = order_id
        self.side = side
        self.status = status
        self.ticker = ticker
        self.type = type
        if user_id is not None:
            self.user_id = user_id
        self.yes_price = yes_price

    @property
    def action(self):
        """Gets the action of this OrderConfirmation.  # noqa: E501

        Representing trade action; currently supports buy and sell.  # noqa: E501

        :return: The action of this OrderConfirmation.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this OrderConfirmation.

        Representing trade action; currently supports buy and sell.  # noqa: E501

        :param action: The action of this OrderConfirmation.  # noqa: E501
        :type: str
        """
        if action is None:
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        allowed_values = ["buy", "sell", ""]  # noqa: E501
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def client_order_id(self):
        """Gets the client_order_id of this OrderConfirmation.  # noqa: E501

        Optional unique identifier for order placement.  # noqa: E501

        :return: The client_order_id of this OrderConfirmation.  # noqa: E501
        :rtype: str
        """
        return self._client_order_id

    @client_order_id.setter
    def client_order_id(self, client_order_id):
        """Sets the client_order_id of this OrderConfirmation.

        Optional unique identifier for order placement.  # noqa: E501

        :param client_order_id: The client_order_id of this OrderConfirmation.  # noqa: E501
        :type: str
        """
        if client_order_id is None:
            raise ValueError("Invalid value for `client_order_id`, must not be `None`")  # noqa: E501

        self._client_order_id = client_order_id

    @property
    def created_time(self):
        """Gets the created_time of this OrderConfirmation.  # noqa: E501


        :return: The created_time of this OrderConfirmation.  # noqa: E501
        :rtype: OutputTime
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this OrderConfirmation.


        :param created_time: The created_time of this OrderConfirmation.  # noqa: E501
        :type: OutputTime
        """

        self._created_time = created_time

    @property
    def expiration_time(self):
        """Gets the expiration_time of this OrderConfirmation.  # noqa: E501


        :return: The expiration_time of this OrderConfirmation.  # noqa: E501
        :rtype: OutputTime
        """
        return self._expiration_time

    @expiration_time.setter
    def expiration_time(self, expiration_time):
        """Sets the expiration_time of this OrderConfirmation.


        :param expiration_time: The expiration_time of this OrderConfirmation.  # noqa: E501
        :type: OutputTime
        """

        self._expiration_time = expiration_time

    @property
    def no_price(self):
        """Gets the no_price of this OrderConfirmation.  # noqa: E501

        The no price for this order in cents.  # noqa: E501

        :return: The no_price of this OrderConfirmation.  # noqa: E501
        :rtype: int
        """
        return self._no_price

    @no_price.setter
    def no_price(self, no_price):
        """Sets the no_price of this OrderConfirmation.

        The no price for this order in cents.  # noqa: E501

        :param no_price: The no_price of this OrderConfirmation.  # noqa: E501
        :type: int
        """
        if no_price is None:
            raise ValueError("Invalid value for `no_price`, must not be `None`")  # noqa: E501

        self._no_price = no_price

    @property
    def order_id(self):
        """Gets the order_id of this OrderConfirmation.  # noqa: E501

        Unique identifier for orders.  # noqa: E501

        :return: The order_id of this OrderConfirmation.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this OrderConfirmation.

        Unique identifier for orders.  # noqa: E501

        :param order_id: The order_id of this OrderConfirmation.  # noqa: E501
        :type: str
        """
        if order_id is None:
            raise ValueError("Invalid value for `order_id`, must not be `None`")  # noqa: E501

        self._order_id = order_id

    @property
    def side(self):
        """Gets the side of this OrderConfirmation.  # noqa: E501

        Representing direction of the order; currently supports yes and no.  # noqa: E501

        :return: The side of this OrderConfirmation.  # noqa: E501
        :rtype: str
        """
        return self._side

    @side.setter
    def side(self, side):
        """Sets the side of this OrderConfirmation.

        Representing direction of the order; currently supports yes and no.  # noqa: E501

        :param side: The side of this OrderConfirmation.  # noqa: E501
        :type: str
        """
        if side is None:
            raise ValueError("Invalid value for `side`, must not be `None`")  # noqa: E501
        allowed_values = ["yes", "no", ""]  # noqa: E501
        if side not in allowed_values:
            raise ValueError(
                "Invalid value for `side` ({0}), must be one of {1}"  # noqa: E501
                .format(side, allowed_values)
            )

        self._side = side

    @property
    def status(self):
        """Gets the status of this OrderConfirmation.  # noqa: E501

        The current status of a given order.  # noqa: E501

        :return: The status of this OrderConfirmation.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this OrderConfirmation.

        The current status of a given order.  # noqa: E501

        :param status: The status of this OrderConfirmation.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["resting", "canceled", "executed", "pending"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def ticker(self):
        """Gets the ticker of this OrderConfirmation.  # noqa: E501

        Unique identifier for markets.  # noqa: E501

        :return: The ticker of this OrderConfirmation.  # noqa: E501
        :rtype: str
        """
        return self._ticker

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this OrderConfirmation.

        Unique identifier for markets.  # noqa: E501

        :param ticker: The ticker of this OrderConfirmation.  # noqa: E501
        :type: str
        """
        if ticker is None:
            raise ValueError("Invalid value for `ticker`, must not be `None`")  # noqa: E501

        self._ticker = ticker

    @property
    def type(self):
        """Gets the type of this OrderConfirmation.  # noqa: E501

        Representing order type; currently supports \"market\" and \"limit\".  # noqa: E501

        :return: The type of this OrderConfirmation.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OrderConfirmation.

        Representing order type; currently supports \"market\" and \"limit\".  # noqa: E501

        :param type: The type of this OrderConfirmation.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["", "market", "limit"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def user_id(self):
        """Gets the user_id of this OrderConfirmation.  # noqa: E501


        :return: The user_id of this OrderConfirmation.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this OrderConfirmation.


        :param user_id: The user_id of this OrderConfirmation.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def yes_price(self):
        """Gets the yes_price of this OrderConfirmation.  # noqa: E501

        The yes price for this order in cents.  # noqa: E501

        :return: The yes_price of this OrderConfirmation.  # noqa: E501
        :rtype: int
        """
        return self._yes_price

    @yes_price.setter
    def yes_price(self, yes_price):
        """Sets the yes_price of this OrderConfirmation.

        The yes price for this order in cents.  # noqa: E501

        :param yes_price: The yes_price of this OrderConfirmation.  # noqa: E501
        :type: int
        """
        if yes_price is None:
            raise ValueError("Invalid value for `yes_price`, must not be `None`")  # noqa: E501

        self._yes_price = yes_price

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrderConfirmation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderConfirmation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
