# coding: utf-8

"""
    Kalshi Trade API

    This documentation describes Kalshi's trading API (known as Trade API v2). By using this API, you agree to Kalshi's Developer Agreement (https://kalshi.com/developer-agreement).  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@kalshi.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Series(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'frequency': 'str',
        'ticker': 'str',
        'title': 'str'
    }

    attribute_map = {
        'frequency': 'frequency',
        'ticker': 'ticker',
        'title': 'title'
    }

    def __init__(self, frequency=None, ticker=None, title=None):  # noqa: E501
        """Series - a model defined in Swagger"""  # noqa: E501
        self._frequency = None
        self._ticker = None
        self._title = None
        self.discriminator = None
        self.frequency = frequency
        self.ticker = ticker
        self.title = title

    @property
    def frequency(self):
        """Gets the frequency of this Series.  # noqa: E501

        Description of the frequency of the series. There is no fixed value set here, but will be something human-readable like: weekly, daily, one-off.  # noqa: E501

        :return: The frequency of this Series.  # noqa: E501
        :rtype: str
        """
        return self._frequency

    @frequency.setter
    def frequency(self, frequency):
        """Sets the frequency of this Series.

        Description of the frequency of the series. There is no fixed value set here, but will be something human-readable like: weekly, daily, one-off.  # noqa: E501

        :param frequency: The frequency of this Series.  # noqa: E501
        :type: str
        """
        if frequency is None:
            raise ValueError("Invalid value for `frequency`, must not be `None`")  # noqa: E501

        self._frequency = frequency

    @property
    def ticker(self):
        """Gets the ticker of this Series.  # noqa: E501

        Ticker that identifies this series.  # noqa: E501

        :return: The ticker of this Series.  # noqa: E501
        :rtype: str
        """
        return self._ticker

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this Series.

        Ticker that identifies this series.  # noqa: E501

        :param ticker: The ticker of this Series.  # noqa: E501
        :type: str
        """
        if ticker is None:
            raise ValueError("Invalid value for `ticker`, must not be `None`")  # noqa: E501

        self._ticker = ticker

    @property
    def title(self):
        """Gets the title of this Series.  # noqa: E501

        Title describing the series. For full context use you should use this field with the title field of the events belonging to this series.  # noqa: E501

        :return: The title of this Series.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Series.

        Title describing the series. For full context use you should use this field with the title field of the events belonging to this series.  # noqa: E501

        :param title: The title of this Series.  # noqa: E501
        :type: str
        """
        if title is None:
            raise ValueError("Invalid value for `title`, must not be `None`")  # noqa: E501

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Series, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Series):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
