# coding: utf-8

"""
    Kalshi Trade API

    This documentation describes Kalshi's trading API (known as Trade API v2). By using this API, you agree to Kalshi's Developer Agreement (https://kalshi.com/developer-agreement).  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@kalshi.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Settlement(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'market_result': 'str',
        'no_count': 'int',
        'no_total_cost': 'int',
        'revenue': 'int',
        'settled_time': 'OutputTime',
        'ticker': 'str',
        'yes_count': 'int',
        'yes_total_cost': 'int'
    }

    attribute_map = {
        'market_result': 'market_result',
        'no_count': 'no_count',
        'no_total_cost': 'no_total_cost',
        'revenue': 'revenue',
        'settled_time': 'settled_time',
        'ticker': 'ticker',
        'yes_count': 'yes_count',
        'yes_total_cost': 'yes_total_cost'
    }

    def __init__(self, market_result=None, no_count=None, no_total_cost=None, revenue=None, settled_time=None, ticker=None, yes_count=None, yes_total_cost=None):  # noqa: E501
        """Settlement - a model defined in Swagger"""  # noqa: E501
        self._market_result = None
        self._no_count = None
        self._no_total_cost = None
        self._revenue = None
        self._settled_time = None
        self._ticker = None
        self._yes_count = None
        self._yes_total_cost = None
        self.discriminator = None
        self.market_result = market_result
        self.no_count = no_count
        self.no_total_cost = no_total_cost
        self.revenue = revenue
        self.settled_time = settled_time
        self.ticker = ticker
        self.yes_count = yes_count
        self.yes_total_cost = yes_total_cost

    @property
    def market_result(self):
        """Gets the market_result of this Settlement.  # noqa: E501

        Settlement result for this market.  # noqa: E501

        :return: The market_result of this Settlement.  # noqa: E501
        :rtype: str
        """
        return self._market_result

    @market_result.setter
    def market_result(self, market_result):
        """Sets the market_result of this Settlement.

        Settlement result for this market.  # noqa: E501

        :param market_result: The market_result of this Settlement.  # noqa: E501
        :type: str
        """
        if market_result is None:
            raise ValueError("Invalid value for `market_result`, must not be `None`")  # noqa: E501

        self._market_result = market_result

    @property
    def no_count(self):
        """Gets the no_count of this Settlement.  # noqa: E501

        Number of no contracts owned on settlement.  # noqa: E501

        :return: The no_count of this Settlement.  # noqa: E501
        :rtype: int
        """
        return self._no_count

    @no_count.setter
    def no_count(self, no_count):
        """Sets the no_count of this Settlement.

        Number of no contracts owned on settlement.  # noqa: E501

        :param no_count: The no_count of this Settlement.  # noqa: E501
        :type: int
        """
        if no_count is None:
            raise ValueError("Invalid value for `no_count`, must not be `None`")  # noqa: E501

        self._no_count = no_count

    @property
    def no_total_cost(self):
        """Gets the no_total_cost of this Settlement.  # noqa: E501

        Cost of the aggregate no position in this market on settlement in cents.  # noqa: E501

        :return: The no_total_cost of this Settlement.  # noqa: E501
        :rtype: int
        """
        return self._no_total_cost

    @no_total_cost.setter
    def no_total_cost(self, no_total_cost):
        """Sets the no_total_cost of this Settlement.

        Cost of the aggregate no position in this market on settlement in cents.  # noqa: E501

        :param no_total_cost: The no_total_cost of this Settlement.  # noqa: E501
        :type: int
        """
        if no_total_cost is None:
            raise ValueError("Invalid value for `no_total_cost`, must not be `None`")  # noqa: E501

        self._no_total_cost = no_total_cost

    @property
    def revenue(self):
        """Gets the revenue of this Settlement.  # noqa: E501

        Value earned in this settlement in cents.  # noqa: E501

        :return: The revenue of this Settlement.  # noqa: E501
        :rtype: int
        """
        return self._revenue

    @revenue.setter
    def revenue(self, revenue):
        """Sets the revenue of this Settlement.

        Value earned in this settlement in cents.  # noqa: E501

        :param revenue: The revenue of this Settlement.  # noqa: E501
        :type: int
        """
        if revenue is None:
            raise ValueError("Invalid value for `revenue`, must not be `None`")  # noqa: E501

        self._revenue = revenue

    @property
    def settled_time(self):
        """Gets the settled_time of this Settlement.  # noqa: E501


        :return: The settled_time of this Settlement.  # noqa: E501
        :rtype: OutputTime
        """
        return self._settled_time

    @settled_time.setter
    def settled_time(self, settled_time):
        """Sets the settled_time of this Settlement.


        :param settled_time: The settled_time of this Settlement.  # noqa: E501
        :type: OutputTime
        """
        if settled_time is None:
            raise ValueError("Invalid value for `settled_time`, must not be `None`")  # noqa: E501

        self._settled_time = settled_time

    @property
    def ticker(self):
        """Gets the ticker of this Settlement.  # noqa: E501

        Unique identifier for markets.  # noqa: E501

        :return: The ticker of this Settlement.  # noqa: E501
        :rtype: str
        """
        return self._ticker

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this Settlement.

        Unique identifier for markets.  # noqa: E501

        :param ticker: The ticker of this Settlement.  # noqa: E501
        :type: str
        """
        if ticker is None:
            raise ValueError("Invalid value for `ticker`, must not be `None`")  # noqa: E501

        self._ticker = ticker

    @property
    def yes_count(self):
        """Gets the yes_count of this Settlement.  # noqa: E501

        Number of yes contracts owned on settlement.  # noqa: E501

        :return: The yes_count of this Settlement.  # noqa: E501
        :rtype: int
        """
        return self._yes_count

    @yes_count.setter
    def yes_count(self, yes_count):
        """Sets the yes_count of this Settlement.

        Number of yes contracts owned on settlement.  # noqa: E501

        :param yes_count: The yes_count of this Settlement.  # noqa: E501
        :type: int
        """
        if yes_count is None:
            raise ValueError("Invalid value for `yes_count`, must not be `None`")  # noqa: E501

        self._yes_count = yes_count

    @property
    def yes_total_cost(self):
        """Gets the yes_total_cost of this Settlement.  # noqa: E501

        Cost of the aggregate yes position in this market on settlement in cents.  # noqa: E501

        :return: The yes_total_cost of this Settlement.  # noqa: E501
        :rtype: int
        """
        return self._yes_total_cost

    @yes_total_cost.setter
    def yes_total_cost(self, yes_total_cost):
        """Sets the yes_total_cost of this Settlement.

        Cost of the aggregate yes position in this market on settlement in cents.  # noqa: E501

        :param yes_total_cost: The yes_total_cost of this Settlement.  # noqa: E501
        :type: int
        """
        if yes_total_cost is None:
            raise ValueError("Invalid value for `yes_total_cost`, must not be `None`")  # noqa: E501

        self._yes_total_cost = yes_total_cost

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Settlement, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Settlement):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
