# Kalshi Trading API
Complete API for the Kalshi trading platform including all handlers for SDK generation

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 2.1.2
- Generator version: 7.15.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://kalshi.com](https://kalshi.com)

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import kalshi_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import kalshi_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import kalshi_python
from kalshi_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.elections.kalshi.com/trade-api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = kalshi_python.Configuration(
    host = "https://api.elections.kalshi.com/trade-api/v2"
)

# For authenticated requests
config.api_key_id = "your-api-key-id"
config.private_key_pem = "your-private-key"


# Enter a context with an instance of the API client
with kalshi_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = kalshi_python.ApiKeysApi(api_client)
    create_api_key_request = kalshi_python.CreateApiKeyRequest() # CreateApiKeyRequest | 

    try:
        # Create API Key
        api_response = api_instance.create_api_key(create_api_key_request)
        print("The response of ApiKeysApi->create_api_key:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApiKeysApi->create_api_key: %s\n" % e)

```

## Documentation

Full documentation is available at [docs.kalshi.com](https://docs.kalshi.com)


