# coding: utf-8

# flake8: noqa

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

__version__ = "2.1.0"

# import apis into sdk package
from kalshi_python.api.api_keys_api import ApiKeysApi
from kalshi_python.api.communications_api import CommunicationsApi
from kalshi_python.api.events_api import EventsApi
from kalshi_python.api.exchange_api import ExchangeApi
from kalshi_python.api.markets_api import MarketsApi
from kalshi_python.api.milestones_api import MilestonesApi
from kalshi_python.api.multivariate_collections_api import MultivariateCollectionsApi
from kalshi_python.api.portfolio_api import PortfolioApi
from kalshi_python.api.series_api import SeriesApi
from kalshi_python.api.structured_targets_api import StructuredTargetsApi


# import ApiClient
from kalshi_python.api_response import ApiResponse
from kalshi_python.api_client import ApiClient
from kalshi_python.configuration import Configuration
from kalshi_python.exceptions import OpenApiException
from kalshi_python.exceptions import ApiTypeError
from kalshi_python.exceptions import ApiValueError
from kalshi_python.exceptions import ApiKeyError
from kalshi_python.exceptions import ApiAttributeError
from kalshi_python.exceptions import ApiException

# Kalshi-specific authentication extensions
import hashlib
import base64
from cryptography.hazmat.primitives import hashes, serialization
from cryptography.hazmat.primitives.asymmetric import padding
from cryptography.hazmat.backends import default_backend

# Convenience imports for exceptions
from kalshi_python.exceptions import (
    BadRequestException,
    UnauthorizedException, 
    ForbiddenException,
    NotFoundException,
    ConflictException,
    ServiceException,
    UnprocessableEntityException,
)

# import models into sdk package
from kalshi_python.models.accept_quote_request import AcceptQuoteRequest
from kalshi_python.models.amend_order_request import AmendOrderRequest
from kalshi_python.models.amend_order_response import AmendOrderResponse
from kalshi_python.models.announcement import Announcement
from kalshi_python.models.api_key import ApiKey
from kalshi_python.models.batch_cancel_orders_request import BatchCancelOrdersRequest
from kalshi_python.models.batch_cancel_orders_response import BatchCancelOrdersResponse
from kalshi_python.models.batch_cancel_orders_response_responses_inner import BatchCancelOrdersResponseResponsesInner
from kalshi_python.models.batch_create_orders_request import BatchCreateOrdersRequest
from kalshi_python.models.batch_create_orders_response import BatchCreateOrdersResponse
from kalshi_python.models.batch_create_orders_response_responses_inner import BatchCreateOrdersResponseResponsesInner
from kalshi_python.models.cancel_order_response import CancelOrderResponse
from kalshi_python.models.candlestick import Candlestick
from kalshi_python.models.create_api_key_request import CreateApiKeyRequest
from kalshi_python.models.create_api_key_response import CreateApiKeyResponse
from kalshi_python.models.create_order_group_request import CreateOrderGroupRequest
from kalshi_python.models.create_order_group_response import CreateOrderGroupResponse
from kalshi_python.models.create_order_request import CreateOrderRequest
from kalshi_python.models.create_order_response import CreateOrderResponse
from kalshi_python.models.create_quote_request import CreateQuoteRequest
from kalshi_python.models.create_quote_response import CreateQuoteResponse
from kalshi_python.models.create_rfq_request import CreateRFQRequest
from kalshi_python.models.create_rfq_response import CreateRFQResponse
from kalshi_python.models.daily_schedule import DailySchedule
from kalshi_python.models.decrease_order_request import DecreaseOrderRequest
from kalshi_python.models.decrease_order_response import DecreaseOrderResponse
from kalshi_python.models.error_response import ErrorResponse
from kalshi_python.models.error_response_error import ErrorResponseError
from kalshi_python.models.event import Event
from kalshi_python.models.exchange_status import ExchangeStatus
from kalshi_python.models.fill import Fill
from kalshi_python.models.generate_api_key_request import GenerateApiKeyRequest
from kalshi_python.models.generate_api_key_response import GenerateApiKeyResponse
from kalshi_python.models.get_api_keys_response import GetApiKeysResponse
from kalshi_python.models.get_balance_response import GetBalanceResponse
from kalshi_python.models.get_communications_id_response import GetCommunicationsIDResponse
from kalshi_python.models.get_event_metadata_response import GetEventMetadataResponse
from kalshi_python.models.get_event_response import GetEventResponse
from kalshi_python.models.get_events_response import GetEventsResponse
from kalshi_python.models.get_exchange_announcements_response import GetExchangeAnnouncementsResponse
from kalshi_python.models.get_exchange_schedule_response import GetExchangeScheduleResponse
from kalshi_python.models.get_exchange_schedule_response_schedule import GetExchangeScheduleResponseSchedule
from kalshi_python.models.get_fills_response import GetFillsResponse
from kalshi_python.models.get_market_candlesticks_response import GetMarketCandlesticksResponse
from kalshi_python.models.get_market_orderbook_response import GetMarketOrderbookResponse
from kalshi_python.models.get_market_orderbook_response_orderbook import GetMarketOrderbookResponseOrderbook
from kalshi_python.models.get_market_response import GetMarketResponse
from kalshi_python.models.get_markets_response import GetMarketsResponse
from kalshi_python.models.get_milestone_response import GetMilestoneResponse
from kalshi_python.models.get_milestones_response import GetMilestonesResponse
from kalshi_python.models.get_multivariate_event_collection_response import GetMultivariateEventCollectionResponse
from kalshi_python.models.get_multivariate_event_collections_response import GetMultivariateEventCollectionsResponse
from kalshi_python.models.get_order_groups_response import GetOrderGroupsResponse
from kalshi_python.models.get_order_queue_position_response import GetOrderQueuePositionResponse
from kalshi_python.models.get_order_response import GetOrderResponse
from kalshi_python.models.get_orders_response import GetOrdersResponse
from kalshi_python.models.get_positions_response import GetPositionsResponse
from kalshi_python.models.get_queue_positions_request import GetQueuePositionsRequest
from kalshi_python.models.get_queue_positions_response import GetQueuePositionsResponse
from kalshi_python.models.get_quote_response import GetQuoteResponse
from kalshi_python.models.get_quotes_response import GetQuotesResponse
from kalshi_python.models.get_rfq_response import GetRFQResponse
from kalshi_python.models.get_rfqs_response import GetRFQsResponse
from kalshi_python.models.get_series_by_ticker_response import GetSeriesByTickerResponse
from kalshi_python.models.get_series_response import GetSeriesResponse
from kalshi_python.models.get_settlements_response import GetSettlementsResponse
from kalshi_python.models.get_structured_target_response import GetStructuredTargetResponse
from kalshi_python.models.get_structured_targets_response import GetStructuredTargetsResponse
from kalshi_python.models.get_total_resting_order_value_response import GetTotalRestingOrderValueResponse
from kalshi_python.models.get_trades_response import GetTradesResponse
from kalshi_python.models.get_user_data_timestamp_response import GetUserDataTimestampResponse
from kalshi_python.models.lookup_bundle_request import LookupBundleRequest
from kalshi_python.models.lookup_bundle_request_bundle_inner import LookupBundleRequestBundleInner
from kalshi_python.models.lookup_bundle_response import LookupBundleResponse
from kalshi_python.models.market import Market
from kalshi_python.models.milestone import Milestone
from kalshi_python.models.multivariate_event_collection import MultivariateEventCollection
from kalshi_python.models.multivariate_event_collection_events_inner import MultivariateEventCollectionEventsInner
from kalshi_python.models.order import Order
from kalshi_python.models.order_group import OrderGroup
from kalshi_python.models.orderbook_level import OrderbookLevel
from kalshi_python.models.position import Position
from kalshi_python.models.quote import Quote
from kalshi_python.models.rfq import RFQ
from kalshi_python.models.series import Series
from kalshi_python.models.settlement import Settlement
from kalshi_python.models.structured_target import StructuredTarget
from kalshi_python.models.trade import Trade


# KalshiClient with custom authentication
class KalshiClient(ApiClient):
    """Convenience client that combines all API classes into a single interface with Kalshi auth"""
    
    def __init__(self, configuration=None):
        super().__init__(configuration)
        
        # Store auth credentials
        self.api_key_id = None
        self.private_key_pem = None
        
        # Set up authentication if API key and private key are configured
        if configuration and hasattr(configuration, 'api_key_id') and hasattr(configuration, 'private_key_pem'):
            self.api_key_id = configuration.api_key_id
            self.private_key_pem = configuration.private_key_pem
        
        # Initialize all API instances
        self._api_keys_api = ApiKeysApi(self)
        self._communications_api = CommunicationsApi(self)
        self._events_api = EventsApi(self)
        self._exchange_api = ExchangeApi(self)
        self._markets_api = MarketsApi(self)
        self._milestones_api = MilestonesApi(self)
        self._multivariate_collections_api = MultivariateCollectionsApi(self)
        self._portfolio_api = PortfolioApi(self)
        self._series_api = SeriesApi(self)
        self._structured_targets_api = StructuredTargetsApi(self)

    
    def update_params_for_auth(
        self,
        headers,
        queries,
        auth_settings,
        resource_path,
        method,
        body,
        request_auth=None
    ):
        """Override to add Kalshi custom authentication headers"""
        # Skip if no authentication configured
        if not self.api_key_id or not self.private_key_pem:
            return super().update_params_for_auth(
                headers, queries, auth_settings, resource_path, method, body, request_auth
            )
        
        import time
        import json
        
        # Create signature payload
        timestamp_str = str(int(time.time() * 1000))
        
        # Build message to sign: timestamp + method + path (NO BODY)
        # The resource_path doesn't include the base path, so we need to add it
        full_path = f"/trade-api/v2{resource_path}"
        msg_string = f"{timestamp_str}{method.upper()}{full_path}"
        msg_bytes = msg_string.encode('utf-8')
        
        # Load private key
        private_key = serialization.load_pem_private_key(
            self.private_key_pem.encode() if isinstance(self.private_key_pem, str) else self.private_key_pem,
            password=None,
            backend=default_backend()
        )
        
        # Create signature using RSA-PSS
        signature = private_key.sign(
            msg_bytes,
            padding.PSS(
                mgf=padding.MGF1(hashes.SHA256()),
                salt_length=padding.PSS.DIGEST_LENGTH
            ),
            hashes.SHA256()
        )
        
        # Encode signature
        signature_b64 = base64.b64encode(signature).decode('utf-8')
        
        # Add auth headers
        headers['KALSHI-ACCESS-KEY'] = self.api_key_id
        headers['KALSHI-ACCESS-SIGNATURE'] = signature_b64
        headers['KALSHI-ACCESS-TIMESTAMP'] = timestamp_str
        
        return super().update_params_for_auth(
            headers, queries, auth_settings, resource_path, method, body, request_auth
        )
    
    def __getattr__(self, name):
        """Dynamically forward method calls to the appropriate API instance"""
        # Try each API instance to see if it has the method
        api_names = [
            '_api_keys_api',
            '_communications_api',
            '_events_api',
            '_exchange_api',
            '_markets_api',
            '_milestones_api',
            '_multivariate_collections_api',
            '_portfolio_api',
            '_series_api',
            '_structured_targets_api',
        ]
        for api_name in api_names:
            if hasattr(self, api_name):
                api_instance = getattr(self, api_name)
                if hasattr(api_instance, name):
                    return getattr(api_instance, name)
        
        # If not found in any API, raise AttributeError
        raise AttributeError(f"'{type(self).__name__}' object has no attribute '{name}'")