# coding: utf-8

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreateOrderRequest(BaseModel):
    """
    CreateOrderRequest
    """ # noqa: E501
    ticker: StrictStr
    client_order_id: Optional[StrictStr] = None
    side: StrictStr
    action: StrictStr
    count: Annotated[int, Field(strict=True, ge=1)]
    type: StrictStr
    yes_price: Optional[Union[Annotated[float, Field(le=99, strict=True, ge=1)], Annotated[int, Field(le=99, strict=True, ge=1)]]] = None
    no_price: Optional[Union[Annotated[float, Field(le=99, strict=True, ge=1)], Annotated[int, Field(le=99, strict=True, ge=1)]]] = None
    expiration_ts: Optional[StrictInt] = None
    sell_position_floor: Optional[StrictInt] = None
    buy_max_cost: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["ticker", "client_order_id", "side", "action", "count", "type", "yes_price", "no_price", "expiration_ts", "sell_position_floor", "buy_max_cost"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['limit', 'market']):
            raise ValueError("must be one of enum values ('limit', 'market')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateOrderRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateOrderRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "client_order_id": obj.get("client_order_id"),
            "side": obj.get("side"),
            "action": obj.get("action"),
            "count": obj.get("count"),
            "type": obj.get("type"),
            "yes_price": obj.get("yes_price"),
            "no_price": obj.get("no_price"),
            "expiration_ts": obj.get("expiration_ts"),
            "sell_position_floor": obj.get("sell_position_floor"),
            "buy_max_cost": obj.get("buy_max_cost")
        })
        return _obj


