# coding: utf-8

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Market(BaseModel):
    """
    Market
    """ # noqa: E501
    ticker: Optional[StrictStr] = None
    series_ticker: Optional[StrictStr] = Field(default=None, description="The series this market belongs to")
    event_ticker: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    subtitle: Optional[StrictStr] = None
    open_time: Optional[datetime] = None
    close_time: Optional[datetime] = None
    expiration_time: Optional[datetime] = None
    status: Optional[StrictStr] = None
    yes_bid: Optional[Union[StrictFloat, StrictInt]] = None
    yes_ask: Optional[Union[StrictFloat, StrictInt]] = None
    no_bid: Optional[Union[StrictFloat, StrictInt]] = None
    no_ask: Optional[Union[StrictFloat, StrictInt]] = None
    last_price: Optional[Union[StrictFloat, StrictInt]] = None
    volume: Optional[StrictInt] = None
    volume_24h: Optional[StrictInt] = None
    result: Optional[StrictStr] = None
    can_close_early: Optional[StrictBool] = None
    cap_count: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["ticker", "series_ticker", "event_ticker", "title", "subtitle", "open_time", "close_time", "expiration_time", "status", "yes_bid", "yes_ask", "no_bid", "no_ask", "last_price", "volume", "volume_24h", "result", "can_close_early", "cap_count"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['initialized', 'active', 'closed', 'settled', 'determined']):
            raise ValueError("must be one of enum values ('initialized', 'active', 'closed', 'settled', 'determined')")
        return value

    @field_validator('result')
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['yes', 'no', '']):
            raise ValueError("must be one of enum values ('yes', 'no', '')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Market from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if result (nullable) is None
        # and model_fields_set contains the field
        if self.result is None and "result" in self.model_fields_set:
            _dict['result'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Market from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ticker": obj.get("ticker"),
            "series_ticker": obj.get("series_ticker"),
            "event_ticker": obj.get("event_ticker"),
            "title": obj.get("title"),
            "subtitle": obj.get("subtitle"),
            "open_time": obj.get("open_time"),
            "close_time": obj.get("close_time"),
            "expiration_time": obj.get("expiration_time"),
            "status": obj.get("status"),
            "yes_bid": obj.get("yes_bid"),
            "yes_ask": obj.get("yes_ask"),
            "no_bid": obj.get("no_bid"),
            "no_ask": obj.get("no_ask"),
            "last_price": obj.get("last_price"),
            "volume": obj.get("volume"),
            "volume_24h": obj.get("volume_24h"),
            "result": obj.get("result"),
            "can_close_early": obj.get("can_close_early"),
            "cap_count": obj.get("cap_count")
        })
        return _obj


