# coding: utf-8

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Order(BaseModel):
    """
    Order
    """ # noqa: E501
    order_id: Optional[StrictStr] = None
    client_order_id: Optional[StrictStr] = None
    ticker: Optional[StrictStr] = None
    side: Optional[StrictStr] = None
    action: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    yes_price: Optional[Union[StrictFloat, StrictInt]] = None
    no_price: Optional[Union[StrictFloat, StrictInt]] = None
    count: Optional[StrictInt] = None
    remaining_count: Optional[StrictInt] = None
    expiration_time: Optional[datetime] = None
    created_time: Optional[datetime] = None
    updated_time: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["order_id", "client_order_id", "ticker", "side", "action", "type", "status", "yes_price", "no_price", "count", "remaining_count", "expiration_time", "created_time", "updated_time"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['limit', 'market']):
            raise ValueError("must be one of enum values ('limit', 'market')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['resting', 'canceled', 'executed', 'pending']):
            raise ValueError("must be one of enum values ('resting', 'canceled', 'executed', 'pending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Order from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Order from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "order_id": obj.get("order_id"),
            "client_order_id": obj.get("client_order_id"),
            "ticker": obj.get("ticker"),
            "side": obj.get("side"),
            "action": obj.get("action"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "yes_price": obj.get("yes_price"),
            "no_price": obj.get("no_price"),
            "count": obj.get("count"),
            "remaining_count": obj.get("remaining_count"),
            "expiration_time": obj.get("expiration_time"),
            "created_time": obj.get("created_time"),
            "updated_time": obj.get("updated_time")
        })
        return _obj


