# coding: utf-8

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Quote(BaseModel):
    """
    Quote
    """ # noqa: E501
    quote_id: Optional[StrictStr] = None
    rfq_id: Optional[StrictStr] = None
    quoter_id: Optional[StrictStr] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    size: Optional[StrictInt] = None
    side: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    created_ts: Optional[datetime] = None
    expires_ts: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["quote_id", "rfq_id", "quoter_id", "price", "size", "side", "status", "created_ts", "expires_ts"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Quote from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Quote from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "quote_id": obj.get("quote_id"),
            "rfq_id": obj.get("rfq_id"),
            "quoter_id": obj.get("quoter_id"),
            "price": obj.get("price"),
            "size": obj.get("size"),
            "side": obj.get("side"),
            "status": obj.get("status"),
            "created_ts": obj.get("created_ts"),
            "expires_ts": obj.get("expires_ts")
        })
        return _obj


