# coding: utf-8

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt, StrictBool
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from kalshi_python.models.get_market_candlesticks_response import GetMarketCandlesticksResponse
from kalshi_python.models.get_market_orderbook_response import GetMarketOrderbookResponse
from kalshi_python.models.get_market_response import GetMarketResponse
from kalshi_python.models.get_markets_response import GetMarketsResponse
from kalshi_python.models.get_trades_response import GetTradesResponse

from kalshi_python.api_client import ApiClient, RequestSerialized
from kalshi_python.api_response import ApiResponse
from kalshi_python.rest import RESTResponseType


class MarketsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_market(
        self,
        ticker: StrictStr,
    ) -> GetMarketResponse:
        """Get Market

        Get a single market by its ticker.  A market represents a specific binary outcome within an event that users can trade on (e.g., \&quot;Will candidate X win?\&quot;). Markets have yes/no positions, current prices, volume, and settlement rules. 

        :param ticker: Market ticker (required)
        :type ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_market_serialize(
            ticker=ticker,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_market_with_http_info(
        self,
        ticker: Annotated[StrictStr, Field(description="Market ticker")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMarketResponse]:
        """Get Market

        Get a single market by its ticker.  A market represents a specific binary outcome within an event that users can trade on (e.g., \&quot;Will candidate X win?\&quot;). Markets have yes/no positions, current prices, volume, and settlement rules. 

        :param ticker: Market ticker (required)
        :type ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_serialize(
            ticker=ticker,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_market_without_preload_content(
        self,
        ticker: Annotated[StrictStr, Field(description="Market ticker")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Market

        Get a single market by its ticker.  A market represents a specific binary outcome within an event that users can trade on (e.g., \&quot;Will candidate X win?\&quot;). Markets have yes/no positions, current prices, volume, and settlement rules. 

        :param ticker: Market ticker (required)
        :type ticker: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_serialize(
            ticker=ticker,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_market_serialize(
        self,
        ticker,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ticker is not None:
            _path_params['ticker'] = ticker
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets/{ticker}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_market_candlesticks(
        self,
        ticker: StrictStr,
        market_ticker: StrictStr,
        start_ts: Any = None,
        end_ts: Any = None,
        period_interval: Any = None,
    ) -> GetMarketCandlesticksResponse:
        """Get Market Candlesticks

        Get candlestick data for a market within a series

        :param ticker: The series ticker (required)
        :type ticker: str
        :param market_ticker: The market ticker (required)
        :type market_ticker: str
        :param start_ts: Start timestamp for the range
        :type start_ts: int
        :param end_ts: End timestamp for the range
        :type end_ts: int
        :param period_interval: Period interval for candlesticks (e.g., 1m, 5m, 1h, 1d)
        :type period_interval: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_market_candlesticks_serialize(
            ticker=ticker,
            market_ticker=market_ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketCandlesticksResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_market_candlesticks_with_http_info(
        self,
        ticker: Annotated[StrictStr, Field(description="The series ticker")],
        market_ticker: Annotated[StrictStr, Field(description="The market ticker")],
        start_ts: Annotated[Optional[StrictInt], Field(description="Start timestamp for the range")] = None,
        end_ts: Annotated[Optional[StrictInt], Field(description="End timestamp for the range")] = None,
        period_interval: Annotated[Optional[StrictStr], Field(description="Period interval for candlesticks (e.g., 1m, 5m, 1h, 1d)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMarketCandlesticksResponse]:
        """Get Market Candlesticks

        Get candlestick data for a market within a series

        :param ticker: The series ticker (required)
        :type ticker: str
        :param market_ticker: The market ticker (required)
        :type market_ticker: str
        :param start_ts: Start timestamp for the range
        :type start_ts: int
        :param end_ts: End timestamp for the range
        :type end_ts: int
        :param period_interval: Period interval for candlesticks (e.g., 1m, 5m, 1h, 1d)
        :type period_interval: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_candlesticks_serialize(
            ticker=ticker,
            market_ticker=market_ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketCandlesticksResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_market_candlesticks_without_preload_content(
        self,
        ticker: Annotated[StrictStr, Field(description="The series ticker")],
        market_ticker: Annotated[StrictStr, Field(description="The market ticker")],
        start_ts: Annotated[Optional[StrictInt], Field(description="Start timestamp for the range")] = None,
        end_ts: Annotated[Optional[StrictInt], Field(description="End timestamp for the range")] = None,
        period_interval: Annotated[Optional[StrictStr], Field(description="Period interval for candlesticks (e.g., 1m, 5m, 1h, 1d)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Market Candlesticks

        Get candlestick data for a market within a series

        :param ticker: The series ticker (required)
        :type ticker: str
        :param market_ticker: The market ticker (required)
        :type market_ticker: str
        :param start_ts: Start timestamp for the range
        :type start_ts: int
        :param end_ts: End timestamp for the range
        :type end_ts: int
        :param period_interval: Period interval for candlesticks (e.g., 1m, 5m, 1h, 1d)
        :type period_interval: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_candlesticks_serialize(
            ticker=ticker,
            market_ticker=market_ticker,
            start_ts=start_ts,
            end_ts=end_ts,
            period_interval=period_interval,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketCandlesticksResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_market_candlesticks_serialize(
        self,
        ticker,
        market_ticker,
        start_ts,
        end_ts,
        period_interval,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ticker is not None:
            _path_params['ticker'] = ticker
        if market_ticker is not None:
            _path_params['market_ticker'] = market_ticker
        # process the query parameters
        if start_ts is not None:
            
            _query_params.append(('start_ts', start_ts))
            
        if end_ts is not None:
            
            _query_params.append(('end_ts', end_ts))
            
        if period_interval is not None:
            
            _query_params.append(('period_interval', period_interval))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/series/{ticker}/markets/{market_ticker}/candlesticks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_market_orderbook(
        self,
        ticker: StrictStr,
        depth: Any = None,
    ) -> GetMarketOrderbookResponse:
        """Get Market Orderbook

        Get the orderbook for a market

        :param ticker: Market ticker (required)
        :type ticker: str
        :param depth: Depth of the orderbook to retrieve
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_market_orderbook_serialize(
            ticker=ticker,
            depth=depth,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketOrderbookResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_market_orderbook_with_http_info(
        self,
        ticker: Annotated[StrictStr, Field(description="Market ticker")],
        depth: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Depth of the orderbook to retrieve")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMarketOrderbookResponse]:
        """Get Market Orderbook

        Get the orderbook for a market

        :param ticker: Market ticker (required)
        :type ticker: str
        :param depth: Depth of the orderbook to retrieve
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_orderbook_serialize(
            ticker=ticker,
            depth=depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketOrderbookResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_market_orderbook_without_preload_content(
        self,
        ticker: Annotated[StrictStr, Field(description="Market ticker")],
        depth: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Depth of the orderbook to retrieve")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Market Orderbook

        Get the orderbook for a market

        :param ticker: Market ticker (required)
        :type ticker: str
        :param depth: Depth of the orderbook to retrieve
        :type depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_market_orderbook_serialize(
            ticker=ticker,
            depth=depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketOrderbookResponse",
            '401': "ErrorResponse",
            '404': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_market_orderbook_serialize(
        self,
        ticker,
        depth,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ticker is not None:
            _path_params['ticker'] = ticker
        # process the query parameters
        if depth is not None:
            
            _query_params.append(('depth', depth))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets/{ticker}/orderbook',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_markets(
        self,
        limit: Any = None,
        cursor: Any = None,
        event_ticker: Any = None,
        series_ticker: Any = None,
        max_close_ts: Any = None,
        min_close_ts: Any = None,
        status: Any = None,
        tickers: Any = None,
    ) -> GetMarketsResponse:
        """Get Markets

        List and discover markets on Kalshi.   A market represents a specific binary outcome within an event that users can trade on (e.g., \&quot;Will candidate X win?\&quot;). Markets have yes/no positions, current prices, volume, and settlement rules.   This endpoint returns a paginated response. Use the &#39;limit&#39; parameter to control page size (1-1000, defaults to 100). The response includes a &#39;cursor&#39; field - pass this value in the &#39;cursor&#39; parameter of your next request to get the next page. An empty cursor indicates no more pages are available. 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Filter by event ticker
        :type event_ticker: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param max_close_ts: Filter items that close before this Unix timestamp
        :type max_close_ts: int
        :param min_close_ts: Filter items that close after this Unix timestamp
        :type min_close_ts: int
        :param status: Filter by market status. Comma-separated list. Possible values are &#39;initialized&#39;, &#39;open&#39;, &#39;closed&#39;, &#39;settled&#39;, &#39;determined&#39;. Note that the API accepts &#39;open&#39; for filtering but returns &#39;active&#39; in the response. Leave empty to return markets with any status.
        :type status: str
        :param tickers: Filter by specific market tickers. Comma-separated list of market tickers to retrieve.
        :type tickers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_markets_serialize(
            limit=limit,
            cursor=cursor,
            event_ticker=event_ticker,
            series_ticker=series_ticker,
            max_close_ts=max_close_ts,
            min_close_ts=min_close_ts,
            status=status,
            tickers=tickers,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketsResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_markets_with_http_info(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 1000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        event_ticker: Annotated[Optional[StrictStr], Field(description="Filter by event ticker")] = None,
        series_ticker: Annotated[Optional[StrictStr], Field(description="Filter by series ticker")] = None,
        max_close_ts: Annotated[Optional[StrictInt], Field(description="Filter items that close before this Unix timestamp")] = None,
        min_close_ts: Annotated[Optional[StrictInt], Field(description="Filter items that close after this Unix timestamp")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by market status. Comma-separated list. Possible values are 'initialized', 'open', 'closed', 'settled', 'determined'. Note that the API accepts 'open' for filtering but returns 'active' in the response. Leave empty to return markets with any status.")] = None,
        tickers: Annotated[Optional[StrictStr], Field(description="Filter by specific market tickers. Comma-separated list of market tickers to retrieve.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMarketsResponse]:
        """Get Markets

        List and discover markets on Kalshi.   A market represents a specific binary outcome within an event that users can trade on (e.g., \&quot;Will candidate X win?\&quot;). Markets have yes/no positions, current prices, volume, and settlement rules.   This endpoint returns a paginated response. Use the &#39;limit&#39; parameter to control page size (1-1000, defaults to 100). The response includes a &#39;cursor&#39; field - pass this value in the &#39;cursor&#39; parameter of your next request to get the next page. An empty cursor indicates no more pages are available. 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Filter by event ticker
        :type event_ticker: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param max_close_ts: Filter items that close before this Unix timestamp
        :type max_close_ts: int
        :param min_close_ts: Filter items that close after this Unix timestamp
        :type min_close_ts: int
        :param status: Filter by market status. Comma-separated list. Possible values are &#39;initialized&#39;, &#39;open&#39;, &#39;closed&#39;, &#39;settled&#39;, &#39;determined&#39;. Note that the API accepts &#39;open&#39; for filtering but returns &#39;active&#39; in the response. Leave empty to return markets with any status.
        :type status: str
        :param tickers: Filter by specific market tickers. Comma-separated list of market tickers to retrieve.
        :type tickers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_markets_serialize(
            limit=limit,
            cursor=cursor,
            event_ticker=event_ticker,
            series_ticker=series_ticker,
            max_close_ts=max_close_ts,
            min_close_ts=min_close_ts,
            status=status,
            tickers=tickers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketsResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_markets_without_preload_content(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 1000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        event_ticker: Annotated[Optional[StrictStr], Field(description="Filter by event ticker")] = None,
        series_ticker: Annotated[Optional[StrictStr], Field(description="Filter by series ticker")] = None,
        max_close_ts: Annotated[Optional[StrictInt], Field(description="Filter items that close before this Unix timestamp")] = None,
        min_close_ts: Annotated[Optional[StrictInt], Field(description="Filter items that close after this Unix timestamp")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Filter by market status. Comma-separated list. Possible values are 'initialized', 'open', 'closed', 'settled', 'determined'. Note that the API accepts 'open' for filtering but returns 'active' in the response. Leave empty to return markets with any status.")] = None,
        tickers: Annotated[Optional[StrictStr], Field(description="Filter by specific market tickers. Comma-separated list of market tickers to retrieve.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Markets

        List and discover markets on Kalshi.   A market represents a specific binary outcome within an event that users can trade on (e.g., \&quot;Will candidate X win?\&quot;). Markets have yes/no positions, current prices, volume, and settlement rules.   This endpoint returns a paginated response. Use the &#39;limit&#39; parameter to control page size (1-1000, defaults to 100). The response includes a &#39;cursor&#39; field - pass this value in the &#39;cursor&#39; parameter of your next request to get the next page. An empty cursor indicates no more pages are available. 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param event_ticker: Filter by event ticker
        :type event_ticker: str
        :param series_ticker: Filter by series ticker
        :type series_ticker: str
        :param max_close_ts: Filter items that close before this Unix timestamp
        :type max_close_ts: int
        :param min_close_ts: Filter items that close after this Unix timestamp
        :type min_close_ts: int
        :param status: Filter by market status. Comma-separated list. Possible values are &#39;initialized&#39;, &#39;open&#39;, &#39;closed&#39;, &#39;settled&#39;, &#39;determined&#39;. Note that the API accepts &#39;open&#39; for filtering but returns &#39;active&#39; in the response. Leave empty to return markets with any status.
        :type status: str
        :param tickers: Filter by specific market tickers. Comma-separated list of market tickers to retrieve.
        :type tickers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_markets_serialize(
            limit=limit,
            cursor=cursor,
            event_ticker=event_ticker,
            series_ticker=series_ticker,
            max_close_ts=max_close_ts,
            min_close_ts=min_close_ts,
            status=status,
            tickers=tickers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMarketsResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_markets_serialize(
        self,
        limit,
        cursor,
        event_ticker,
        series_ticker,
        max_close_ts,
        min_close_ts,
        status,
        tickers,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if event_ticker is not None:
            
            _query_params.append(('event_ticker', event_ticker))
            
        if series_ticker is not None:
            
            _query_params.append(('series_ticker', series_ticker))
            
        if max_close_ts is not None:
            
            _query_params.append(('max_close_ts', max_close_ts))
            
        if min_close_ts is not None:
            
            _query_params.append(('min_close_ts', min_close_ts))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if tickers is not None:
            
            _query_params.append(('tickers', tickers))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_trades(
        self,
        limit: Any = None,
        cursor: Any = None,
        ticker: Any = None,
        min_ts: Any = None,
        max_ts: Any = None,
    ) -> GetTradesResponse:
        """Get Trades

        Get all trades for all markets.  A trade represents a completed transaction between two users on a specific market. Each trade includes the market ticker, price, quantity, and timestamp information.  This endpoint returns a paginated response. Use the &#39;limit&#39; parameter to control page size (1-1000, defaults to 100). The response includes a &#39;cursor&#39; field - pass this value in the &#39;cursor&#39; parameter of your next request to get the next page. An empty cursor indicates no more pages are available. 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Filter items after this Unix timestamp
        :type min_ts: int
        :param max_ts: Filter items before this Unix timestamp
        :type max_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_trades_serialize(
            limit=limit,
            cursor=cursor,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            _request_auth=None,
            _content_type=None,
            _headers=None,
            _host_index=0
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTradesResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=None,
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_trades_with_http_info(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 1000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        ticker: Annotated[Optional[StrictStr], Field(description="Filter by market ticker")] = None,
        min_ts: Annotated[Optional[StrictInt], Field(description="Filter items after this Unix timestamp")] = None,
        max_ts: Annotated[Optional[StrictInt], Field(description="Filter items before this Unix timestamp")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTradesResponse]:
        """Get Trades

        Get all trades for all markets.  A trade represents a completed transaction between two users on a specific market. Each trade includes the market ticker, price, quantity, and timestamp information.  This endpoint returns a paginated response. Use the &#39;limit&#39; parameter to control page size (1-1000, defaults to 100). The response includes a &#39;cursor&#39; field - pass this value in the &#39;cursor&#39; parameter of your next request to get the next page. An empty cursor indicates no more pages are available. 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Filter items after this Unix timestamp
        :type min_ts: int
        :param max_ts: Filter items before this Unix timestamp
        :type max_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trades_serialize(
            limit=limit,
            cursor=cursor,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTradesResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_trades_without_preload_content(
        self,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Number of results per page. Defaults to 100. Maximum value is 1000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.")] = None,
        ticker: Annotated[Optional[StrictStr], Field(description="Filter by market ticker")] = None,
        min_ts: Annotated[Optional[StrictInt], Field(description="Filter items after this Unix timestamp")] = None,
        max_ts: Annotated[Optional[StrictInt], Field(description="Filter items before this Unix timestamp")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Trades

        Get all trades for all markets.  A trade represents a completed transaction between two users on a specific market. Each trade includes the market ticker, price, quantity, and timestamp information.  This endpoint returns a paginated response. Use the &#39;limit&#39; parameter to control page size (1-1000, defaults to 100). The response includes a &#39;cursor&#39; field - pass this value in the &#39;cursor&#39; parameter of your next request to get the next page. An empty cursor indicates no more pages are available. 

        :param limit: Number of results per page. Defaults to 100. Maximum value is 1000.
        :type limit: int
        :param cursor: Pagination cursor. Use the cursor value returned from the previous response to get the next page of results. Leave empty for the first page.
        :type cursor: str
        :param ticker: Filter by market ticker
        :type ticker: str
        :param min_ts: Filter items after this Unix timestamp
        :type min_ts: int
        :param max_ts: Filter items before this Unix timestamp
        :type max_ts: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trades_serialize(
            limit=limit,
            cursor=cursor,
            ticker=ticker,
            min_ts=min_ts,
            max_ts=max_ts,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTradesResponse",
            '400': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_trades_serialize(
        self,
        limit,
        cursor,
        ticker,
        min_ts,
        max_ts,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if ticker is not None:
            
            _query_params.append(('ticker', ticker))
            
        if min_ts is not None:
            
            _query_params.append(('min_ts', min_ts))
            
        if max_ts is not None:
            
            _query_params.append(('max_ts', max_ts))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/markets/trades',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


