# coding: utf-8

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AmendOrderRequest(BaseModel):
    """
    AmendOrderRequest
    """ # noqa: E501
    yes_price: Optional[Union[Annotated[float, Field(le=99, strict=True, ge=1)], Annotated[int, Field(le=99, strict=True, ge=1)]]] = None
    no_price: Optional[Union[Annotated[float, Field(le=99, strict=True, ge=1)], Annotated[int, Field(le=99, strict=True, ge=1)]]] = None
    count: Optional[Annotated[int, Field(strict=True, ge=1)]] = None
    __properties: ClassVar[List[str]] = ["yes_price", "no_price", "count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AmendOrderRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AmendOrderRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "yes_price": obj.get("yes_price"),
            "no_price": obj.get("no_price"),
            "count": obj.get("count")
        })
        return _obj


