# coding: utf-8

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Fill(BaseModel):
    """
    Fill
    """ # noqa: E501
    fill_id: Optional[StrictStr] = None
    order_id: Optional[StrictStr] = None
    ticker: Optional[StrictStr] = None
    side: Optional[StrictStr] = None
    action: Optional[StrictStr] = None
    count: Optional[StrictInt] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    is_taker: Optional[StrictBool] = None
    created_time: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["fill_id", "order_id", "ticker", "side", "action", "count", "price", "is_taker", "created_time"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Fill from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Fill from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fill_id": obj.get("fill_id"),
            "order_id": obj.get("order_id"),
            "ticker": obj.get("ticker"),
            "side": obj.get("side"),
            "action": obj.get("action"),
            "count": obj.get("count"),
            "price": obj.get("price"),
            "is_taker": obj.get("is_taker"),
            "created_time": obj.get("created_time")
        })
        return _obj


