# coding: utf-8

"""
    Kalshi Trading API

    Complete API for the Kalshi trading platform including all handlers for SDK generation

    The version of the OpenAPI document: 2.0.0
    Contact: support@kalshi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kalshi_python.models.orderbook_level import OrderbookLevel
from typing import Optional, Set
from typing_extensions import Self

class GetMarketOrderbookResponseOrderbook(BaseModel):
    """
    GetMarketOrderbookResponseOrderbook
    """ # noqa: E501
    var_true: Optional[List[OrderbookLevel]] = Field(default=None, alias="true")
    var_false: Optional[List[OrderbookLevel]] = Field(default=None, alias="false")
    __properties: ClassVar[List[str]] = ["true", "false"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetMarketOrderbookResponseOrderbook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in var_true (list)
        _items = []
        if self.var_true:
            for _item_var_true in self.var_true:
                if _item_var_true:
                    _items.append(_item_var_true.to_dict())
            _dict['true'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in var_false (list)
        _items = []
        if self.var_false:
            for _item_var_false in self.var_false:
                if _item_var_false:
                    _items.append(_item_var_false.to_dict())
            _dict['false'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetMarketOrderbookResponseOrderbook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "true": [OrderbookLevel.from_dict(_item) for _item in obj["true"]] if obj.get("true") is not None else None,
            "false": [OrderbookLevel.from_dict(_item) for _item in obj["false"]] if obj.get("false") is not None else None
        })
        return _obj


