# generated by datamodel-codegen:
#   filename:  openapi_reference.json
#   timestamp: 2025-05-04T21:59:34+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field, RootModel


class AssetId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class BookmarkId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class ListId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class TagId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class HighlightId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class TaggingStatus(str, Enum):
    success = "success"
    failure = "failure"
    pending = "pending"


class AttachedBy(str, Enum):
    ai = "ai"
    human = "human"


class Tag(BaseModel):
    id: str
    name: str
    attachedBy: AttachedBy


class Type(str, Enum):
    link = "link"


class Content(BaseModel):
    type: Type
    url: str
    title: Optional[str] = None
    description: Optional[str] = None
    imageUrl: Optional[str] = None
    imageAssetId: Optional[str] = None
    screenshotAssetId: Optional[str] = None
    fullPageArchiveAssetId: Optional[str] = None
    precrawledArchiveAssetId: Optional[str] = None
    videoAssetId: Optional[str] = None
    favicon: Optional[str] = None
    htmlContent: Optional[str] = None
    crawledAt: Optional[str] = None
    author: Optional[str] = None
    publisher: Optional[str] = None
    datePublished: Optional[str] = None
    dateModified: Optional[str] = None


class Type1(str, Enum):
    text = "text"


class Content1(BaseModel):
    type: Type1
    text: str
    sourceUrl: Optional[str] = None


class Type2(str, Enum):
    asset = "asset"


class AssetType(str, Enum):
    image = "image"
    pdf = "pdf"


class Content2(BaseModel):
    type: Type2
    assetType: AssetType
    assetId: str
    fileName: Optional[str] = None
    sourceUrl: Optional[str] = None
    size: Optional[float] = None
    content: Optional[str] = None


class Type3(str, Enum):
    unknown = "unknown"


class Content3(BaseModel):
    type: Type3


class AssetType1(str, Enum):
    screenshot = "screenshot"
    assetScreenshot = "assetScreenshot"
    bannerImage = "bannerImage"
    fullPageArchive = "fullPageArchive"
    video = "video"
    bookmarkAsset = "bookmarkAsset"
    precrawledArchive = "precrawledArchive"
    unknown = "unknown"


class Asset(BaseModel):
    id: str
    assetType: AssetType1


class Bookmark(BaseModel):
    id: str
    createdAt: str
    modifiedAt: str
    title: Optional[str] = None
    archived: bool
    favourited: bool
    taggingStatus: TaggingStatus
    note: Optional[str] = None
    summary: Optional[str] = None
    tags: List[Tag]
    content: Union[Content, Content1, Content2, Content3]
    assets: List[Asset]


class PaginatedBookmarks(BaseModel):
    bookmarks: List[Bookmark]
    nextCursor: Optional[str] = None  # Allow nextCursor to be None


class Cursor(RootModel[str]):
    root: str


class Color(str, Enum):
    yellow = "yellow"
    red = "red"
    green = "green"
    blue = "blue"


class Highlight(BaseModel):
    bookmarkId: str
    startOffset: float
    endOffset: float
    color: Optional[Color] = "yellow"
    text: Optional[str] = None  # Allow None for text
    note: Optional[str] = None  # Allow None for note
    id: str
    userId: str
    createdAt: str


class Type4(str, Enum):
    manual = "manual"
    smart = "smart"


class ListModel(BaseModel):
    id: str
    name: str
    description: Optional[str] = None
    icon: str
    parentId: Optional[str] = None  # Allow parentId to be None (nullable)
    type: Optional[Type4] = "manual"
    query: Optional[str] = None


class NumBookmarksByAttachedType(BaseModel):
    ai: Optional[float] = None
    human: Optional[float] = None


class Tag1(BaseModel):
    id: str
    name: str
    numBookmarks: float
    numBookmarksByAttachedType: NumBookmarksByAttachedType


class PaginatedHighlights(BaseModel):
    highlights: List[Highlight]
    nextCursor: Optional[str] = None  # Allow nextCursor to be None
