# generated by datamodel-codegen:
#   filename:  openapi_reference.json
#   timestamp: 2025-05-04T21:59:34+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field, RootModel


class AssetId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class BookmarkId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class ListId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class HighlightId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class TagId(RootModel[str]):
    root: str = Field(..., example="ieidlxygmwj87oxz5hxttoc8")


class TaggingStatus(str, Enum):
    success = "success"
    failure = "failure"
    pending = "pending"


class AttachedBy(str, Enum):
    ai = "ai"
    human = "human"


class TagShort(BaseModel):
    id: str
    name: str
    attachedBy: AttachedBy


class Tag(BaseModel):
    id: str
    name: str
    numBookmarks: float
    numBookmarksByAttachedType: NumBookmarksByAttachedType


class Type(str, Enum):
    link = "link"


class Content(BaseModel):
    type: Type
    url: str
    title: Optional[str] = None
    description: Optional[str] = None
    imageUrl: Optional[str] = None
    imageAssetId: Optional[str] = None
    screenshotAssetId: Optional[str] = None
    fullPageArchiveAssetId: Optional[str] = None
    precrawledArchiveAssetId: Optional[str] = None
    videoAssetId: Optional[str] = None
    favicon: Optional[str] = None
    htmlContent: Optional[str] = None
    crawledAt: Optional[str] = None
    author: Optional[str] = None
    publisher: Optional[str] = None
    datePublished: Optional[str] = None
    dateModified: Optional[str] = None


class TypeText(str, Enum):
    text = "text"


class TypeAsset(str, Enum):
    asset = "asset"


class TypeUnknown(str, Enum):
    unknown = "unknown"


class ContentUnknown(BaseModel):
    type: TypeUnknown


class AssetTypeAssetType(str, Enum):
    image = "image"
    pdf = "pdf"


class ContentTypeText(BaseModel):
    type: TypeText
    text: str
    sourceUrl: Optional[str] = None


class ContentTypeAsset(BaseModel):
    type: TypeAsset
    assetType: AssetTypeAssetType
    assetId: str
    fileName: Optional[str] = None
    sourceUrl: Optional[str] = None
    size: Optional[float] = None
    content: Optional[str] = None


class AssetType(str, Enum):
    screenshot = "screenshot"
    assetScreenshot = "assetScreenshot"
    bannerImage = "bannerImage"
    fullPageArchive = "fullPageArchive"
    video = "video"
    bookmarkAsset = "bookmarkAsset"
    precrawledArchive = "precrawledArchive"
    unknown = "unknown"


class Asset(BaseModel):
    id: str
    assetType: AssetType


class Bookmark(BaseModel):
    id: str
    createdAt: str
    modifiedAt: Optional[str]
    title: Optional[str] = None
    archived: bool
    favourited: bool
    taggingStatus: TaggingStatus
    summarizationStatus: Optional[TaggingStatus] = None
    note: Optional[str] = None
    summary: Optional[str] = None
    tags: List[TagShort]
    content: Union[Content, ContentTypeText, ContentTypeAsset, ContentUnknown]
    assets: List[Asset]


class PaginatedBookmarks(BaseModel):
    bookmarks: List[Bookmark]
    nextCursor: Optional[str]


class Cursor(RootModel[str]):
    root: str


class Color(str, Enum):
    yellow = "yellow"
    red = "red"
    green = "green"
    blue = "blue"


class Highlight(BaseModel):
    bookmarkId: str
    startOffset: float
    endOffset: float
    color: Optional[Color] = "yellow"
    text: Optional[str]
    note: Optional[str]
    id: str
    userId: str
    createdAt: str


class ListType(str, Enum):
    manual = "manual"
    smart = "smart"


class ListModel(BaseModel):
    id: str
    name: str
    description: Optional[str] = None
    icon: str
    parentId: Optional[str]
    type: Optional[ListType] = "manual"
    query: Optional[str] = None


class NumBookmarksByAttachedType(BaseModel):
    ai: Optional[float] = None
    human: Optional[float] = None


class PaginatedHighlights(BaseModel):
    highlights: List[Highlight]
    nextCursor: Optional[str]
