"""
The datatype file was originally generated by datamodel-codegen, then refactored and manually (or via LLMs) kept up to date with upstream
"""

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union, Literal

from pydantic import BaseModel, Field, RootModel


class StatusTypes(str, Enum):
    success = "success"
    failure = "failure"
    pending = "pending"


class NumBookmarksByAttachedType(BaseModel):
    ai: Optional[int] = None
    human: Optional[int] = None


class TagShort(BaseModel):
    id: str
    name: str
    attachedBy: Literal["ai", "human"]


class Tag(BaseModel):
    id: str
    name: str
    numBookmarks: int
    numBookmarksByAttachedType: NumBookmarksByAttachedType


class Type(str, Enum):
    link = "link"


class ContentTypeLink(BaseModel):
    type: Literal["link"] = "link"
    url: str
    title: Optional[str] = None
    description: Optional[str] = None
    imageUrl: Optional[str] = None
    imageAssetId: Optional[str] = None
    screenshotAssetId: Optional[str] = None
    fullPageArchiveAssetId: Optional[str] = None
    precrawledArchiveAssetId: Optional[str] = None
    videoAssetId: Optional[str] = None
    favicon: Optional[str] = None
    htmlContent: Optional[str] = None
    contentAssetId: Optional[str] = None
    crawledAt: Optional[str] = None
    author: Optional[str] = None
    publisher: Optional[str] = None
    datePublished: Optional[str] = None
    dateModified: Optional[str] = None


class ContentTypeUnknown(BaseModel):
    type: Literal["unknown"] = "unknown"


class ContentTypeText(BaseModel):
    type: Literal["text"] = "text"
    text: str
    sourceUrl: Optional[str] = None


class ContentTypeAsset(BaseModel):
    type: Literal["asset"] = "asset"
    assetType: Literal["image", "pdf"]
    assetId: str
    fileName: Optional[str] = None
    sourceUrl: Optional[str] = None
    size: Optional[float] = None
    content: Optional[str] = None


class BookmarkAsset(BaseModel):
    id: str
    assetType: Literal[
        "linkHtmlContent",
        "screenshot",
        "assetScreenshot",
        "bannerImage",
        "fullPageArchive",
        "video",
        "bookmarkAsset",
        "precrawledArchive",
        "userUploaded",
        "unknown",
    ]
    fileName: Optional[str] = None


class Asset(BaseModel):
    assetId: str
    contentType: str
    size: float
    fileName: str


class Bookmark(BaseModel):
    id: str
    createdAt: str
    modifiedAt: Optional[str]
    title: Optional[str] = None
    archived: bool
    favourited: bool
    taggingStatus: Literal["success", "failure", "pending"]
    summarizationStatus: Optional[Literal["success", "failure", "pending"]] = None
    note: Optional[str] = None
    summary: Optional[str] = None
    source: Optional[
        Literal[
            "api", "web", "cli", "mobile", "extension", "singlefile", "rss", "import"
        ]
    ] = None
    userId: str
    tags: List[TagShort]
    content: Union[
        ContentTypeLink, ContentTypeText, ContentTypeAsset, ContentTypeUnknown
    ]
    assets: List[BookmarkAsset]


class PaginatedBookmarks(BaseModel):
    bookmarks: List[Bookmark]
    nextCursor: Optional[str] = ""


class ListModel(BaseModel):
    id: str
    name: str
    description: Optional[str] = None
    icon: str
    parentId: Optional[str]
    type: Optional[Literal["manual", "smart"]] = "manual"
    query: Optional[str] = None
    public: bool
    hasCollaborators: bool
    userRole: Literal["owner", "editor", "viewer", "public"]


class Highlight(BaseModel):
    bookmarkId: str
    startOffset: float
    endOffset: float
    color: Optional[Literal["yellow", "red", "green", "blue"]] = "yellow"
    text: Optional[str]
    note: Optional[str]
    id: str
    userId: str
    createdAt: str


class PaginatedHighlights(BaseModel):
    highlights: List[Highlight]
    nextCursor: Optional[str] = ""


class PaginatedTags(BaseModel):
    tags: List[Tag]
    nextCursor: Optional[str] = ""


class Backup(BaseModel):
    id: str
    userId: str
    assetId: Optional[str]
    createdAt: str
    size: float
    bookmarkCount: int
    status: Literal["pending", "success", "failure"]
    errorMessage: Optional[str] = None
