# kdp-api-python-client
The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0
- Package version: 0.16.5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import kdp_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import kdp_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import kdp_api
from pprint import pprint
from kdp_api.api import ingest_api
from kdp_api.model.ingest_request import IngestRequest
# Defining the host is optional and defaults to https://api.koverse.dev
# See configuration.py for a list of all supported configuration parameters.
configuration = kdp_api.Configuration(
    host = "https://api.koverse.dev"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): Bearer
configuration = kdp_api.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with kdp_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ingest_api.IngestApi(api_client)
    ingest_request = IngestRequest(
        workspace_id="workspace_id_example",
        dataset_id="dataset_id_example",
        data_source_params=DataSourceParams(
            type="URL",
            connection_info={
                "key": {},
            },
            security_label_info={
                "key": {},
            },
            security_labeled=True,
        ),
        security_labeled=True,
        security_label_info={
            "key": {},
        },
    ) # IngestRequest | 
is_async = False # bool |  (optional) (default to False)

    try:
        # Create an Ingest Job
        api_response = api_instance.create_ingest_job(ingest_request, is_async=is_async)
        pprint(api_response)
    except kdp_api.ApiException as e:
        print("Exception when calling IngestApi->create_ingest_job: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.koverse.dev*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*IngestApi* | [**create_ingest_job**](docs/IngestApi.md#create_ingest_job) | **POST** /ingest | Create an Ingest Job
*QueryApi* | [**lucene_query**](docs/QueryApi.md#lucene_query) | **POST** /query/lucene | Query a dataset but run it through the LuceneParser first
*QueryApi* | [**query**](docs/QueryApi.md#query) | **POST** /query | Query a dataset
*ReadApi* | [**get_splits**](docs/ReadApi.md#get_splits) | **GET** /splits/{datasetId} | Get split points
*ReadApi* | [**read**](docs/ReadApi.md#read) | **POST** /read | Read records
*ReadApi* | [**read_in_sequence**](docs/ReadApi.md#read_in_sequence) | **POST** /readInSequence | Read all records for dataset
*WriteApi* | [**write**](docs/WriteApi.md#write) | **POST** /write/{datasetId} | Write records
*AbacLabelParsersApi* | [**abac_label_parsers_get**](docs/AbacLabelParsersApi.md#abac_label_parsers_get) | **GET** /abac-label-parsers | 
*AbacLabelParsersApi* | [**abac_label_parsers_id_get**](docs/AbacLabelParsersApi.md#abac_label_parsers_id_get) | **GET** /abac-label-parsers/{id} | 
*ApplicationsApi* | [**applications_get**](docs/ApplicationsApi.md#applications_get) | **GET** /applications | 
*ApplicationsApi* | [**applications_id_delete**](docs/ApplicationsApi.md#applications_id_delete) | **DELETE** /applications/{id} | 
*ApplicationsApi* | [**applications_id_get**](docs/ApplicationsApi.md#applications_id_get) | **GET** /applications/{id} | 
*ApplicationsApi* | [**applications_id_patch**](docs/ApplicationsApi.md#applications_id_patch) | **PATCH** /applications/{id} | 
*ApplicationsApi* | [**applications_id_put**](docs/ApplicationsApi.md#applications_id_put) | **PUT** /applications/{id} | 
*ApplicationsApi* | [**applications_post**](docs/ApplicationsApi.md#applications_post) | **POST** /applications | 
*AttributeAssignmentsApi* | [**attribute_assignments_get**](docs/AttributeAssignmentsApi.md#attribute_assignments_get) | **GET** /attribute-assignments | 
*AttributeAssignmentsApi* | [**attribute_assignments_id_delete**](docs/AttributeAssignmentsApi.md#attribute_assignments_id_delete) | **DELETE** /attribute-assignments/{id} | 
*AttributeAssignmentsApi* | [**attribute_assignments_id_get**](docs/AttributeAssignmentsApi.md#attribute_assignments_id_get) | **GET** /attribute-assignments/{id} | 
*AttributeAssignmentsApi* | [**attribute_assignments_id_patch**](docs/AttributeAssignmentsApi.md#attribute_assignments_id_patch) | **PATCH** /attribute-assignments/{id} | 
*AttributeAssignmentsApi* | [**attribute_assignments_id_put**](docs/AttributeAssignmentsApi.md#attribute_assignments_id_put) | **PUT** /attribute-assignments/{id} | 
*AttributeAssignmentsApi* | [**attribute_assignments_post**](docs/AttributeAssignmentsApi.md#attribute_assignments_post) | **POST** /attribute-assignments | 
*AttributesApi* | [**attributes_get**](docs/AttributesApi.md#attributes_get) | **GET** /attributes | 
*AttributesApi* | [**attributes_id_delete**](docs/AttributesApi.md#attributes_id_delete) | **DELETE** /attributes/{id} | 
*AttributesApi* | [**attributes_id_get**](docs/AttributesApi.md#attributes_id_get) | **GET** /attributes/{id} | 
*AttributesApi* | [**attributes_id_patch**](docs/AttributesApi.md#attributes_id_patch) | **PATCH** /attributes/{id} | 
*AttributesApi* | [**attributes_id_put**](docs/AttributesApi.md#attributes_id_put) | **PUT** /attributes/{id} | 
*AttributesApi* | [**attributes_post**](docs/AttributesApi.md#attributes_post) | **POST** /attributes | 
*AuthenticationApi* | [**authentication_id_delete**](docs/AuthenticationApi.md#authentication_id_delete) | **DELETE** /authentication/{id} | 
*AuthenticationApi* | [**authentication_post**](docs/AuthenticationApi.md#authentication_post) | **POST** /authentication | 
*DailyUsageApi* | [**daily_usage_get**](docs/DailyUsageApi.md#daily_usage_get) | **GET** /daily-usage | 
*DailyUsageApi* | [**daily_usage_id_delete**](docs/DailyUsageApi.md#daily_usage_id_delete) | **DELETE** /daily-usage/{id} | 
*DailyUsageApi* | [**daily_usage_id_get**](docs/DailyUsageApi.md#daily_usage_id_get) | **GET** /daily-usage/{id} | 
*DailyUsageApi* | [**daily_usage_id_patch**](docs/DailyUsageApi.md#daily_usage_id_patch) | **PATCH** /daily-usage/{id} | 
*DailyUsageApi* | [**daily_usage_id_put**](docs/DailyUsageApi.md#daily_usage_id_put) | **PUT** /daily-usage/{id} | 
*DailyUsageApi* | [**daily_usage_post**](docs/DailyUsageApi.md#daily_usage_post) | **POST** /daily-usage | 
*DatasetPermissionsApi* | [**dataset_permissions_get**](docs/DatasetPermissionsApi.md#dataset_permissions_get) | **GET** /dataset-permissions | 
*DatasetPermissionsApi* | [**dataset_permissions_id_delete**](docs/DatasetPermissionsApi.md#dataset_permissions_id_delete) | **DELETE** /dataset-permissions/{id} | 
*DatasetPermissionsApi* | [**dataset_permissions_id_get**](docs/DatasetPermissionsApi.md#dataset_permissions_id_get) | **GET** /dataset-permissions/{id} | 
*DatasetPermissionsApi* | [**dataset_permissions_id_patch**](docs/DatasetPermissionsApi.md#dataset_permissions_id_patch) | **PATCH** /dataset-permissions/{id} | 
*DatasetPermissionsApi* | [**dataset_permissions_id_put**](docs/DatasetPermissionsApi.md#dataset_permissions_id_put) | **PUT** /dataset-permissions/{id} | 
*DatasetPermissionsApi* | [**dataset_permissions_post**](docs/DatasetPermissionsApi.md#dataset_permissions_post) | **POST** /dataset-permissions | 
*DatasetsApi* | [**datasets_get**](docs/DatasetsApi.md#datasets_get) | **GET** /datasets | 
*DatasetsApi* | [**datasets_id_delete**](docs/DatasetsApi.md#datasets_id_delete) | **DELETE** /datasets/{id} | 
*DatasetsApi* | [**datasets_id_get**](docs/DatasetsApi.md#datasets_id_get) | **GET** /datasets/{id} | 
*DatasetsApi* | [**datasets_id_patch**](docs/DatasetsApi.md#datasets_id_patch) | **PATCH** /datasets/{id} | 
*DatasetsApi* | [**datasets_id_put**](docs/DatasetsApi.md#datasets_id_put) | **PUT** /datasets/{id} | 
*DatasetsApi* | [**datasets_post**](docs/DatasetsApi.md#datasets_post) | **POST** /datasets | 
*GroupMembershipsApi* | [**group_memberships_get**](docs/GroupMembershipsApi.md#group_memberships_get) | **GET** /group-memberships | 
*GroupMembershipsApi* | [**group_memberships_id_delete**](docs/GroupMembershipsApi.md#group_memberships_id_delete) | **DELETE** /group-memberships/{id} | 
*GroupMembershipsApi* | [**group_memberships_id_get**](docs/GroupMembershipsApi.md#group_memberships_id_get) | **GET** /group-memberships/{id} | 
*GroupMembershipsApi* | [**group_memberships_id_patch**](docs/GroupMembershipsApi.md#group_memberships_id_patch) | **PATCH** /group-memberships/{id} | 
*GroupMembershipsApi* | [**group_memberships_id_put**](docs/GroupMembershipsApi.md#group_memberships_id_put) | **PUT** /group-memberships/{id} | 
*GroupMembershipsApi* | [**group_memberships_post**](docs/GroupMembershipsApi.md#group_memberships_post) | **POST** /group-memberships | 
*GroupsApi* | [**groups_get**](docs/GroupsApi.md#groups_get) | **GET** /groups | 
*GroupsApi* | [**groups_id_delete**](docs/GroupsApi.md#groups_id_delete) | **DELETE** /groups/{id} | 
*GroupsApi* | [**groups_id_get**](docs/GroupsApi.md#groups_id_get) | **GET** /groups/{id} | 
*GroupsApi* | [**groups_id_patch**](docs/GroupsApi.md#groups_id_patch) | **PATCH** /groups/{id} | 
*GroupsApi* | [**groups_id_put**](docs/GroupsApi.md#groups_id_put) | **PUT** /groups/{id} | 
*GroupsApi* | [**groups_post**](docs/GroupsApi.md#groups_post) | **POST** /groups | 
*IndexesApi* | [**indexes_get**](docs/IndexesApi.md#indexes_get) | **GET** /indexes | 
*IndexesApi* | [**indexes_id_delete**](docs/IndexesApi.md#indexes_id_delete) | **DELETE** /indexes/{id} | 
*IndexesApi* | [**indexes_id_get**](docs/IndexesApi.md#indexes_id_get) | **GET** /indexes/{id} | 
*IndexesApi* | [**indexes_id_patch**](docs/IndexesApi.md#indexes_id_patch) | **PATCH** /indexes/{id} | 
*IndexesApi* | [**indexes_id_put**](docs/IndexesApi.md#indexes_id_put) | **PUT** /indexes/{id} | 
*IndexesApi* | [**indexes_post**](docs/IndexesApi.md#indexes_post) | **POST** /indexes | 
*JobsApi* | [**jobs_get**](docs/JobsApi.md#jobs_get) | **GET** /jobs | 
*JobsApi* | [**jobs_id_delete**](docs/JobsApi.md#jobs_id_delete) | **DELETE** /jobs/{id} | 
*JobsApi* | [**jobs_id_get**](docs/JobsApi.md#jobs_id_get) | **GET** /jobs/{id} | 
*JobsApi* | [**jobs_id_patch**](docs/JobsApi.md#jobs_id_patch) | **PATCH** /jobs/{id} | 
*JobsApi* | [**jobs_id_put**](docs/JobsApi.md#jobs_id_put) | **PUT** /jobs/{id} | 
*JobsApi* | [**jobs_post**](docs/JobsApi.md#jobs_post) | **POST** /jobs | 
*ReportedUsageApi* | [**reported_usage_get**](docs/ReportedUsageApi.md#reported_usage_get) | **GET** /reported-usage | 
*ReportedUsageApi* | [**reported_usage_id_delete**](docs/ReportedUsageApi.md#reported_usage_id_delete) | **DELETE** /reported-usage/{id} | 
*ReportedUsageApi* | [**reported_usage_id_get**](docs/ReportedUsageApi.md#reported_usage_id_get) | **GET** /reported-usage/{id} | 
*ReportedUsageApi* | [**reported_usage_id_patch**](docs/ReportedUsageApi.md#reported_usage_id_patch) | **PATCH** /reported-usage/{id} | 
*ReportedUsageApi* | [**reported_usage_id_put**](docs/ReportedUsageApi.md#reported_usage_id_put) | **PUT** /reported-usage/{id} | 
*ReportedUsageApi* | [**reported_usage_post**](docs/ReportedUsageApi.md#reported_usage_post) | **POST** /reported-usage | 
*SegmentsApi* | [**segments_get**](docs/SegmentsApi.md#segments_get) | **GET** /segments | 
*SegmentsApi* | [**segments_id_delete**](docs/SegmentsApi.md#segments_id_delete) | **DELETE** /segments/{id} | 
*SegmentsApi* | [**segments_id_get**](docs/SegmentsApi.md#segments_id_get) | **GET** /segments/{id} | 
*SegmentsApi* | [**segments_id_patch**](docs/SegmentsApi.md#segments_id_patch) | **PATCH** /segments/{id} | 
*SegmentsApi* | [**segments_id_put**](docs/SegmentsApi.md#segments_id_put) | **PUT** /segments/{id} | 
*SegmentsApi* | [**segments_post**](docs/SegmentsApi.md#segments_post) | **POST** /segments | 
*SourceTypesApi* | [**source_types_get**](docs/SourceTypesApi.md#source_types_get) | **GET** /source-types | 
*SourceTypesApi* | [**source_types_id_get**](docs/SourceTypesApi.md#source_types_id_get) | **GET** /source-types/{id} | 
*UsageApi* | [**usage_get**](docs/UsageApi.md#usage_get) | **GET** /usage | 
*UsageApi* | [**usage_id_delete**](docs/UsageApi.md#usage_id_delete) | **DELETE** /usage/{id} | 
*UsageApi* | [**usage_id_get**](docs/UsageApi.md#usage_id_get) | **GET** /usage/{id} | 
*UsageApi* | [**usage_id_patch**](docs/UsageApi.md#usage_id_patch) | **PATCH** /usage/{id} | 
*UsageApi* | [**usage_id_put**](docs/UsageApi.md#usage_id_put) | **PUT** /usage/{id} | 
*UsageApi* | [**usage_post**](docs/UsageApi.md#usage_post) | **POST** /usage | 
*UsersApi* | [**users_get**](docs/UsersApi.md#users_get) | **GET** /users | 
*UsersApi* | [**users_id_delete**](docs/UsersApi.md#users_id_delete) | **DELETE** /users/{id} | 
*UsersApi* | [**users_id_get**](docs/UsersApi.md#users_id_get) | **GET** /users/{id} | 
*UsersApi* | [**users_id_patch**](docs/UsersApi.md#users_id_patch) | **PATCH** /users/{id} | 
*UsersApi* | [**users_id_put**](docs/UsersApi.md#users_id_put) | **PUT** /users/{id} | 
*UsersApi* | [**users_post**](docs/UsersApi.md#users_post) | **POST** /users | 
*WorkspaceInvitationsApi* | [**workspace_invitations_get**](docs/WorkspaceInvitationsApi.md#workspace_invitations_get) | **GET** /workspace-invitations | 
*WorkspaceInvitationsApi* | [**workspace_invitations_id_delete**](docs/WorkspaceInvitationsApi.md#workspace_invitations_id_delete) | **DELETE** /workspace-invitations/{id} | 
*WorkspaceInvitationsApi* | [**workspace_invitations_id_get**](docs/WorkspaceInvitationsApi.md#workspace_invitations_id_get) | **GET** /workspace-invitations/{id} | 
*WorkspaceInvitationsApi* | [**workspace_invitations_id_patch**](docs/WorkspaceInvitationsApi.md#workspace_invitations_id_patch) | **PATCH** /workspace-invitations/{id} | 
*WorkspaceInvitationsApi* | [**workspace_invitations_id_put**](docs/WorkspaceInvitationsApi.md#workspace_invitations_id_put) | **PUT** /workspace-invitations/{id} | 
*WorkspaceInvitationsApi* | [**workspace_invitations_post**](docs/WorkspaceInvitationsApi.md#workspace_invitations_post) | **POST** /workspace-invitations | 
*WorkspaceManagementApi* | [**workspace_management_post**](docs/WorkspaceManagementApi.md#workspace_management_post) | **POST** /workspace-management | 
*WorkspacesApi* | [**workspaces_get**](docs/WorkspacesApi.md#workspaces_get) | **GET** /workspaces | 
*WorkspacesApi* | [**workspaces_id_delete**](docs/WorkspacesApi.md#workspaces_id_delete) | **DELETE** /workspaces/{id} | 
*WorkspacesApi* | [**workspaces_id_get**](docs/WorkspacesApi.md#workspaces_id_get) | **GET** /workspaces/{id} | 
*WorkspacesApi* | [**workspaces_id_patch**](docs/WorkspacesApi.md#workspaces_id_patch) | **PATCH** /workspaces/{id} | 
*WorkspacesApi* | [**workspaces_id_put**](docs/WorkspacesApi.md#workspaces_id_put) | **PUT** /workspaces/{id} | 
*WorkspacesApi* | [**workspaces_post**](docs/WorkspacesApi.md#workspaces_post) | **POST** /workspaces | 


## Documentation For Models

 - [AbacLabelParserPaginator](docs/AbacLabelParserPaginator.md)
 - [AbacLabelParsers](docs/AbacLabelParsers.md)
 - [AbacLabelParsersList](docs/AbacLabelParsersList.md)
 - [Application](docs/Application.md)
 - [Application1](docs/Application1.md)
 - [Application2](docs/Application2.md)
 - [Application3](docs/Application3.md)
 - [ApplicationList](docs/ApplicationList.md)
 - [ApplicationPaginator](docs/ApplicationPaginator.md)
 - [ApplicationsRequiredDatasetAccess](docs/ApplicationsRequiredDatasetAccess.md)
 - [Attribute](docs/Attribute.md)
 - [Attribute1](docs/Attribute1.md)
 - [Attribute2](docs/Attribute2.md)
 - [Attribute3](docs/Attribute3.md)
 - [AttributeAssignment](docs/AttributeAssignment.md)
 - [AttributeAssignment1](docs/AttributeAssignment1.md)
 - [AttributeAssignment2](docs/AttributeAssignment2.md)
 - [AttributeAssignmentList](docs/AttributeAssignmentList.md)
 - [AttributeAssignmentPaginator](docs/AttributeAssignmentPaginator.md)
 - [AttributeList](docs/AttributeList.md)
 - [AttributePaginator](docs/AttributePaginator.md)
 - [Authentication](docs/Authentication.md)
 - [AuthenticationDetails](docs/AuthenticationDetails.md)
 - [AuthenticationDetailsAuthentication](docs/AuthenticationDetailsAuthentication.md)
 - [AuthenticationDetailsAuthenticationPayload](docs/AuthenticationDetailsAuthenticationPayload.md)
 - [AuthenticationDetailsUser](docs/AuthenticationDetailsUser.md)
 - [AuthenticationList](docs/AuthenticationList.md)
 - [CreateDataset](docs/CreateDataset.md)
 - [DailyUsage](docs/DailyUsage.md)
 - [DailyUsageList](docs/DailyUsageList.md)
 - [DailyUsagePaginator](docs/DailyUsagePaginator.md)
 - [DataSourceParams](docs/DataSourceParams.md)
 - [Dataset](docs/Dataset.md)
 - [DatasetCurrentUserPermissions](docs/DatasetCurrentUserPermissions.md)
 - [DatasetList](docs/DatasetList.md)
 - [DatasetPaginator](docs/DatasetPaginator.md)
 - [DatasetPermission](docs/DatasetPermission.md)
 - [DatasetPermission1](docs/DatasetPermission1.md)
 - [DatasetPermission2](docs/DatasetPermission2.md)
 - [DatasetPermissionList](docs/DatasetPermissionList.md)
 - [DatasetPermissionPaginator](docs/DatasetPermissionPaginator.md)
 - [Group](docs/Group.md)
 - [Group1](docs/Group1.md)
 - [Group2](docs/Group2.md)
 - [Group3](docs/Group3.md)
 - [GroupList](docs/GroupList.md)
 - [GroupMembership](docs/GroupMembership.md)
 - [GroupMembership1](docs/GroupMembership1.md)
 - [GroupMembership2](docs/GroupMembership2.md)
 - [GroupMembershipList](docs/GroupMembershipList.md)
 - [GroupMembershipPaginator](docs/GroupMembershipPaginator.md)
 - [GroupPaginator](docs/GroupPaginator.md)
 - [Index](docs/Index.md)
 - [IndexList](docs/IndexList.md)
 - [IndexPaginator](docs/IndexPaginator.md)
 - [IngestRequest](docs/IngestRequest.md)
 - [Job](docs/Job.md)
 - [JobList](docs/JobList.md)
 - [JobPaginator](docs/JobPaginator.md)
 - [JsonRecord](docs/JsonRecord.md)
 - [PatchDataset](docs/PatchDataset.md)
 - [Query](docs/Query.md)
 - [ReadRangeRequest](docs/ReadRangeRequest.md)
 - [RecordBatch](docs/RecordBatch.md)
 - [ReportedUsage](docs/ReportedUsage.md)
 - [ReportedUsageList](docs/ReportedUsageList.md)
 - [ReportedUsagePaginator](docs/ReportedUsagePaginator.md)
 - [Segment](docs/Segment.md)
 - [SegmentList](docs/SegmentList.md)
 - [SegmentPaginator](docs/SegmentPaginator.md)
 - [SequenceReadRequest](docs/SequenceReadRequest.md)
 - [SourceTypes](docs/SourceTypes.md)
 - [SourceTypesList](docs/SourceTypesList.md)
 - [SplitPoints](docs/SplitPoints.md)
 - [StripeLatestCharge](docs/StripeLatestCharge.md)
 - [UpdateDataset](docs/UpdateDataset.md)
 - [Usage](docs/Usage.md)
 - [UsageList](docs/UsageList.md)
 - [UsagePaginator](docs/UsagePaginator.md)
 - [User](docs/User.md)
 - [UserList](docs/UserList.md)
 - [UserPaginator](docs/UserPaginator.md)
 - [Workspace](docs/Workspace.md)
 - [Workspace1](docs/Workspace1.md)
 - [Workspace2](docs/Workspace2.md)
 - [Workspace3](docs/Workspace3.md)
 - [WorkspaceInvitation](docs/WorkspaceInvitation.md)
 - [WorkspaceInvitationList](docs/WorkspaceInvitationList.md)
 - [WorkspaceInvitationPaginator](docs/WorkspaceInvitationPaginator.md)
 - [WorkspaceList](docs/WorkspaceList.md)
 - [WorkspaceManagement](docs/WorkspaceManagement.md)
 - [WorkspaceManagementList](docs/WorkspaceManagementList.md)
 - [WorkspaceManagementReassign](docs/WorkspaceManagementReassign.md)
 - [WorkspacePaginator](docs/WorkspacePaginator.md)
 - [WorkspacesSubscription](docs/WorkspacesSubscription.md)
 - [WorkspacesSubscriptionSubscriptionItemIds](docs/WorkspacesSubscriptionSubscriptionItemIds.md)
 - [WriteBatchResponse](docs/WriteBatchResponse.md)


## Documentation For Authorization


## Bearer

- **Type**: Bearer authentication (JWT)


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in kdp_api.apis and kdp_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from kdp_api.api.default_api import DefaultApi`
- `from kdp_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import kdp_api
from kdp_api.apis import *
from kdp_api.models import *
```

