# kdp-api-python-client
The KDP API is a REST API that can be used to create, access, and update data in KDP Workspaces. Please note that the Python client library follows Python's naming convention of snake casing for fields, even though they may appear in camel case in the API specification. <p><b>By default this api documentation targets the koverse production server at 'api.app.koverse.com' You can provide the hostname of your koverse instance to this documentation page via the 'host' query param.</p> <p><b>For example providing host - https://documentation.koverse.com/api?host=api.myHost.com, will update requests to target the provided host.</b></p> <p><b>Authentication request example with provided host - https://api.myHost.com/authentication</b></p>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 4.100.0
- Package version: 4.100.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import kdp_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import kdp_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import kdp_api
from pprint import pprint
from kdp_api.api import abac_label_parsers_api
from kdp_api.model.abac_label_parser_paginator import AbacLabelParserPaginator
from kdp_api.model.abac_label_parsers import AbacLabelParsers
from kdp_api.model.api_error import ApiError
# Defining the host is optional and defaults to https://api.app.koverse.com
# See configuration.py for a list of all supported configuration parameters.
configuration = kdp_api.Configuration(
    host = "https://api.app.koverse.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): Bearer
configuration = kdp_api.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with kdp_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = abac_label_parsers_api.AbacLabelParsersApi(api_client)
    limit = 1 # int | Number of results to return (optional)
    skip = 1 # int | Number of results to skip (optional)
    sort = {} # {str: (bool, date, datetime, dict, float, int, list, str, none_type)} | Property to sort results (optional)
    filter = {} # {str: (bool, date, datetime, dict, float, int, list, str, none_type)} | Query parameters to filter (optional)

    try:
        # Retrieves a list of Abac Label Parsers
        api_response = api_instance.get_abac_label_parsers(limit=limit, skip=skip, sort=sort, filter=filter)
        pprint(api_response)
    except kdp_api.ApiException as e:
        print("Exception when calling AbacLabelParsersApi->get_abac_label_parsers: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.app.koverse.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AbacLabelParsersApi* | [**get_abac_label_parsers**](docs/AbacLabelParsersApi.md#get_abac_label_parsers) | **GET** /abac-label-parsers | Retrieves a list of Abac Label Parsers
*AbacLabelParsersApi* | [**get_abac_label_parsers_id**](docs/AbacLabelParsersApi.md#get_abac_label_parsers_id) | **GET** /abac-label-parsers/{id} | Retrieves Abac Label Parser with the given ID
*ApplicationsApi* | [**delete_applications_id**](docs/ApplicationsApi.md#delete_applications_id) | **DELETE** /applications/{id} | Removes Application with the given ID
*ApplicationsApi* | [**get_applications**](docs/ApplicationsApi.md#get_applications) | **GET** /applications | Retrieves a list of Applications
*ApplicationsApi* | [**get_applications_id**](docs/ApplicationsApi.md#get_applications_id) | **GET** /applications/{id} | Retrieves Application with the given ID
*ApplicationsApi* | [**patch_applications_id**](docs/ApplicationsApi.md#patch_applications_id) | **PATCH** /applications/{id} | Updates provided fields of Application with the given ID
*ApplicationsApi* | [**post_applications**](docs/ApplicationsApi.md#post_applications) | **POST** /applications | Create a new Application
*ApplicationsApi* | [**put_applications_id**](docs/ApplicationsApi.md#put_applications_id) | **PUT** /applications/{id} | Updates Application with the given ID
*AttributeAssignmentsApi* | [**delete_attribute_assignments_id**](docs/AttributeAssignmentsApi.md#delete_attribute_assignments_id) | **DELETE** /attribute-assignments/{id} | Remove Attribute Assignment with given ID
*AttributeAssignmentsApi* | [**get_attribute_assignments**](docs/AttributeAssignmentsApi.md#get_attribute_assignments) | **GET** /attribute-assignments | Retrieve a list of Attribute Assignments
*AttributeAssignmentsApi* | [**get_attribute_assignments_id**](docs/AttributeAssignmentsApi.md#get_attribute_assignments_id) | **GET** /attribute-assignments/{id} | Retrieve Attribute Assignment with the given ID
*AttributeAssignmentsApi* | [**patch_attribute_assignments_id**](docs/AttributeAssignmentsApi.md#patch_attribute_assignments_id) | **PATCH** /attribute-assignments/{id} | Update provided fields of Attribute Assignment by given ID
*AttributeAssignmentsApi* | [**post_attribute_assignments**](docs/AttributeAssignmentsApi.md#post_attribute_assignments) | **POST** /attribute-assignments | Create a new Attribute Assignment
*AttributeAssignmentsApi* | [**put_attribute_assignments_id**](docs/AttributeAssignmentsApi.md#put_attribute_assignments_id) | **PUT** /attribute-assignments/{id} | Update an Attribute Assignment by given ID
*AttributesApi* | [**delete_attributes_id**](docs/AttributesApi.md#delete_attributes_id) | **DELETE** /attributes/{id} | Remove Attribute with the given ID
*AttributesApi* | [**get_attributes**](docs/AttributesApi.md#get_attributes) | **GET** /attributes | Retrieves a list of Attributes
*AttributesApi* | [**get_attributes_id**](docs/AttributesApi.md#get_attributes_id) | **GET** /attributes/{id} | Retrieve Attribute with the given ID
*AttributesApi* | [**patch_attributes_id**](docs/AttributesApi.md#patch_attributes_id) | **PATCH** /attributes/{id} | Update provided fields of Attribute with the given ID
*AttributesApi* | [**post_attributes**](docs/AttributesApi.md#post_attributes) | **POST** /attributes | Creates a new Attribute
*AttributesApi* | [**put_attributes_id**](docs/AttributesApi.md#put_attributes_id) | **PUT** /attributes/{id} | Update Attribute with the given ID
*AuditLogApi* | [**post_audit_log_query**](docs/AuditLogApi.md#post_audit_log_query) | **POST** /audit-log/query | Queries audit log datasets
*AuditLogConfigsApi* | [**get_all_auditlog_configurations**](docs/AuditLogConfigsApi.md#get_all_auditlog_configurations) | **GET** /audit-log-configs/ | Get audit log configuration
*AuditLogConfigsApi* | [**patch_auditlog_configuration**](docs/AuditLogConfigsApi.md#patch_auditlog_configuration) | **PATCH** /audit-log-configs/{auditLogConfigsId} | Patch audit log configuration of a workspace
*AuthenticationApi* | [**delete_authentication_id**](docs/AuthenticationApi.md#delete_authentication_id) | **DELETE** /authentication/{id} | Remove authentication with accessToken
*AuthenticationApi* | [**post_authentication**](docs/AuthenticationApi.md#post_authentication) | **POST** /authentication | Creates a new Koverse Authentication Token
*AuthenticationApi* | [**post_authentication_sso**](docs/AuthenticationApi.md#post_authentication_sso) | **POST** /authentication?workspaceId&#x3D;{workspaceId} | Creates a new Koverse Authentication Token for Single Sign-On (SSO) users
*ColumnSecurityApi* | [**get_schema**](docs/ColumnSecurityApi.md#get_schema) | **GET** /query/schema/{datasetId} | Get the schema for the given dataset id
*ColumnSecurityApi* | [**patch_column_security**](docs/ColumnSecurityApi.md#patch_column_security) | **PATCH** /write/schema/{datasetId} | Modify schema by adding new column security configuration
*DatasetPermissionsApi* | [**delete_dataset_permissions_id**](docs/DatasetPermissionsApi.md#delete_dataset_permissions_id) | **DELETE** /dataset-permissions/{id} | Remove Dataset Permission with given ID
*DatasetPermissionsApi* | [**get_dataset_permissions**](docs/DatasetPermissionsApi.md#get_dataset_permissions) | **GET** /dataset-permissions | Retrieve list of dataset permissions
*DatasetPermissionsApi* | [**get_dataset_permissions_id**](docs/DatasetPermissionsApi.md#get_dataset_permissions_id) | **GET** /dataset-permissions/{id} | Retrieve a Dataset Permission with the given ID
*DatasetPermissionsApi* | [**patch_dataset_permissions_id**](docs/DatasetPermissionsApi.md#patch_dataset_permissions_id) | **PATCH** /dataset-permissions/{id} | Update provided fields of Dataset Permission with given ID
*DatasetPermissionsApi* | [**post_dataset_permissions**](docs/DatasetPermissionsApi.md#post_dataset_permissions) | **POST** /dataset-permissions | Create a new Dataset Permission
*DatasetPermissionsApi* | [**put_dataset_permissions_id**](docs/DatasetPermissionsApi.md#put_dataset_permissions_id) | **PUT** /dataset-permissions/{id} | Update Dataset Permission with the given ID
*DatasetSyncsApi* | [**get_dataset_syncs**](docs/DatasetSyncsApi.md#get_dataset_syncs) | **GET** /dataset-syncs | Retrieve a list of Dataset Syncs
*DatasetSyncsApi* | [**get_dataset_syncs_id**](docs/DatasetSyncsApi.md#get_dataset_syncs_id) | **GET** /dataset-syncs/{id} | Retrieve a Dataset Sync with the given ID
*DatasetSyncsApi* | [**patch_dataset_syncs_id**](docs/DatasetSyncsApi.md#patch_dataset_syncs_id) | **PATCH** /dataset-syncs/{id} | Update provided fields of Dataset Sync with given ID
*DatasetSyncsApi* | [**post_dataset_syncs_management_terminate_connection**](docs/DatasetSyncsApi.md#post_dataset_syncs_management_terminate_connection) | **POST** /dataset-sync-management | Terminate a Dataset-Sync Connection
*DatasetSyncsApi* | [**post_dataset_syncs_origin**](docs/DatasetSyncsApi.md#post_dataset_syncs_origin) | **POST** /dataset-syncs | Create Sync Key (Create Origin Dataset Sync)
*DatasetSyncsApi* | [**post_dataset_syncs_replica**](docs/DatasetSyncsApi.md#post_dataset_syncs_replica) | **POST** /dataset-syncs?postType&#x3D;replica | Create and activate a Dataset Sync from key (Create Replica Dataset Sync)
*DatasetSyncsApi* | [**put_dataset_syncs_id**](docs/DatasetSyncsApi.md#put_dataset_syncs_id) | **PUT** /dataset-syncs/{id} | Update Dataset Sync with the given ID
*DatasetsApi* | [**delete_datasets_id**](docs/DatasetsApi.md#delete_datasets_id) | **DELETE** /datasets/{id} | Remove Dataset with given ID
*DatasetsApi* | [**get_datasets**](docs/DatasetsApi.md#get_datasets) | **GET** /datasets | Retrieve a list of datasets
*DatasetsApi* | [**get_datasets_id**](docs/DatasetsApi.md#get_datasets_id) | **GET** /datasets/{id} | Retrieve a Dataset with the given ID
*DatasetsApi* | [**patch_datasets_id**](docs/DatasetsApi.md#patch_datasets_id) | **PATCH** /datasets/{id} | Updates the provided fields of Dataset with given ID
*DatasetsApi* | [**post_datasets**](docs/DatasetsApi.md#post_datasets) | **POST** /datasets | Create a new Dataset
*DatasetsApi* | [**put_datasets_id**](docs/DatasetsApi.md#put_datasets_id) | **PUT** /datasets/{id} | Updates Dataset with given ID
*GroupMembershipsApi* | [**delete_group_memberships_id**](docs/GroupMembershipsApi.md#delete_group_memberships_id) | **DELETE** /groups-memberships/{id} | Deletes the group membership with the given ID
*GroupMembershipsApi* | [**get_group_memberships**](docs/GroupMembershipsApi.md#get_group_memberships) | **GET** /group-memberships | Retrieves a list of group memberships
*GroupMembershipsApi* | [**get_group_memberships_id**](docs/GroupMembershipsApi.md#get_group_memberships_id) | **GET** /groups-memberships/{id} | Retrieves a group membership with the given id
*GroupMembershipsApi* | [**patch_group_memberships_id**](docs/GroupMembershipsApi.md#patch_group_memberships_id) | **PATCH** /groups-memberships/{id} | Updates the provided properties of group membership with the given ID
*GroupMembershipsApi* | [**post_group_memberships**](docs/GroupMembershipsApi.md#post_group_memberships) | **POST** /group-memberships | Create a new group membership
*GroupMembershipsApi* | [**put_group_memberships_id**](docs/GroupMembershipsApi.md#put_group_memberships_id) | **PUT** /groups-memberships/{id} | Updates the group membership with the given ID
*GroupsApi* | [**delete_groups_id**](docs/GroupsApi.md#delete_groups_id) | **DELETE** /groups/{id} | Removes the group with the given id
*GroupsApi* | [**get_groups**](docs/GroupsApi.md#get_groups) | **GET** /groups | Retrieves a list of groups from the groups service
*GroupsApi* | [**get_groups_id**](docs/GroupsApi.md#get_groups_id) | **GET** /groups/{id} | Retrieves a group with the given id from the service
*GroupsApi* | [**patch_groups_id**](docs/GroupsApi.md#patch_groups_id) | **PATCH** /groups/{id} | Updates the resource with the given id
*GroupsApi* | [**post_groups**](docs/GroupsApi.md#post_groups) | **POST** /groups | Create a new group
*GroupsApi* | [**put_groups_id**](docs/GroupsApi.md#put_groups_id) | **PUT** /groups/{id} | Updates the group with given id
*IndexesApi* | [**delete_indexes_id**](docs/IndexesApi.md#delete_indexes_id) | **DELETE** /indexes/{id} | Removes Index with the given ID
*IndexesApi* | [**get_indexes**](docs/IndexesApi.md#get_indexes) | **GET** /indexes | Retrieve list of Indexes
*IndexesApi* | [**get_indexes_id**](docs/IndexesApi.md#get_indexes_id) | **GET** /indexes/{id} | Retrieve Index with given ID
*IndexesApi* | [**patch_indexes_id**](docs/IndexesApi.md#patch_indexes_id) | **PATCH** /indexes/{id} | Updates fields provided for Index with the ID given
*IndexesApi* | [**post_indexes**](docs/IndexesApi.md#post_indexes) | **POST** /indexes | Create a new Index
*IndexesApi* | [**put_indexes_id**](docs/IndexesApi.md#put_indexes_id) | **PUT** /indexes/{id} | Updates Index with given ID
*IngestApi* | [**post_ingest**](docs/IngestApi.md#post_ingest) | **POST** /ingest | Create an Ingest Job
*JobsApi* | [**get_jobs**](docs/JobsApi.md#get_jobs) | **GET** /jobs | Retrieves list of Jobs
*JobsApi* | [**get_jobs_id**](docs/JobsApi.md#get_jobs_id) | **GET** /jobs/{id} | Retrieve Job with the given ID
*JobsApi* | [**patch_jobs_id**](docs/JobsApi.md#patch_jobs_id) | **PATCH** /jobs/{id} | Updates fields provided for Jobs with the ID given
*JobsApi* | [**post_jobs**](docs/JobsApi.md#post_jobs) | **POST** /jobs | Creates a new Job
*JobsApi* | [**put_jobs_id**](docs/JobsApi.md#put_jobs_id) | **PUT** /jobs/{id} | Updates Job with the ID given
*QueryApi* | [**post_lucene_query**](docs/QueryApi.md#post_lucene_query) | **POST** /query/lucene | Query a dataset using the lucene query syntax
*QueryApi* | [**post_lucene_query_document**](docs/QueryApi.md#post_lucene_query_document) | **POST** /query/document/lucene | Query document for a dataset using the lucene query syntax
*QueryApi* | [**post_query**](docs/QueryApi.md#post_query) | **POST** /query | Query a dataset
*QueryApi* | [**post_query_summary**](docs/QueryApi.md#post_query_summary) | **POST** /query/datasets/summary | Query all datasets
*ReadApi* | [**get_splits_id**](docs/ReadApi.md#get_splits_id) | **GET** /splits/{datasetId} | Get record ranges of partitions
*ReadApi* | [**post_read**](docs/ReadApi.md#post_read) | **POST** /read | Read records
*ReadApi* | [**post_read_in_sequence**](docs/ReadApi.md#post_read_in_sequence) | **POST** /readInSequence | Read records from dataset in sequence
*SegmentsApi* | [**get_segments**](docs/SegmentsApi.md#get_segments) | **GET** /segments | Retrieves a list of Segments
*SegmentsApi* | [**get_segments_id**](docs/SegmentsApi.md#get_segments_id) | **GET** /segments/{id} | Retrieves Segment with the given ID
*ServeMediaApi* | [**get_serve_media**](docs/ServeMediaApi.md#get_serve_media) | **GET** /serve-media/{datasetId}?documentId&#x3D;documentId | Performs authentication and authorization checks for users before providing a media url
*SourceTypesApi* | [**get_source_types**](docs/SourceTypesApi.md#get_source_types) | **GET** /source-types | Retrieves list of Source Types
*SourceTypesApi* | [**get_source_types_id**](docs/SourceTypesApi.md#get_source_types_id) | **GET** /source-types/{id} | Retrieves Source Type with the given ID
*StorageApi* | [**delete_dataset_document_query**](docs/StorageApi.md#delete_dataset_document_query) | **POST** /storage/datasets/{datasetId}/deleteDocuments/query | Deletes documents from a dataset based on a given query
*StorageApi* | [**delete_dataset_record_id**](docs/StorageApi.md#delete_dataset_record_id) | **POST** /storage/datasets/{datasetId}/deleteRecords | Deletes records from a dataset based on the given ids
*StorageApi* | [**delete_dataset_record_query**](docs/StorageApi.md#delete_dataset_record_query) | **POST** /storage/datasets/{datasetId}/deleteRecords/query | Deletes records from a dataset based on a given query
*StorageApi* | [**post_clear_dataset**](docs/StorageApi.md#post_clear_dataset) | **POST** /storage/datasets/{datasetId}/clear | Clear a dataset
*UploadsApi* | [**post_uploads**](docs/UploadsApi.md#post_uploads) | **POST** /uploads | Creates a new Upload
*UsersApi* | [**delete_users_id**](docs/UsersApi.md#delete_users_id) | **DELETE** /users/{id} | Removes the user by given id
*UsersApi* | [**get_users**](docs/UsersApi.md#get_users) | **GET** /users | Retrieves a list of users
*UsersApi* | [**get_users_id**](docs/UsersApi.md#get_users_id) | **GET** /users/{id} | Retrieves a user with the given id from the users service.
*UsersApi* | [**patch_users_id**](docs/UsersApi.md#patch_users_id) | **PATCH** /users/{id} | Updates the resource by id for the fields provided
*UsersApi* | [**post_user**](docs/UsersApi.md#post_user) | **POST** /users | Create a user
*UsersApi* | [**put_users_id**](docs/UsersApi.md#put_users_id) | **PUT** /users/{id} | Updates a user with given id
*WorkspacesApi* | [**get_workspaces**](docs/WorkspacesApi.md#get_workspaces) | **GET** /workspaces | Retrieves a list of workspaces
*WorkspacesApi* | [**get_workspaces_id**](docs/WorkspacesApi.md#get_workspaces_id) | **GET** /workspaces/{id} | Retrieves Workspace with given ID
*WorkspacesApi* | [**patch_workspaces_id**](docs/WorkspacesApi.md#patch_workspaces_id) | **PATCH** /workspaces/{id} | Updates provided fields of Workspace with the ID given
*WorkspacesApi* | [**post_workspaces**](docs/WorkspacesApi.md#post_workspaces) | **POST** /workspaces | Creates a new Workspace
*WorkspacesApi* | [**put_workspaces_id**](docs/WorkspacesApi.md#put_workspaces_id) | **PUT** /workspaces/{id} | Updates Workspace with the ID given
*WriteApi* | [**post_v2_write_id**](docs/WriteApi.md#post_v2_write_id) | **POST** /v2/write/{datasetId} | Write records (v2)
*WriteApi* | [**post_write_id**](docs/WriteApi.md#post_write_id) | **POST** /write/{datasetId} | Write records


## Documentation For Models

 - [AbacLabelParserPaginator](docs/AbacLabelParserPaginator.md)
 - [AbacLabelParsers](docs/AbacLabelParsers.md)
 - [AbacLabelParsersList](docs/AbacLabelParsersList.md)
 - [AccessControlLabel](docs/AccessControlLabel.md)
 - [ApiError](docs/ApiError.md)
 - [Application](docs/Application.md)
 - [ApplicationCreateRequest](docs/ApplicationCreateRequest.md)
 - [ApplicationCreateRequestRequiredDatasetAccessInner](docs/ApplicationCreateRequestRequiredDatasetAccessInner.md)
 - [ApplicationList](docs/ApplicationList.md)
 - [ApplicationPaginator](docs/ApplicationPaginator.md)
 - [ApplicationPatchRequest](docs/ApplicationPatchRequest.md)
 - [ApplicationRequiredDatasetAccessInner](docs/ApplicationRequiredDatasetAccessInner.md)
 - [ApplicationUpdateRequest](docs/ApplicationUpdateRequest.md)
 - [Attribute](docs/Attribute.md)
 - [AttributeAssignment](docs/AttributeAssignment.md)
 - [AttributeAssignmentCreateRequest](docs/AttributeAssignmentCreateRequest.md)
 - [AttributeAssignmentList](docs/AttributeAssignmentList.md)
 - [AttributeAssignmentPaginator](docs/AttributeAssignmentPaginator.md)
 - [AttributeAssignmentPatchRequest](docs/AttributeAssignmentPatchRequest.md)
 - [AttributeAssignmentUpdateRequest](docs/AttributeAssignmentUpdateRequest.md)
 - [AttributeCreateRequest](docs/AttributeCreateRequest.md)
 - [AttributeList](docs/AttributeList.md)
 - [AttributePaginator](docs/AttributePaginator.md)
 - [AttributePatchRequest](docs/AttributePatchRequest.md)
 - [AttributeUpdateRequest](docs/AttributeUpdateRequest.md)
 - [AuditLogConfiguration](docs/AuditLogConfiguration.md)
 - [AuditLogConfigurationList](docs/AuditLogConfigurationList.md)
 - [AuditLogConfigurationPaginator](docs/AuditLogConfigurationPaginator.md)
 - [AuditLogEvent](docs/AuditLogEvent.md)
 - [AuditLogEventList](docs/AuditLogEventList.md)
 - [AuditLogPaginator](docs/AuditLogPaginator.md)
 - [Authentication](docs/Authentication.md)
 - [AuthenticationDetails](docs/AuthenticationDetails.md)
 - [AuthenticationDetailsAuthentication](docs/AuthenticationDetailsAuthentication.md)
 - [AuthenticationDetailsAuthenticationPayload](docs/AuthenticationDetailsAuthenticationPayload.md)
 - [AuthenticationDetailsUser](docs/AuthenticationDetailsUser.md)
 - [AuthenticationList](docs/AuthenticationList.md)
 - [AuthenticationSSO](docs/AuthenticationSSO.md)
 - [BatchWriteRequest](docs/BatchWriteRequest.md)
 - [ConnectionInfo](docs/ConnectionInfo.md)
 - [CustomIdentityProvider](docs/CustomIdentityProvider.md)
 - [CustomIdentityProviderList](docs/CustomIdentityProviderList.md)
 - [DataSourceParams](docs/DataSourceParams.md)
 - [Dataset](docs/Dataset.md)
 - [DatasetCreateRequest](docs/DatasetCreateRequest.md)
 - [DatasetCurrentUserPermissions](docs/DatasetCurrentUserPermissions.md)
 - [DatasetList](docs/DatasetList.md)
 - [DatasetPaginator](docs/DatasetPaginator.md)
 - [DatasetPatchRequest](docs/DatasetPatchRequest.md)
 - [DatasetPermission](docs/DatasetPermission.md)
 - [DatasetPermissionCreateRequest](docs/DatasetPermissionCreateRequest.md)
 - [DatasetPermissionList](docs/DatasetPermissionList.md)
 - [DatasetPermissionPaginator](docs/DatasetPermissionPaginator.md)
 - [DatasetPermissionPatchRequest](docs/DatasetPermissionPatchRequest.md)
 - [DatasetPermissionUpdateRequest](docs/DatasetPermissionUpdateRequest.md)
 - [DatasetSync](docs/DatasetSync.md)
 - [DatasetSyncList](docs/DatasetSyncList.md)
 - [DatasetSyncManagementTerminateConnectionRequest](docs/DatasetSyncManagementTerminateConnectionRequest.md)
 - [DatasetSyncPaginator](docs/DatasetSyncPaginator.md)
 - [DatasetSyncPatchRequest](docs/DatasetSyncPatchRequest.md)
 - [DatasetSyncUpdateRequest](docs/DatasetSyncUpdateRequest.md)
 - [DatasetUpdateRequest](docs/DatasetUpdateRequest.md)
 - [DeleteDocumentByQueryRequest](docs/DeleteDocumentByQueryRequest.md)
 - [DeleteRecordByIdRequest](docs/DeleteRecordByIdRequest.md)
 - [DeleteRecordByQueryRequest](docs/DeleteRecordByQueryRequest.md)
 - [ErrorCode](docs/ErrorCode.md)
 - [GetServeMedia200Response](docs/GetServeMedia200Response.md)
 - [Group](docs/Group.md)
 - [GroupCreateRequest](docs/GroupCreateRequest.md)
 - [GroupList](docs/GroupList.md)
 - [GroupMembership](docs/GroupMembership.md)
 - [GroupMembershipCreateRequest](docs/GroupMembershipCreateRequest.md)
 - [GroupMembershipList](docs/GroupMembershipList.md)
 - [GroupMembershipPaginator](docs/GroupMembershipPaginator.md)
 - [GroupMembershipPatchRequest](docs/GroupMembershipPatchRequest.md)
 - [GroupMembershipUpdateRequest](docs/GroupMembershipUpdateRequest.md)
 - [GroupPaginator](docs/GroupPaginator.md)
 - [GroupPatchRequest](docs/GroupPatchRequest.md)
 - [GroupUpdateRequest](docs/GroupUpdateRequest.md)
 - [Index](docs/Index.md)
 - [IndexList](docs/IndexList.md)
 - [IndexPaginator](docs/IndexPaginator.md)
 - [IngestCreateRequest](docs/IngestCreateRequest.md)
 - [Job](docs/Job.md)
 - [JobList](docs/JobList.md)
 - [JobPaginator](docs/JobPaginator.md)
 - [JsonRecord](docs/JsonRecord.md)
 - [KeycloakProviderConfiguration](docs/KeycloakProviderConfiguration.md)
 - [KoverseDocumentMetadata](docs/KoverseDocumentMetadata.md)
 - [LuceneQueryRequest](docs/LuceneQueryRequest.md)
 - [OriginDatasetSyncCreateRequest](docs/OriginDatasetSyncCreateRequest.md)
 - [Query](docs/Query.md)
 - [QueryDatasetsSummary](docs/QueryDatasetsSummary.md)
 - [QueryDatasetsSummaryDatasetsInner](docs/QueryDatasetsSummaryDatasetsInner.md)
 - [QueryDatasetsSummaryRequest](docs/QueryDatasetsSummaryRequest.md)
 - [QueryDocumentLuceneRequest](docs/QueryDocumentLuceneRequest.md)
 - [QueryDocumentLuceneResponse](docs/QueryDocumentLuceneResponse.md)
 - [QueryDocumentLuceneResponseRecordsInner](docs/QueryDocumentLuceneResponseRecordsInner.md)
 - [ReadRangeRequest](docs/ReadRangeRequest.md)
 - [RecordBatch](docs/RecordBatch.md)
 - [ReindexRequest](docs/ReindexRequest.md)
 - [ReplicaDatasetSyncCreateRequest](docs/ReplicaDatasetSyncCreateRequest.md)
 - [SecurityLabelInfoParams](docs/SecurityLabelInfoParams.md)
 - [Segment](docs/Segment.md)
 - [SegmentList](docs/SegmentList.md)
 - [SegmentPaginator](docs/SegmentPaginator.md)
 - [SequenceReadRequest](docs/SequenceReadRequest.md)
 - [SourceTypes](docs/SourceTypes.md)
 - [SourceTypesList](docs/SourceTypesList.md)
 - [SplitPoints](docs/SplitPoints.md)
 - [StripeLatestCharge](docs/StripeLatestCharge.md)
 - [StripeLatestCharge1](docs/StripeLatestCharge1.md)
 - [SyncKafkaConsumerGroupId](docs/SyncKafkaConsumerGroupId.md)
 - [SyncSetupOrigin](docs/SyncSetupOrigin.md)
 - [SyncSetupReplica](docs/SyncSetupReplica.md)
 - [TerminateConnectionResponse](docs/TerminateConnectionResponse.md)
 - [TransferResourceRequest](docs/TransferResourceRequest.md)
 - [TransferResourceRequestList](docs/TransferResourceRequestList.md)
 - [UploadResponse](docs/UploadResponse.md)
 - [User](docs/User.md)
 - [UserCreateRequest](docs/UserCreateRequest.md)
 - [UserList](docs/UserList.md)
 - [UserPaginator](docs/UserPaginator.md)
 - [UserPatchRequest](docs/UserPatchRequest.md)
 - [UserUpdateRequest](docs/UserUpdateRequest.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceCreateRequest](docs/WorkspaceCreateRequest.md)
 - [WorkspaceCreateRequestSubscription](docs/WorkspaceCreateRequestSubscription.md)
 - [WorkspaceCreateRequestSubscriptionSubscriptionItemIds](docs/WorkspaceCreateRequestSubscriptionSubscriptionItemIds.md)
 - [WorkspaceList](docs/WorkspaceList.md)
 - [WorkspacePaginator](docs/WorkspacePaginator.md)
 - [WorkspacePatchRequest](docs/WorkspacePatchRequest.md)
 - [WorkspaceSubscription](docs/WorkspaceSubscription.md)
 - [WorkspaceSubscriptionSubscriptionItemIds](docs/WorkspaceSubscriptionSubscriptionItemIds.md)
 - [WorkspaceUpdateRequest](docs/WorkspaceUpdateRequest.md)
 - [WriteBatchResponse](docs/WriteBatchResponse.md)


## Documentation For Authorization


## Bearer

- **Type**: Bearer authentication (JWT)


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in kdp_api.apis and kdp_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from kdp_api.api.default_api import DefaultApi`
- `from kdp_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import kdp_api
from kdp_api.apis import *
from kdp_api.models import *
```

